# -*- coding: UTF-8 -*-
from java.io import File
from com.huawei.ism.tool.obase.exception import ToolException
from disklogConf import disklogConf
from cliFactory import cli
from config import config
import codecs
import os
import re
import resource
import shutil
import sys
try:
    reload(sys)
    sys.setdefaultencoding('utf-8')
except:
    pass
import time
import threading
import traceback


class systemMode():

    @staticmethod
    def enterDeveloperMode(devObj):
        '''
        @summary: 进入developer模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        #发送命令
        cmd = "change user_mode current_mode user_mode=developer"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        
        if re.search("developer:", cliRet, re.IGNORECASE):
            return True
        
        if None == re.search("Password:", cliRet, re.IGNORECASE):
            log.info(devObj, "enterDeveloperMode fail")
            return False
        
        developerPwd = util.getDevDeveloperPwd(devObj)
        #判断developer密码是否为空
        if None == developerPwd or "" == developerPwd :
            del developerPwd
            return False
        
        cliRet = ""
        (isSuccess, cliRet) =  cli.executeCmdNoLogTimeout(devObj, developerPwd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        del developerPwd
        if None == re.search("developer:", cliRet, re.IGNORECASE):
            log.info(devObj, "enterDeveloperMode fail")
            return False
        
        return True

    @staticmethod
    def enterMinisystemMode(devObj):
        '''
        @summary: 进入minisystem模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        #发送命令
        if not systemMode.enterDeveloperMode(devObj):
            return False
        
        (isSuccess, miniRet) = cli.executeCmd(devObj, 'minisystem')
        if not isSuccess:
            util.addPyDetailMsg(devObj, 'enter.minisystem.mode.failed')
            systemMode.developerMode2CliMode(devObj)
            return False
        
        if miniRet.strip().endswith('minisystem>'):
            return True
        else:
            util.addPyDetailMsg(devObj, 'enter.minisystem.mode.failed')
            systemMode.developerMode2CliMode(devObj)
            return False
            
    @staticmethod
    def developerMode2CliMode(devObj):
        '''
        @summary: developer模式下退回到cli模式
        @param cliRet: devObj=上下文对象
        '''        
        (isSuccess, cliRet) = cli.executeCmd(devObj, "show system general")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return
        
        #密码输入错误时及正常情况从developer模式下退出
        if ("Password" in cliRet) or ("developer:/>" in cliRet):
                    
            (isSuccess, cliRet) = cli.executeCmd(devObj, "exit")
            if not isSuccess:
                util.setPyDetailMsg(devObj, "dev.conn.failure")
                return
            
            cliRet = cli.executeCmd(devObj, "exit")
            log.info(devObj, "Sequence[5] change to cli model")
            index = 0
            while ("admin:/>" not in cliRet):
                index = index + 1
                (isSuccess, cliRet) = cli.executeCmd(devObj, "exit")
                if not isSuccess:
                    util.setPyDetailMsg(devObj, "dev.conn.failure")
                    return
                if "Are you sure to exit?(y/n):" in cliRet:
                    (isSuccess, cliRet) = cli.executeCmd(devObj, "n")
                    if not isSuccess:
                        util.setPyDetailMsg(devObj, "dev.conn.failure")
                        return
                if index > cli.CLI_ENTER_DEVELOPER_MODEL_MAX_RETRYS:
                    break
    
    @staticmethod
    def isInDeveloperMode(devObj):
        '''
        @summary: 判断当前是否在developer模式下
        @param cliRet: cli回显
        @return: 
            True: 当前在developer模式下
            False: 当前不在developer模式下
        '''
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, "show system general")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if re.search(cli.CLI_DEVELOPER_MODEL_FLAG, cliRet, re.IGNORECASE):
            return True
        return False
  
    @staticmethod
    def enterDiagnoseMode(devObj):
        '''
        @summary: 进入diagnose模式
        @param cliRet: devObj=上下文对象
        @return: True=成功，False=失败
        '''
        if not systemMode.enterDeveloperMode(devObj):
            return False
        
        #发送命令
        (isSuccess, cliRet) = cli.executeCmd(devObj, "debug")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "enter.diagnose.mode.failed")
            systemMode.developerMode2CliMode(devObj)
            return False
        
        if cliRet.strip().endswith("diagnose>"):
            return True
        else:
            log.error(devObj, "Enter in diagnose mode failed")
            util.setPyDetailMsg(devObj, "enter.diagnose.mode.failed")
            systemMode.developerMode2CliMode(devObj)
            return False
             
    @staticmethod
    def exitDiagnoseOrMinisystem(devObj):
        '''
        @summary: 从小系统或者diagnose模式下退回到cli模式
        @param cliRet: devObj=上下文对象
        '''
        (isSuccess, exitRet) = cli.executeCmd(devObj, "exit")
        if not isSuccess:
            util.setPyDetailMsg(devObj, "exit.diagnose.minisystem.failed")
            return
        
        if exitRet.strip().endswith('(y/n)'):
            (isSuccess, exitRet) = cli.executeCmd(devObj, "y")
            
        systemMode.developerMode2CliMode(devObj)
        return        
             
    @staticmethod
    def isScpCmdExist(devObj):
        '''
        @summary: 判断小系统模式下是否存在'scp'命令.
        @param devObj: devObj=上下文对象
        '''
        (isSuccess, scpRet) = cli.executeCmd(devObj, "scp")
        if not isSuccess:
            util.addPyDetailMsg(devObj, "qry.whether.scp.cmd.exist.failed")
            return False, False
        
        if 'usage: scp' in scpRet:
            return True, True
        else:
            return True, False
        
    @staticmethod    
    def deletePath(devObj, pathName):
        toDeletRmtPthCmd = 'rm -rf ' + pathName
        isExeSucc, delRet = cli.executeCmdWithTimout(devObj, toDeletRmtPthCmd, 60)
        while isExeSucc and 'y/n' in delRet:
            isExeSucc, delRet = cli.executeCmdWithTimout(devObj, 'y', 60)    
        
    @staticmethod    
    def deleteDirectory(devObj, pathName):
        sftp = util.getSftp(devObj)
        try:
            sftp.deleteDir(pathName)
        except ToolException, te:
            log.info(devObj, "Delete directory by SFTP exception:" + unicode(te))
            try:
                systemMode.deletePath(devObj, pathName)
            except Exception, e:
                log.error(devObj, 'Delete directory by CLI exception, directory:' + unicode(pathName) + unicode(e))
            
    @staticmethod
    def heartbeatToPeer(devObj, usrPwd):
        '''
                    函数名称: heartbeatToPeer
                    功能说明: 从本端minisystem模式心跳到对端，此方法须在minisystem模式下调用
                    输入参数: devObj, usrPwd
                    输出参数: 无
                    返 回 值: True or False    
        '''
        try:
            (isSuccess, rec) = cli.executeCmdWithTimout(devObj, 'sshtoremote', 60)
            if not isSuccess:
                log.info(devObj, "execute sshtoremote failed.")  
                return False
            
            log.info(devObj, "XXXX:" + rec) 
             
            if "System is not ready" in rec:
                log.info(devObj, "execute sshtoremote failed")  
                return False
            
            if "password:" in rec:
                (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, usrPwd, 60)
                if not isSuccess:
                    log.info(devObj, "sshtoremote failed when inputting user password.")
                    return False
                
                if cli.TOOLKIT_SEND_CMD_TIME_OUT == rec:
                    log.info(devObj, "[heartbeatToPeer] execute cmd timeout.")  
                    return False
                
                if  rec.endswith(":/>"):    #对端正常不进行日志 收集,并且退出对端。
                    (isSuccessExit, recExit) = cli.executeCmdWithTimout(devObj, "exit", 60)
                    if not isSuccessExit:
                        log.info(devObj, recExit) 
                        return False
                    
                    (isSuccessY, recY) = cli.executeCmdWithTimout(devObj, "y", 60)
                    if not isSuccessY:
                        log.info(devObj, recY) 
                        return False
                    
                    if "Storage:~ #" in recY:  #兼容debug包
                        (isSuccessExit, recExit) = cli.executeCmdWithTimout(devObj, "exit", 60)
                        if not isSuccessExit:
                            log.info(devObj, recExit) 
                            return False
                    
                    log.info(devObj, "[heartbeatToPeer] the Opposite Equip is right need not to collect")  
                    return "Normal"
                
                if rec.strip().endswith(cli.CLI_RET_END_FLAG): 
                    return True
                
            log.info(devObj, "[heartbeatToPeer] heart to peer failed.")
            return False
        except:
            log.error(devObj, "[heartbeatToPeer] catch trace backxxx:" + unicode(traceback.print_exc()))
            return False
        
             
class device():
    @staticmethod
    def getEngineNum(devObj):
        (isSuccess, qryEncRet) = cli.executeCmdWithTimout(devObj, cli.QRY_ENGINE_CMD, 60)
        if not isSuccess:
            log.error(devObj, "execute show enclosure failed.")
            util.addPyDetailMsg(devObj, 'query.dev.is.6U4CTRL.dev.failed')
            return False, 0
        else:
            engNum = 0
            for line in qryEncRet.splitlines()[1:]:
                line = line.strip()
                fields = line.split()
                if line and len(fields) > 2 and fields[1].strip() in ['Engine', 'engine']:
                    engNum +=1
                    
        return True, engNum
        
    @staticmethod
    def is6U4CtrlDevice(devObj):
        (isSuccess, qryEncRet) = cli.executeCmdWithTimout(devObj, 'show enclosure', 60)
        if not isSuccess:
            log.error(devObj, "execute show enclosure failed.")
            util.addPyDetailMsg(devObj, 'query.dev.is.6U4CTRL.dev.failed')
            return False, False
        else:
            if re.search('6U 4 Controllers Enclosure', qryEncRet, re.I):
                return True, True
            else:
                return True, False
    
    @staticmethod
    def getDeviceSn(devObj):
        '''
                    获取设备SN号
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        sn = devNode.getDeviceSerialNumber()
        
        return sn
    
    @staticmethod
    def getDeviceType(devObj):
        '''
                    获取设备具体型号,如S5600T
        '''
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        devType = devNode.getDeviceType()
        
        return devType
    
    @staticmethod
    def isX86Architecture(devObj):
        devType = str(device.getDeviceType(devObj)).strip()
        return devType not in config.ARM_ARCHITECTURE_DEV_TYPE_LIST
    
    @staticmethod
    def getDeviceVersion(devObj):
        '''
                    获取设备版本号,如：V200R002C11
        '''
        
        devNode = devObj.get("devNode")
        
        if None == devNode:
            return ""
        
        version = devNode.getProductVersion()
        
        return version
        
    @staticmethod
    def getDeviceSsh(devObj):
        '''
                    获取设备版本号,如：V200R002C11
        '''
        ssh = devObj.get("SSH")
        
        return ssh
    
    @staticmethod
    def getDevicePassword(devObj):
        '''
                    获取设备密码，心跳连接
        '''
        
        password = devObj.get("password")
        
        if None == password:
            return ""
        
        return password
        
    @staticmethod
    def getBond0IP(devObj):
        '''
                    通过解析ifconfig命令获取控制器心跳IP,，如果获取失败，返回空字符串。
        '''
        qryBond0Cmd = "ifconfig bond0"
        (isCmdExeSucc, bond0Ret) = cli.executeCmdWithTimout(devObj, qryBond0Cmd, 60)
        if not isCmdExeSucc:
            log.error(devObj, "Execute ifconfig bond0 failed.")
            return ''
        
        for line in bond0Ret.splitlines():
            if line.strip().startswith("inet addr:") and '127.127.127' in line:
                return line.split(':')[1].split()[0].strip()
            if line.strip().startswith("inet") and '127.127.127' in line:
                return line.split()[1].strip()
            
        return ''
    
    @staticmethod
    def getPeerBond0IP(devObj):
        '''
                    通过解析ifconfig命令获取控制器心跳IP
        '''
        thisBond0Ip = device.getBond0IP(devObj)
        if not thisBond0Ip:
            return ''
        elif thisBond0Ip == '127.127.127.10':
            return '127.127.127.11'
        elif thisBond0Ip == '127.127.127.11':
            return '127.127.127.10'
        else:
            return ''
        
    @staticmethod
    def getFreeMemInAdmin(devObj):
        '''
        cli模式下查询当前控制器剩余内存,对CLI模式无影响。
        '''
        if not systemMode.enterMinisystemMode(devObj):
            return -1
        
        try:
            (isCmdExeSucc, memRet) = cli.executeCmdWithTimout(devObj, 'free -m', 60)
            if not isCmdExeSucc:
                return -1
            
            for memLine in memRet.splitlines():
                if 'Mem:' in memLine:
                    return int(memLine.split()[3].strip())
        except:
            return -1
        finally:
            systemMode.exitDiagnoseOrMinisystem(devObj)    

    @staticmethod
    def getFreeMemInMinisystem(devObj):
        '''
        minisystem模式下查询当前控制器剩余内存,对CLI模式无影响。
        '''
        try:
            (isCmdExeSucc, memRet) = cli.executeCmdWithTimout(devObj, 'free -m', 60)
            if not isCmdExeSucc:
                return -1
            
            for memLine in memRet.splitlines():
                if 'Mem:' in memLine:
                    return int(memLine.split()[3].strip())
        except:
            return -1
'''
信息收集，基本的工具方法
'''
class util():
    @staticmethod
    def check_contain_chinese(check_str):
        for ch in check_str.decode('utf-8'):
            if u'\u4e00' <= ch <= u'\u9fff':
                return True
        return False

    @staticmethod
    def queryResultWithNoRecord(cliRet):
        '''
        @summary: 判断回显是否为Command executed successfully
        @param cliRet: cli回显
        @return:
            True: cli回显中包含Command executed successfully
            False: cli回显中不包含Command executed successfully
        '''
        CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
        if re.search(CLI_EXECUTE_CMD_SUCCESS, cliRet, re.IGNORECASE):
            return True
        return False

    @staticmethod
    def getLoginPasswd(devObj):
        devNode = devObj.get("devNode")
        password = devNode.getLoginUser().getPassword()
        return password

    @staticmethod
    def getPort(devObj):
        devNode = devObj.get("devNode")
        return str(devNode.getPort())
    
    @staticmethod
    def isSystemUpgrading(devObj):
        '''
                    函数名称: isSystemUpgrading
                    功能说明: 检验当前设备是否处于升级中
                    输入参数: devObj
                    输出参数: True, False
        '''
        flag = False
        cmd = "show system general"        
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return True
        
        cliList = cliRet.splitlines()
        #只关注最后一行回显
        if config.SYSTEM_RUNNING_STATUS_UPGRADING in cliList[-1]:
            util.setPyDetailMsg(devObj, 'system.isUpgrading')
            flag = True
        return flag
    @staticmethod
    def ping(devObj, ipV4):
        '''
        @summary: start ping process
        @param ipV4: IP address in V4 mode
        @return: isReachable : boolean
        '''        
        isParamValid = re.match("((2[0-4]\d|25[0-5]|[01]?\d\d?)\.){3}(2[0-4]\d|25[0-5]|[01]?\d\d?)",ipV4)
        if not isParamValid : 
            return False
        strCmd = "ping -c 5 " + ipV4
        (isSuccess, cliRet) = cli.executeCmdWithTimout(devObj, strCmd, 3*60)
        if not isSuccess:
            return False
        
        if re.search("ttl", cliRet, re.I):
            return True
        
        return False
          
    @staticmethod
    def checkSystemNormal(devObj):
        '''
                    函数名称: checkSystemNormal
                    功能说明: 检验当前设备是否normal
                    输入参数: devObj
                    输出参数: True, False
        '''
        flag = False
        cliRet = ""
        cmd = "show system general"        
        (isSuccess, cliRet) =  cli.executeCmdNoLogTimeout(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if re.search("System Name", cliRet, re.IGNORECASE):
            flag = True
        else:
            util.setPyDetailMsg(devObj, 'system.abnormal')
            
        return flag
    
    @staticmethod
    def getUserNameCli(devObj):
        '''
        @summary: 用CLI的方式，获取当前的用户名（当上下文对象中不存在用户名时，用到）
        @param cliRet: devObj=上下文对象
        @return: userName
        '''
        userName = ""        
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, "show system general")
        if not isSuccess:
            return (isSuccess, userName)
        
        #输入CLI回显是否有效
        if None == cliRet or "" == cliRet: 
            return (isSuccess, userName)
        
        #执行命令获取当前登录的用户名      
        lineList = cliRet.splitlines()
        #用户名一定包含在最后一行中
        if lineList[-1].find(cli.CLI_RET_END_FLAG):
            userName = lineList[-1].replace(" ","").replace(cli.CLI_RET_END_FLAG,"")
        return (isSuccess, userName)
    
    @staticmethod
    def getUsername(devObj):
        '''
        @summary: 获取上下文中的用户名
        @param cliRet: devObj=上下文对象
        @return: name
        '''
        isSuccess = True
        name = devObj.get("username")
        
        if None == name or "" == name: 
            (isSuccess, name) = util.getUserNameCli(devObj)
            
        return (isSuccess, name)
        
    @staticmethod
    def getUserPrivilege(devObj):
        '''
        @summary: 获取用户权限级别
        @param cliRet: devObj=上下文对象
        @return: userLevel
        '''
        userLevel = ""
        #首先获取用户名
        (isSuccess, userName) = util.getUsername(devObj)
        
        if not isSuccess:
            (isSuccess, userLevel)
        
        if None == userName or "" == userName:
            return (isSuccess, userLevel)
        
        log.info(devObj, "Get login name is:"+str(userName))
        
        #根据用户名，查询用户权限        
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(devObj, "show user user_name=" + userName)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return (isSuccess, userLevel)
        
        rec = cli.getCliTable2DictList(cliRet)
        if len(rec) == 0:
            return (isSuccess, userLevel)
        
        #获取用户权限的行信息
        level = rec[0]
        if "Level" in level:
            userLevel = level["Level"]
        
        return (isSuccess, userLevel)
    
    
    @staticmethod
    def checkUserPrivilege(devObj, type=None):
        '''
        @summary: 检查用户权限，用户权限为["Super_admin" 或  "Admin"],则返回True，否则返回False
        @param cliRet: devObj=上下文对象
        @return: userLevel
        '''
        result = False
        (isSuccess, userLevel) = util.getUserPrivilege(devObj)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return result
        
        privileges = ["Super_admin", "Admin"]
            
        if userLevel in privileges:
            result = True
        else:
            util.setPyDetailMsg(devObj, "user.level.low")
        
        return result
    
    
    @staticmethod
    def isChinese(devObj):
        '''
        @summary: 判断当前语言类型
        @param lang: 语言lang
        @return: 
            True: 中文
            False: 非中文
        '''
        lang = devObj.get("lang")
        if "zh" == lang:
            return True
        return False
    
    @staticmethod
    def getMsg(devObj, msg, args = ""):
        '''
        @summary: 获取资源信息
        @param cliRet: devObj=上下文对象, msg=资源脚本（resource.py）中对应的Key，args=占位符对应的值
        @return: msg
        '''
        if  None == msg or "" == msg:
            return ""
        
        lang = devObj.get("lang")
        if resource.MESSAGES_DICT.has_key(msg):
            msgDict = resource.MESSAGES_DICT.get(msg)
            msg = msgDict[lang]
        
        #若占位符的值不为”“，则天冲高占位符
        if "" != args:
            msg = msg % args
            
        return msg
    
    @staticmethod
    def setCollectAllInfo(devObj, flag):
        '''
        @summary: 设置是否部分收集成功
        @param flag: flag = True 该项收集成功，flag=False 该项部分收集成功
        '''
        devObj["collectAllInfo"] = flag
    
    @staticmethod
    def isExistDetailMsg(devObj):
        '''
        @summary: 判断错误信息是否已经设置
        @param devObj: 上下文对象
        @return: True or False
        '''
        msg = devObj["py_detail"]
        if None == msg or "" == msg:
            return False
        
        return True
    
    @staticmethod
    def initPyDetailMsg(devObj):
        '''
        @summary: 清除之前设置的错误信息
        @return: 无
        '''
        devObj["py_detail"] = ""
    
    @staticmethod
    def setPyDetailMsg(devObj, msg, args = ""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)
        
        devObj["py_detail"] = msg
        
    @staticmethod
    def addPyDetailMsg(devObj, msg, args = ""):
        '''
        @summary: 消息国际化
        @param lang: 语言lang
        @param msg: 消息
        @param args: 消息参数
        @return: 经过国际化处理后的消息
        '''
        msg = util.getMsg(devObj, msg, args)
        oldMsg = devObj["py_detail"]
        devObj["py_detail"] = (oldMsg + os.linesep + msg) if oldMsg else msg

    @staticmethod
    def getDevIp(devObj):
        '''
        @summary: 根据上下文，获取当前连接的IP
        @param cliRet: devObj=上下文对象
        @return: ip
        '''
        ip = devObj.get("devIp")
        return ip
    
    @staticmethod
    def getSftp(devObj):
        '''
        @summary: 根据上下文，获取sftp对象
        @param cliRet: devObj=上下文对象
        @return: sftp
        '''
        sftp = devObj.get("SFTP")
        return sftp
    
    @staticmethod
    def readFile(filePath):
        try:
            f = None
            f = open(filePath)
            info = f.read()
            return info
        except:
            return None
        finally:
            if None != f:
                f.close()
    
    @staticmethod
    def cleanDir(dir):
        '''
        @summary: 根据路径，删除路径
        @param cliRet: devObj=上下文对象，dir=路径
        @return: True or False
        '''
        if False == os.path.exists(dir):
            return True
        
        if False == os.path.isdir(dir):
            return False
        
        shutil.rmtree(dir, True)
        return True
    
    @staticmethod
    def writeFile(filePath, info, isAddFlag):
        try:
            file = None
            openType = "w"
            if True == isAddFlag:
                openType = "a"
            
            file = codecs.open(filePath, openType, "utf-8")
            file.write(info)
            return True
        except:
            return False
        finally:
            if None != file:
                file.close()
    
    @staticmethod
    def getLocalDir(devObj):
        '''
        @summary: 获取用户选择的路径
        @param cliRet:  devObj=上下文对象
        @return: localDir:用户选择的路径
        '''
        localDir = devObj.get("collectRetDir")
        return localDir
    
    @staticmethod
    def getLocalInfoPathByType(devObj, type):
        '''
        @summary: 获取信息存放的路径
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        localDir = devObj[config.COLLECT_INFO_LOCAL_PATH] + os.path.sep
        localDir = localDir + config.COLLECT_INFO_DIR_NAME[type] + os.path.sep
        if not os.path.exists(localDir):
            os.mkdir(localDir)
        
        return localDir
    
    @staticmethod
    def getCurrentDate():
        '''
        @summary: 获取本地当前时间
        @param cliRet: devObj=上下文对象
        @return: localDir
        '''
        result = str(time.strftime('%Y%m%d%H%M%S',time.localtime(time.time())))
        return result
    
    @staticmethod
    def getDevDeveloperPwd(devObj):
        '''
        @summary: 获取设备developer密码
        @param cliRet: devObj=上下文对象
        @return: pwd
        '''
        pwd = devObj.get("developer")
        return pwd
    
    @staticmethod
    def getCtrlIds(devObj):
        '''
        @summary: 获取当前环境下，控制器的ID列表
        @param cliRet: devObj=上下文对象
        @return: (Bool,list)，如：(True,[0A,0B])
        '''
        ctrlIds = []
        strCmd = "show controller general"
        (isSuccess, cliRet) = cli.executeCmdWithTimout(devObj, strCmd, 3*60)
        if not isSuccess:
            util.addPyDetailMsg(devObj, "dev.conn.failure")
            return (False, ctrlIds)
        
        list_cliRet = cliRet.splitlines()
        #根据CLI回显信息获取当前环境中，主控的ID
        for field in list_cliRet:
            
            field = field.replace(" ", "")
            if field.startswith("Controller"):
                list_ctrl = field.split(":")
                ctrlIds.append(list_ctrl[1])
        
        #判断是否获取到控制器的ID列表
        if len(ctrlIds) == 0:
            log.error(devObj, "show controller general:recrod " + str(cliRet))
            util.addPyDetailMsg(devObj, "qry.ctrl.id.failed")
            return (False, ctrlIds)
        
        return (True, ctrlIds)


    @staticmethod
    def changeCliMoreEnabled(devObj):
        '''
        @summary: 关闭回显more功能
        @return: True 命令执行成功
                False 命令执行失败
        '''
        flag = False
        cmd = "change cli more_enabled=no"        
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        if config.CLI_EXECUTE_CMD_SUCCESS in cliRet:
            flag = True
            
        return flag
    
    @staticmethod
    def getDiskNum(devObj):
        '''
        @summary: 获取系统中硬盘的数量
        @return: True|False 成功或者失败
                                        硬盘数量
        '''
        
        cmd = "show disk general|filterColumn include columnList=ID"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return (False, 0)
        
        dictList = cli.getCliTable2DictList(cliRet)
        return (isSuccess, len(dictList))

    @staticmethod
    def getVerticalCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取垂直表格形式的cli回显集合
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        CLI_RET_END_FLAG = ":/>"
        cliRetList = cliRet.encode("utf8").splitlines()
        dictList = []
        lineDict = {}
        for line in cliRetList:
            if CLI_RET_END_FLAG in line:
                break

            if re.search("^-+\r*\n*$", line):
                dictList.append(lineDict.copy())
                lineDict.clear()

            fields = line.split(" : ")
            if len(fields) < 2:
                continue

            key = fields[0].strip().decode("utf8")
            value = ":".join(fields[1:len(fields)]).strip().decode("utf8")

            if lineDict.has_key(key):
                key += "_" + str(str(lineDict.keys()).count(key + "_") + 1)
            lineDict.setdefault(key, value)

        if len(lineDict) > 0:
            dictList.append(lineDict.copy())

        return dictList

    @staticmethod
    def getHorizontalCliRet(cliRet):
        '''
        @summary: 按逐行字典的方式获取水平表格形式的cli回显集合
        @param cliRet: cli回显
        @return: 将表格形式cli回显处理为以表头为key，以项值为键的字典集合,处理不正常时，返回空集合
        '''
        try:
            headline = ""
            i = 0
            cliRetList = cliRet.encode("utf8").splitlines()
            for line in cliRetList:
                reg_headline = re.compile("^\s*-+(\s+-+)*\s*$")
                match_headline = reg_headline.search(line)
                if match_headline:
                    headline = match_headline.group()
                    break
                i += 1
            if headline == "" or i == 0 or i >= len(cliRetList) - 1:
                return []

            title = cliRetList[i - 1]
            field_words = cliRetList[(i + 1):]
            reg_split = re.compile("\s*-+\s*")
            tuple_idxs = []
            start_pos = 0
            end_pos = 0

            while (start_pos <= len(headline)):
                match = reg_split.search(headline, start_pos)
                if match:
                    end_pos = match.end()
                    tuple_idxs.append((start_pos, end_pos))
                    start_pos = end_pos
                else:
                    break

            keys = []
            for item in tuple_idxs:
                key = title[item[0]:item[1]].strip()
                if keys.count(key):
                    key += "_" + str(str(keys).count(key + "_") + 1)
                keys.append(key.decode("utf8"))

            requiredLineLen = tuple_idxs[-1][0]
            dictList = []
            for line in field_words:
                if cli.CLI_RET_END_FLAG in line:
                    break

                # 标题换行的场景
                if re.search("^-+(\s+-+)*\s*$", line):
                    continue

                if len(line.strip()) == 0:
                    continue

                if len(line) <= requiredLineLen:
                    continue

                vals = []
                for item in tuple_idxs:
                    vals.append(line[item[0]:item[1]].strip().decode("utf8"))
                dictList.append(dict(zip(keys, vals)))

            return dictList
        except:
            return []
    @staticmethod
    def getDiskIds(devObj):
        '''
        @summary: 获取系统中硬盘ID的列表
        @return: True|False 成功或者失败
                                        硬盘ID列表
        '''
    
        cmd = "show disk general|filterColumn include columnList=ID"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "qry.all.disk.ID.failed")
            return (False, 0)
        
        dskIdList = []
        for line in cliRet.splitlines():
            idLine = line.strip()
            if idLine.startswith("DAE") or idLine.startswith("ENG") or idLine.startswith('CTE'):
                dskIdList.append(idLine)
                
        return (isSuccess, dskIdList)


    @staticmethod
    def getDiskFwVersionInCliModel(devObj):
        '''
        @summary: 获取系统中硬盘FW,MODE的信息
        @return: True|False 成功或者失败
                                        硬盘ID列表
        '''
        diskFwInfoDict = {}
        cmd = "show disk general|filterColumn include columnList=ID,Firmware\sVersion,Model"
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.setPyDetailMsg(devObj, "qry.all.disk.ID.failed")
            return (False, {})
        diskInfoList = util.getHorizontalCliRet(cliRet)
        for diskInfo in diskInfoList:
            fw = diskInfo.get("Firmware Version", '')
            diskModel = diskInfo.get("Model", '')
            diskId = diskInfo.get("ID", '')
            diskFwInfoDict[diskId] = {"diskModel":diskModel, "diskId":diskId, "fw":fw}

        return True, diskFwInfoDict


    @staticmethod
    def getAllDiskSNAndId(devObj):
        '''
        @summary: 获取系统中硬盘SN的列表
        @return: True|False 成功或者失败
                                        硬盘ID列表
        '''
    
        cmd = ("show disk general |filterRow column=Health\sStatus predict=not predict2=equal_to value=Fault|"
            + "filterColumn include columnList=Serial\sNumber,ID")
        (isSuccess, cliRet) = cli.executeCmd(devObj, cmd)
        if not isSuccess:
            util.addPyDetailMsg(devObj, "qry.all.disk.SN.failed")
            return (False, [])
        
        dskIDSNTupList = []
        for line in cliRet.splitlines()[1:]:
            if len(line.split()) < 2:
                continue
            try:
                diskId = line.split()[0].strip()
                diskSn = line.split()[1].strip()
                if (not line.strip()) or 'admin' in line or 'Serial' in line or '------' in line:
                    continue
            except:
                log.error(devObj, 'Parse disk ID and SN exception:' + traceback.format_exc(None))
            else:
                dskIDSNTupList.append((diskId, diskSn))
        
        log.info(devObj, 'Query success, disk number is:' + unicode(len(dskIDSNTupList)))    
        return (True, dskIDSNTupList)

    @staticmethod
    def getAllDiskBlkDev(devObj):
        '''
        @summary: 获取系统中硬盘的盘符信息
        @return: 
                                        硬盘ID与盘符映射的字典.
        '''
    
        diskIdToBlkDevDict = {}
        if not systemMode.enterDiagnoseMode(devObj):
            return {}
        else:
            (isSuccess, cliRet) = cli.executeCmd(devObj, disklogConf.QUERY_DISK_DIAGNOSE_CMD)
            if not isSuccess:
                systemMode.exitDiagnoseOrMinisystem(devObj)
                util.setPyDetailMsg(devObj, "query.disk.blkdev.failed")
                return {}
            else:
                for diskLine in cliRet.splitlines():
                    if diskLine.strip().startswith("DAE") or diskLine.strip().startswith("ENG"):
                        diskId = diskLine.split()[0].strip()
                        diskBlkDev = diskLine.strip().split()[-1].strip()
                        diskIdToBlkDevDict[diskId] = diskBlkDev
        
        systemMode.exitDiagnoseOrMinisystem(devObj)
        log.error(devObj, "disklabelmap:" + unicode(diskIdToBlkDevDict))
        return diskIdToBlkDevDict

    @staticmethod
    def getAllDiskFullInfo(devObj):
        '''
        @summary: 获取系统中硬盘全部信息字典，包括盘符信息.
        @return: (True, allDiskInfoDict)
                                        硬盘ID到硬盘信息映射的字典
        '''
        
        qrySucc, allDiskIds = util.getDiskIds(devObj) 
        if not qrySucc:
            return False, {}
        
        diskBlkDevDict = util.getAllDiskBlkDev(devObj)
        if not diskBlkDevDict:
            return False, {}
        
        allDiskInfoDict = {}
        for diskId in allDiskIds:
            qryDiskInfoCmd = 'show disk general disk_id=' + diskId
            (qrySucc, qryDiskInfoRet) = cli.executeCmd(devObj, qryDiskInfoCmd)
            if not qrySucc:
                util.setPyDetailMsg(devObj, "qry.disk.detail.info.failed" % diskId)
                continue
            
            keys = []
            vals = []
            for diskInfoLine in qryDiskInfoRet.splitlines()[:-1]:
                if ":" in diskInfoLine:
                    kvList = diskInfoLine.strip().split(":")
                    keys.append(kvList[0].strip())
                    vals.append(kvList[1].strip())
                    
            if keys and vals:
                diskInfoDict = dict(zip(keys, vals))       
                diskInfoDict['BlkDev'] = diskBlkDevDict.get(diskId)
                allDiskInfoDict[diskId] = diskInfoDict
            
        log.info(devObj, "all dev full info map" + unicode(allDiskInfoDict))        
        return (True, allDiskInfoDict)  

    @staticmethod
    def normalizedDiskLocStr(diskLoc):
        '''
        @summary: 将硬盘位置信息标准化.
        @return: 标准化后的硬盘位置信息。
        @note: 此处是为了统一展示硬盘位置信息、和Java中的硬盘位置信息保持一致等.
        '''
        diskEncNum = diskLoc.strip().split(',')[0].strip().strip('(').strip()
        diskSlotNum = diskLoc.strip().split(',')[1].strip().strip(')').strip()
        return '(' + diskEncNum + ',' + diskSlotNum + ')'

    @staticmethod
    def isEmptyDir(dirname):
        contents = os.listdir(dirname)
        if not contents:
            return True
        else:
            emptyCnt = 0
            for f in contents:
                fn = os.path.join(dirname, f)
                if os.path.isfile(fn):
                    return False
                else:
                    if util.isEmptyDir(fn):
                        emptyCnt += 1
                    else:
                        return False
            return len(contents) == emptyCnt
            
    @staticmethod
    def getAllDiskInfoInAdmin(devObj):
        '''
        @summary: 获取系统中硬盘全部信息字典，包括盘符信息
        @return: (True, allDiskInfoDict)
                                        硬盘ID到硬盘信息映射的字典
        @note: 要求函数调用前在admin视图，调用后退出到admin视图.
        '''
        hasSensitiveDisks = False
        isQryOk, diskIdSnTupList = util.getAllDiskSNAndId(devObj)
        if not isQryOk:
            return {}, 0, hasSensitiveDisks
        
        diskIdList = map(lambda t: t[0], diskIdSnTupList)
        diskSnList = map(lambda t: t[1], diskIdSnTupList)
        
        sysDisNum = len(diskIdSnTupList)
        if not systemMode.enterMinisystemMode(devObj):
            return {}, sysDisNum, hasSensitiveDisks
    
        (isSuccess, miniRet) = cli.executeCmdWithTimout(devObj, 'showdiskinfo', 60 * 3)
        if not isSuccess:
            util.addPyDetailMsg(devObj, 'qry.disk.info.failed')
            systemMode.exitDiagnoseOrMinisystem(devObj)
            return {}, sysDisNum, hasSensitiveDisks
        try:
            idx = miniRet.find('All scsi luns')
            if -1 != idx:
                miniRet = miniRet[:idx]
                
            lines = miniRet.splitlines()
            
            diskMap = {}
            isParsingStart= False
            for line in lines:
                if not line.strip() or not isParsingStart:
                    sn, vendor, model, name, diskType, firmwareVer = '', '', '', '', '', '' 
                
                if line.strip().startswith('id '):
                    isParsingStart = True

                if isParsingStart and line.strip().startswith('DISK'):
                    diskType = line.split('type')[1].split(', port')[0].split('(')[0].strip()                

                if isParsingStart and line.strip().startswith('vendor'):
                    try:
                        keyLine = line.strip()
                        fds = keyLine.split(',')
                        sn = fds[3].strip().split()[1].strip()
                        if sn not in diskSnList:
                            isParsingStart = False
                            continue
                        vendor = fds[0].split()[1].strip()
                        model = fds[1].split()[1].strip()
                        firmwareVer = fds[2].split()[2].strip()
                    except:
                        devObj.get("logger").error('getAllDiskInfoInAdmin vendor/sn/fw exception:' + unicode(traceback.format_exc()))
                        isParsingStart = False
                        continue
                    
                if isParsingStart and 'name' in line:
                    name = line.split('name')[1].split(',')[0].strip()  
                
                if  isParsingStart and sn and vendor and model and name and diskType:
                    diskId = diskIdList[diskSnList.index(sn)]

                    # disktool 收集的版本，需按新方案修改Model 为AL14XXX 且FW版本为0803/0808/0807的硬盘只收集0x01部分
                    # 日志(此处只需先查询出来，后续收集时再判断FW,更改收集命令)
                    if 'toshiba' == vendor.lower() and model in disklogConf.TOSHIBA_EXCLUDE_DISK_MODEL_LIST:
                        hasSensitiveDisks = True
                        devObj.get("logger").info('found disk that is performance sensitive,quit collect this diskId :'+str(diskId))
                    else:
                        diskMap[diskId] = (diskId, sn, vendor, model, name, diskType)
                        
                    isParsingStart = False
        except Exception, e:
            devObj.get("logger").error('getAllDiskInfoInAdmin exception:' + unicode(e))
            devObj.get("logger").error('getAllDiskInfoInAdmin exception:' + unicode(traceback.format_exc()))
        finally:
            systemMode.exitDiagnoseOrMinisystem(devObj)
            
        log.info(devObj, 'All disk info map:' + unicode(len(diskMap))) 
        return diskMap, sysDisNum, hasSensitiveDisks

    @staticmethod
    def get_current_progress(dev_obj):
        """
        @summary: 获取信息收集当前进度
        """
        observer = dev_obj.get("progressObserver")
        try:
            if observer is not None:
                return observer.getCurrentProgress()
        except (Exception, ToolException):
            log.info(dev_obj, str(traceback.format_exc()))
        return 0

    @staticmethod
    def refresh_progress_by_add(dev_obj, percent_number, max_number=99):
        """
        @summary: 叠加刷新当前进度
        """
        cur = util.get_current_progress(dev_obj)
        total = cur + max(1, int(percent_number))
        if 0 < total <= max_number:
            util.refreshProcess(
                dev_obj,
                total
            )

    @staticmethod
    def refreshProcess(devObj, percentNumber):
        """
        @summary: 设置信息收集当前进度
        """
        observer = devObj.get("progressObserver")
        try:
            cur = util.get_current_progress(devObj)
            set_num = int(percentNumber)
            if set_num < cur:
                return
            if observer != None:
                observer.updateProgress(set_num, None)
                log.info(devObj, "======================current process:%s====================" % percentNumber)
        except:
            log.error(devObj, str(traceback.format_exc()))
            
    @staticmethod        
    def refreshProcessByStep(devObj, currentProcess, percentNumber):
        """
        @summary: 用于循环中刷新进度
        """        
        if int(currentProcess + percentNumber) - int(currentProcess) >= 1:            
            util.refreshProcess(devObj, currentProcess + percentNumber) 
             
        currentProcess += percentNumber
        
        return currentProcess

    @staticmethod
    def cli_res_is_support(cli_res):
        """
        判断是否支持的命令回文
        :param cli_res: 回文返回
        :return: True:支持的命令
                False:不支持的命令
        """
        # 检查第2行是否有不支持的标志符
        check_line_num = 2
        line_sep_n = "\n"
        not_support_sign = "^"
        split_list = cli_res.split(line_sep_n, check_line_num)
        if len(split_list) > check_line_num:
            return not (split_list[check_line_num - 1].strip() ==
                        not_support_sign)

        return True


class log():
    
    """
            功能：日志记录函数的子函数，用于获取调用函数和调用行号
            参数： MAX_CALLER_LEVEL：最大调用关系层数
            返回值：调用函数信息
    """
    @staticmethod
    def getCallerInfo(MAX_CALLER_LEVEL=5, skipLastLevel=True):
        #从堆栈中获取调用函数和行号
        
        #初始化参数
        funcBack = sys._getframe().f_back
        if True == skipLastLevel: #忽略最近的调用关系
            funcBack = funcBack.f_back
            MAX_CALLER_LEVEL -= 1
        
        #生成函数调用关系
        callerInfo = ""    
        for index in range(0, MAX_CALLER_LEVEL):
        
            #获取该级调用函数和行号
            if hasattr(funcBack, "f_code") and hasattr(funcBack, "f_lineno"):
                funcName = funcBack.f_code.co_name
                lineNumber = funcBack.f_lineno
                callerInfo = " [" + str(funcName) + ":" +  str(lineNumber) + "]" + callerInfo
            else:
                break
            
            #刷新Back函数
            if hasattr(funcBack, "f_back"):
                funcBack = funcBack.f_back
            else:
                break
        
        #返回函数调用关系
        return callerInfo
    
    @staticmethod
    def debug(devObj, info):
        """
                    功能：记录调试信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").debug('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
    
    @staticmethod
    def error(devObj, info):
        """
                    功能：记录错误信息info到工具日志中
                    参数：devObj=工具上下文；info=要记录的信息
                    返回值：True=成功；False=失败
        """
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").error('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def info(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").info('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)
        
    @staticmethod
    def warn(devObj, info):
        logInfo = info + log.getCallerInfo()
        if "logger" in devObj:
            devObj.get("logger").warn('[ToolLog]:' + logInfo)
            return True
        else:
            raise Exception("[failed]: logger is inexisted. info=" + logInfo)


class AsynProgressExecuteCmd(threading.Thread):
    """
    异步执行命令的线程
    目的用于异步执行命令，保持长连接
    """
    def __init__(self, devObj, LOGGER, cmd="show system general"):
        threading.Thread.__init__(self)
        self.stopFlg = False
        self.LOGGER = LOGGER
        self.cmd = cmd
        self.ssh = devObj.get("SSH")
        self.devObj = devObj
        self.timeout = 60*60*2

    def run(self):
        try:
            self.LOGGER.info(self.devObj, "start execute AsynProgressExecuteCmd cmd[%s]." % self.cmd)
            while not self.stopFlg and self.timeout > 0:
                ret = self.ssh.execCmdWithTimout(self.cmd, 10)
                time.sleep(30)
                self.timeout -= 30
                self.LOGGER.info(self.devObj, "execute timeout[%s], cmd[%s], ret:[%s]." % (self.timeout, self.cmd, str(ret)))
        except:
            self.LOGGER.error(self.devObj, str(traceback.format_exc()))

    def setStopFlag(self, stopFlag):
        self.stopFlg = stopFlag
        self.LOGGER.info(self.devObj, "setStopFlag execute cmd[%s], timeout[%s], stopFlag:%s" % (self.timeout, self.cmd, stopFlag))