﻿#coding:utf-8
import time
import traceback
from common.util import *
import os
from cbb.common.util.system import clean_permission_on
from frameone.common import copy_file_to_smart_and_rename
from frameone.util import collect_util


def execute(devObj):
    try:
        util.refreshProcess(devObj, 1)
        collectPath = util.getLocalDir(devObj) + os.path.sep + devObj["collectRetFileName"]
        copy_file_to_smart_and_rename.add_smart_file(devObj)
        #压缩前，增加eServer描述文件
        creatPkginfo(collectPath, devObj)
        util.refreshProcess(devObj, 10)
        #压缩文件
        localFileFinal = devObj["collectRetFileName"] + ".7z"
        collect_util.copy_log_and_ini_to_collect_ret_dir(devObj)
        compressFilePath = util.getLocalDir(devObj) + os.path.sep + localFileFinal
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        tar_class.compressFile(compressFilePath, collectPath)
        devObj["collectRetFileName"] = localFileFinal
        util.refreshProcess(devObj, 50)
        util.cleanDir(collectPath)
        util.refreshProcess(devObj, 80)
        clean_permission_on(compressFilePath, devObj.get("logger"))
        util.refreshProcess(devObj, 99)
        return (True, "")
    except Exception, exception:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")

    
def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = open(typeFile, "w")  
        fileObj.close()
        shutil.copy(typeFile, domainFile)
         #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(device.getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        from com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil import getAllToolVersion
        tool_version = "\ntool-version={{{}}}".format(",\n".join(getAllToolVersion()))
        desc_file = open(descFile, "w")
        seq = [snInfo, timeInfo, tool_version]
        desc_file.writelines(seq)
        desc_file.close()
        log.info(devObj, "[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)  
        log.error(devObj, "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))
        

