# -*- coding: UTF-8 -*-
import traceback
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as DataConstants
from common.util import util
from common.util import log

from common.disklogConf import disklogConf

def execute(devObj):
    try:
        util.initPyDetailMsg(devObj)
        diskMap, sysDiskNum, hasSensitiveDisks = util.getAllDiskInfoInAdmin(devObj)
            #处理从阵列侧收集到的日志文件
        if sysDiskNum == 0 and hasSensitiveDisks:
            sysDiskNum = DataConstants.TOO_MUCH_PERFORMANCE_SENSITIVE_DISKS
                
        if not diskMap:
            diskMap = {}
            sysDiskNum = DataConstants.TOO_MUCH_PERFORMANCE_SENSITIVE_DISKS if hasSensitiveDisks else 0
            log.error(devObj, 'Query all disk info failed.')

        return sysDiskNum, diskMap
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (0, {})