# -*- coding: UTF-8 -*-
from common.config import config
from common.disklogConf import disklogConf
from common.util import log, util

def writeMsgLine(devObj, msgLine, msgFile=disklogConf.DISK_LOG_COLLECT_RESULT_FILE_NAME):
    if not msgLine:
        return
    
    disklogResultFile = (util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_DISKLOG)+ msgFile)
    
    try:
        f = open(disklogResultFile, 'a+')
        f.write(msgLine + '\n')
    except Exception, e:
        log.error(devObj, 'Write disk log result file exception:' + unicode(e))
    else:
        log.info(devObj, 'Write disk log result file success.')
    finally:
        try:
            f.close()
        except Exception, e:
            log.error(devObj, 'Close disk log result file exception:' + unicode(e))
            
def writeMsgLines(devObj, msgLines):
    if not msgLines:
        return
    
    disklogResultFile = (util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_DISKLOG)
     + disklogConf.DISK_LOG_COLLECT_RESULT_FILE_NAME)
    
    try:
        f = open(disklogResultFile, 'a+')
        for msgLine in msgLines:
            f.write(msgLine + '\n')
    except Exception, e:
        log.error(devObj, 'Write disk log result file exception:' + unicode(e))
    else:
        log.info(devObj, 'Write disk log result file success.')
    finally:
        try:
            f.close()
        except Exception, e:
            log.error(devObj, 'Close disk log result file exception:' + unicode(e))
        

    
