﻿# -*- coding: UTF-8 -*-
import traceback
import time
import json
import os
import csv
import shutil

import java.util.HashMap as HashMap
from java.lang import Exception as JException
from com.huawei.ism.tool.infocollect.util import PdfInfo
from com.huawei.ism.tool.infocollect.util import DiskPDfUtils
from com.huawei.ism.tool.infocollect import CollectDataContext

from frameone.util import contextUtil
from frameone.rest.restUtil import CommonRest
from frameone.rest import restData

from common.config import config as com_cfg
from common.cli_cmd_collector import CliCmdCollector
from common.util import log
from common.util import util
from common.util import *
from common.config import config
from common.exportCmd import *
from common.exportInfo import *
from common.exportInfo import exportInfo
from common.dealSmartInfo import dealSmartInfo
from common.DhaInfoCollector import DhaInfoCollector
from common.cliFactory import cli

from cbb.business.collect.deviceInfo.collect_cmd import MultiCmdExecuter
from cbb.business.collect.deviceInfo.collect_log import collect_work_load_data
from cbb.frame.rest import restUtil

import diagnosticCollector
import genericLogCollectionCollector
from check_item_service_work_controller_luncopy import check_lun_copy

from container_info_collect import ContainerCollect

# 暂时不支持生成中文报告
PDF_FILE_NAME_EN = "Certification of Data Erasure Operation " \
                   "on Huawei Storage.pdf"
PDF_FILE_NAME_ZH = PDF_FILE_NAME_EN


def collect_work_load_by_time(dev_obj, start_day, end_day):
    """
    收集work load数据
    :param dev_obj:
    :param start_day: 开始时间以天算
    :param end_day: 结束时间以天算往前推
    :return:
    """
    try:
        local_dir = util.getLocalInfoPathByType(
            dev_obj, com_cfg.COLLECT_TYPE_WORK_LOAD
        )
        save_path = os.path.join(local_dir, com_cfg.COLLECT_TYPE_WORK_LOAD_FILE)
        return collect_work_load_data(dev_obj, save_path, start_day, end_day)
    except Exception:
        log.error(dev_obj, "work load:{}".format(traceback.format_exc()))
        return False


def collectLog(devObj):
    # 近期日志收集-增加后台收集1天的work load数据
    collect_work_load_by_time(
        devObj, com_cfg.WORK_LOAD_DEFAULT_START_DAY,
        com_cfg.WORK_LOAD_ONE_DAY_END
    )
    try:
        log.info(devObj, "start check lun copy...")
        flag, cli_ret, err_msg, return_hot_patch = check_lun_copy(devObj)
        if flag != True:
            log.error(devObj, "check lun copy failed, all_cli_ret:%s, err_msg:%s" % (cli_ret, err_msg))
            if return_hot_patch:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.patch", return_hot_patch)
            else:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.no.patch")
            return False, ""
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        is_succ = exportInfo.collect_item(devObj, config.EXPORT_TYPE_LOG)
        util.refreshProcess(devObj, 100)
        return (is_succ, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectAllLog(devObj):
    # 全量日志收集-增加后台收集1天的work load数据
    collect_work_load_by_time(
        devObj, com_cfg.WORK_LOAD_DEFAULT_START_DAY,
        com_cfg.WORK_LOAD_ONE_DAY_END
    )
    try:
        log.info(devObj, "start check lun copy...")
        flag, cli_ret, err_msg, return_hot_patch = check_lun_copy(devObj)
        if flag != True:
            log.error(devObj, "check lun copy failed, all_cli_ret:%s, err_msg:%s" % (cli_ret, err_msg))
            if return_hot_patch:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.patch", return_hot_patch)
            else:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.no.patch")
            return False, ""
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        is_succ = exportInfo.collect_item(devObj, config.EXPORT_TYPE_ALLLOG)
        util.refreshProcess(devObj, 100)
        return (is_succ, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectEvent(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        util.refreshProcess(devObj, 3)
        if isUpgrading:
            return (False, "")
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_EVENT)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectRunningData(devObj):
    # 收集完config限制CLI命令收集时间，已和LMT/eservice对齐，
    # 时间2019.12.27
    collect_limit_time = 600
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False, "")
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA)
        util.refreshProcess(devObj, 80)
        current_time = time.time()
        env = os.environ.get('collectScene')
        log.info(devObj, "env collectScene. {}".format(env))
        if env != 'fdt':
            # 为eService收集cli命令的回显，存放到与config文件相同的路径下
            localDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_RUNNING_DATA)
            time_out = exportCmd.collectCliCmd4eService(devObj, localDir,
                                                        current_time,
                                                        collect_limit_time)
            if time_out:
                log.info(devObj, "collect cli cmd time out!")
                util.refreshProcess(devObj, 100)
                return (isSucc, "")

        util.refreshProcess(devObj, 90)
        # 为eService收集rest命令的回显，存放到与config文件相同的路径下,非定时场景才收集
        if not devObj.get("isTiming"):
            localDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_RUNNING_DATA)
            exportCmd.collectRestCmd4eService(devObj, localDir, current_time,
                                              collect_limit_time)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectCliCmd(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False, "")
        # 检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if False == isSysNormal:
            return (False, "")

        # 获取产品型号
        isSucc, productModel = getProductModel(devObj)
        if not isSucc:
            log.info(devObj, "Cannot get information about product model")
            return (isSucc, "")

        # V6版本所有型号的设备使用新的cli命令收集逻辑
        if util.need_tailared_cli_cmd(productModel):
            cli_cmd_collector = CliCmdCollector(devObj, productModel)
            return cli_cmd_collector.do_collect(), ""

        # 单独先收集故障诊断CLI命令回显
        collect_fault_diagnose_cmd(devObj)

        # Dorado命令有裁剪，需要调用另一个CLI命令列表
        doradoProductV3List = ["Dorado18000 V3", "Dorado6000 V3", "Dorado5000 V3", "Dorado3000 V3"]
        doradoProductV6List = ["OceanStor Dorado 3000 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 5300 V6",
                               "OceanStor Dorado 5500 V6", "OceanStor Dorado 5600 V6", "OceanStor Dorado 5800 V6",
                               "OceanStor Dorado 6000 V6", "OceanStor Dorado 6800 V6", "OceanStor Dorado 8000 V6",
                               "OceanStor Dorado 18000 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
                               "OceanStor Dorado 18800K V6", "OceanStor Dorado 5600K V6", "OceanStor 5310",
                               "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash", "OceanStor A300",
                               "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610", "OceanStor 5320",
                               "OceanStor 5810-HS", "OceanStor 5300K", "OceanStor 5500K", "OceanStor Dorado 2000",
                               "OceanStor Dorado 2100", "OceanStor Dorado 2020",
                               "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K", "OceanStor 18810",
                               "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620",
                               "OceanStor 5210", "OceanStor 5220", "OceanStor Dorado 3000", "OceanStor Dorado 5000",
                               "OceanStor Dorado 6000", "OceanStor Dorado 8000", "OceanStor Dorado 18000",
                               "OceanStor Dorado 5300", "OceanStor Dorado 5500", "OceanStor Dorado 5600",
                               "OceanStor Dorado 6800", "OceanStor Dorado 18500", "OceanStor Dorado 18800",
                               "OceanStor Dorado 5600K", "OceanStor Dorado 18800K", "OceanProtect X3000",
                               "OceanProtect X8000", "OceanProtect E8000", "OceanProtect X9000", "OceanProtect A8000",
                               "OceanProtect X6000", "OceanProtect X8000K", "OceanProtect X9000K",
                               "OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600",
                               "OceanDisk 1610", "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1500T",
                               "OceanDisk 1600T", "OceanDisk 1610T", "OceanStor 2910", "OceanStor A800"]
        if productModel in doradoProductV3List:
            isSucc = exportCmd.exportCliCmd(devObj, config.LIST_CLI_CMD_DORADO_V3, config.COLLECT_TYPE_CLI)
        elif productModel in doradoProductV6List:
            isSucc = exportCmd.exportCliCmd(devObj, config.LIST_CLI_CMD_DORADO_V6, config.COLLECT_TYPE_CLI)
        else:
            isSucc = exportCmd.exportCliCmd(devObj, config.LIST_CLI_CMD, config.COLLECT_TYPE_CLI)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collect_fault_diagnose_cmd(dev_obj):
    """
    收集故障诊断命令信息
    :param dev_obj:
    :return:
    """
    try:
        # 收集类型
        collect_type = config.COLLECT_TYPE_CLI_FAULT_TREE
        exportCmd.writeCliCmdFile(dev_obj, '', collect_type)
        res_file_dir = util.getLocalInfoPathByType(dev_obj, collect_type)
        res_file_name = config.CLI_FILE_NAMES_FOR_TYPE.get(collect_type)
        # 结果文件路径
        res_file_path = os.path.join(res_file_dir, res_file_name)
        script_path = os.path.dirname(os.path.abspath(__file__))
        # 命令配置xml路径在package目录下
        if CollectDataContext.getInstance().isSomeCmdNeedRemove() is True:
            xml_path = os.path.join(
                script_path,
                os.path.join("..", "..", "FaultTreeCmdListLess.xml")
            )
        else:
            xml_path = os.path.join(
                script_path,
                os.path.join("..", "..", "FaultTreeCmdList.xml")
            )
        log.info(
            dev_obj, "xml_path:{}, res_file_path:{}".format(
                xml_path, res_file_path
            )
        )
        multi_cmd_executer = MultiCmdExecuter(dev_obj, xml_path, res_file_path)
        multi_cmd_executer.execute()
    except Exception:
        log.error(dev_obj, "collect diagnose cmd except:" + str(
            traceback.format_exc()))
        ssh = dev_obj["SSH"]
        systemMode.reconnect_ssh(ssh, log)


def collectElableCmd(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False, "")
        # 检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if False == isSysNormal:
            return (False, "")
        isSucc = exportCmd.exportElableCmd(devObj, config.COLLECT_TYPE_ELABLE)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectDHA(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)

        # 保留此检查过程，以便后续维护更改
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading and util.is_use_new_method_collect_dha(devObj):
            return False, ""
        if isUpgrading:
            return True, ""

        dhaInfoCollector = DhaInfoCollector()

        # DHA信息收集结果仅用于机器学习，因此总是返回成功。若发生任何错误仅记录日志
        # 2022.3.22新增用show file命令收集日志，更改总是返回成功。
        status, msg = dhaInfoCollector.exportDhaInfo(devObj)
        msg = util.getMsg(devObj, msg)
        log.info(devObj, "error message from DHA collection:%s" % msg)
        util.refreshProcess(devObj, 100)
        return status, ""
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return False, ""


def collectSmart(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False, "")
        is_succ = exportInfo.collect_item(devObj, config.COLLECT_TYPE_SMART)
        if not os.path.exists(os.path.join(devObj.get("collect_info_local_path"), "Running_Data")):
            devObj.setdefault("runningDataClean", True)
            log.info(devObj, "To collect Smart information, download the config file and delete it.")
            if not exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA):
                log.error(devObj, "Failed to download the config file during Smart Information Collection.")
        # 处理收集到得smart信息，将其转换为日志分析工具需要的格式
        if is_succ:
            (is_succ, errMsgKey) = dealSmartInfo(devObj)
            if not is_succ:
                util.setPyDetailMsg(devObj, errMsgKey)
        util.refreshProcess(devObj, 100)
        return (is_succ, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectDiagnostic(devObj):
    try:
        isSucc = diagnosticCollector.collect(devObj)
        return (isSucc, "")
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectHistoryCapacity(devObj):
    """
    收集历史容量信息
    :param devObj:
    :return:
    """
    try:
        isSucc = genericLogCollectionCollector.collect(devObj, config.COLLECT_TYPE_HISTORY_CAPACITY)
        return (isSucc, "")
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collect_data_erasure_report(devObj):
    """
    收集擦除数据报告
    :param devObj:
    :return:
    """
    rest = contextUtil.getRest(devObj)
    base_uri = rest.getBaseUri()
    rest_conn = rest.getConnection()
    url_package = "exportDataErasureReport?tag=package"
    try:
        try:
            rest_conn.execGet(base_uri + url_package, "")
        except:
            log.error(
                devObj, "except trace back:" + str(traceback.format_exc())
            )

        # 轮询查询打包状态，获取下载路径
        download_uri = get_download_uri(devObj, rest_conn, base_uri)
        if not download_uri:
            log.error(devObj, "get download uri fail.")
            util.setPyDetailMsg(
                devObj, "disk.info.erasure.get.download.url.fail"
            )
            return False, ''
        local_dir = util.getLocalInfoPathByType(
            devObj, com_cfg.COLLECT_TYPE_DISK_DATA_ERASURE_REPORT
        )
        # 下载csv压缩包.tgz
        rest_conn.execGetFile(download_uri, None, local_dir)

        # 解析csv
        flag, csv_data = get_report_data_from_zip_file(devObj, local_dir)
        if not flag:
            log.error(devObj, "download pgk fail.")
            util.setPyDetailMsg(
                devObj, "disk.info.erasure.anysis.fail"
            )
            return flag, ''

        if not csv_data:
            return True, ''

        # 生成pdf
        return general_pdf(devObj, csv_data, local_dir)
    except (JException, Exception) as e:
        log.error(devObj, "get path error:{}".format(str(e)))
        util.setPyDetailMsg(devObj, "failed.collect.information")
        return False, ""
    finally:
        if rest:
            log.info(devObj, "close rest connection.")
            rest.closeCon()


def get_download_uri(devObj, rest_conn, base_uri):
    repeat_times = 60
    NOT_COMPLETE_ERROR_CODE = "83887409"
    url_get_path = "exportDataErasureReport?tag=getpath"
    url_download = "exportDataErasureReport?tag={}"
    download_uri = ""
    while repeat_times > 0:
        try:
            response_dict = rest_conn.execGet(base_uri + url_get_path, "")
            log.info(
                devObj,
                "response_dict:{}, type:{}".format(
                    response_dict, type(response_dict)
                ),
            )
            response_dict = json.loads(str(response_dict.getContent()))
            err_info = CommonRest.getErrInfo(response_dict)
            err_code = CommonRest.getRecordValue(
                err_info, restData.ErrorInfo.CODE
            )
            repeat_times -= 1
            if err_code == "0":
                report_path = response_dict.get("data", "")
                download_uri = base_uri + url_download.format(report_path)
                log.info(devObj, "download uri is:{}".format(download_uri))
                break
            if err_code == NOT_COMPLETE_ERROR_CODE:
                time.sleep(1)
                continue
        except JException as e:
            log.error(devObj, "get path error:" + str(e))
            raise e
    return download_uri


def general_pdf(dev_obj, csv_data, pdf_path):
    """
    根据模板生成数据
    :param dev_obj:
    :param csv_data: csv数据
    :param pdf_path: Pdf 保存路径
    :return:
    """
    flag, ret = cli.executeCmd(dev_obj, "show system general")
    if flag is not True:
        return False
    product_model = restUtil.CommonRest.getOriginProductModel(dev_obj.get("devNode"))
    res_list = systemMode.getVerticalCliRet(ret)
    pdf_info = PdfInfo()
    for res in res_list:
        dev_name = res.get("System Name", '')
        dev_sn = res.get("SN", '')
        dev_location = res.get("Location", '')
        dev_model = product_model if product_model else res.get("Product Model", '')
        dev_version = res.get("Product Version", '')
        dev_time = res.get("Time", '')
        pdf_info.setStorageName(dev_name)
        pdf_info.setTime(dev_time)
        pdf_info.setStorageSerial(dev_sn)
        pdf_info.setLocation(dev_location)
        pdf_info.setProductMode(dev_model)
        pdf_info.setProductVersion(dev_version)
        pdf_info.setQuantityOfDisksErased(str(len(csv_data)))

    for record_dict in csv_data:
        tmp_map = HashMap()
        for key, value in record_dict.items():
            tmp_map.put(key, value)
        pdf_info.getScreenshotContainsDisk().add(tmp_map)
        log.info(dev_obj, "tmp hash map:{}".format(tmp_map))

    # 调用java接口生成pdf模板
    pdf_name = PDF_FILE_NAME_EN
    if dev_obj.get("lang") == 'zh':
        pdf_name = PDF_FILE_NAME_ZH
    pdf_abs_path = os.path.join(pdf_path, pdf_name)
    return bool(DiskPDfUtils(pdf_abs_path, pdf_info).buildDiskPDf()), ''


def get_report_data_from_zip_file(devObj, local_dir):
    """
    从csv压缩文件中获取报告数据
    :param devObj:
    :param local_dir: 本地目录
    :return:
    """
    wait_download_times = 60 * 5
    csv_res = []
    while wait_download_times > 0:
        downloads_file_list = os.listdir(local_dir)
        log.info(
            devObj, "downloads_file_list is:{}".format(downloads_file_list)
        )
        tmp_csv_file_name = ''
        for file_name in downloads_file_list:
            if not file_name.endswith(".tgz"):
                continue
            tmp_csv_file_name = file_name

        if not tmp_csv_file_name:
            time.sleep(1)
            wait_download_times -= 1
            continue

        dir_name = tmp_csv_file_name[0: tmp_csv_file_name.find(".tgz")]
        tmp_file_path = os.path.join(local_dir, tmp_csv_file_name)
        temp_dir_path = os.path.join(local_dir, dir_name)
        if not os.path.exists(temp_dir_path):
            os.mkdir(temp_dir_path)
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        tar_class.decompressTarGzFileAndGetFileNames(
            tmp_file_path, temp_dir_path
        )
        csv_file_list = os.listdir(temp_dir_path)

        for csv_file_name in csv_file_list:
            if not csv_file_name.endswith(".csv"):
                continue
            csv_file_path = os.path.join(temp_dir_path, csv_file_name)
            with open(csv_file_path, 'r') as f:
                reader = csv.DictReader(f)
                csv_res = list(reader)
        # 下载文件加可写权限，才能删除。
        add_permission(temp_dir_path)
        shutil.rmtree(temp_dir_path)
        return True, csv_res

    # 超时失败
    return False, csv_res


def collect_work_load(dev_obj):
    """
    支持一个月的work load数据搜集
    :param dev_obj:
    :return:
    """
    is_success = collect_work_load_by_time(
        dev_obj, com_cfg.WORK_LOAD_DEFAULT_START_DAY,
        com_cfg.WORK_LOAD_ONE_MONTH
    )
    if not is_success:
        echo = dev_obj.get("py_detail")
        if not echo:
            util.setPyDetailMsg(
                dev_obj, "failed.collect.information.not.support"
            )
        else:
            util.setPyDetailMsg(
                dev_obj, "failed.collect.information.add.detail", echo
            )
    return is_success, ''


def collect_container_log(dev_obj):
    dev_node = dev_obj.get("devNode")
    dev_license = dev_obj.get("license")
    product_model = str(dev_node.getDeviceType())
    if product_model not in config.COLLECT_CONTAINER_INFO_DEV_TYPES:
        return True, ''
    if not util.is_super_admin(dev_obj):
        util.setPyDetailMsg(dev_obj, "not.super.admin.not.supported")
        return False, ''

    local_dir = com_cfg.COLLECT_TYPE_CONTAINER_LOG
    if dev_license and dev_license == "cloudBackup":
        local_dir = com_cfg.COLLECT_TYPE_CLOUDBACKUP_CONTAINER_LOG
    local_dir = util.getLocalInfoPathByType(
        dev_obj, local_dir
    )

    uri = "infra/collect/all/info"
    flag, msg = ContainerCollect(dev_obj, uri, log, local_dir).execute_collect()
    if flag is not True:
        dev_obj["py_detail"] = msg
        return False, msg

    return True, ''


def collect_container_event(dev_obj):
    """
    收集告警容器信息
    :param dev_obj:
    :return:
    """
    dev_node = dev_obj.get("devNode")
    dev_license = dev_obj.get("license")
    product_model = str(dev_node.getDeviceType())
    if product_model not in config.COLLECT_CONTAINER_INFO_DEV_TYPES:
        return True, ''

    local_dir = com_cfg.COLLECT_TYPE_CONTAINER_EVENT
    if dev_license and dev_license == "cloudBackup":
        local_dir = com_cfg.COLLECT_TYPE_CLOUDBACKUP_CONTAINER_EVENT
    local_dir = util.getLocalInfoPathByType(
        dev_obj, local_dir
    )

    param_lang = "zh-cn" if dev_obj.get("lang") == 'zh' else 'en-us'
    uri = "alarms/action/export?lang={}".format(param_lang)
    uri_event = "events/action/export?lang={}".format(param_lang)
    flag, msg = ContainerCollect(dev_obj, uri, log, local_dir).collect_alarm()
    flag_event, msg_event = ContainerCollect(dev_obj, uri_event, log, local_dir).collect_alarm()
    if flag is not True or flag_event is not True:
        total_msg = msg if msg == msg_event else msg + msg_event
        dev_obj["py_detail"] = total_msg
        return False, total_msg

    return True, ''


def collect_potential_risk(dev_obj):
    """
    收集历史故障信息表
    :param dev_obj: dev对象
    :return: 是否收集成功，错误信息
    """
    try:
        log.info(dev_obj, "start collect potential risk...")
        util.refreshProcess(dev_obj, 1)
        util.initPyDetailMsg(dev_obj)
        is_success = exportInfo.exportSysInfo(dev_obj, config.COLLECT_TYPE_POTENTIAL_RISK)
        util.refreshProcess(dev_obj, 100)
        return is_success, ""
    except Exception as exception:
        log.error(dev_obj, "Collect potential risk failed. {}".format(exception))
        return False, ""
