# -*- coding: UTF-8 -*-
from java.io import File
from com.huawei.ism.tool.obase.exception import ToolException
from common.config import config
from common.disklogConf import disklogConf
from writeDiskLogResult import writeMsgLine
from common.cliFactory import cli
from common.util import systemMode
from common.util import util
from common.util import log
from common.util import device
import os
import shutil
from common.fltDiskLgOnHighEnd import FltDiskLgCollector
from common.commonUtils import MsgInfo, Log, CommonUtils
from common.faultDiskLogCollector import FaultDiskLogCollector
import traceback
def collect(devObj, collectAll = True):
    util.refreshProcess(devObj, 1)
    util.initPyDetailMsg(devObj)
    if util.isSystemUpgrading(devObj):
        return (False, "")

    isCollectSucc, msg = False, ""
    try:
        isSuccess, isUsingCliCmd = util.isCli4DiskInfoAvaliable(devObj)
        if not isSuccess:
            writeMsgLine(devObj, 'cannot figure out  system status.')
            return (False, "")
        if isUsingCliCmd:
            logger = Log(devObj)
            commonUtils = CommonUtils(devObj, logger)
            msgInfo = MsgInfo(logger, commonUtils, disklogConf)
            faultDiskLogCltr = FaultDiskLogCollector(devObj, disklogConf, msgInfo, collectAllLog = collectAll)
            isCollectSucc, msg = faultDiskLogCltr.doCollect()
        else :
            logger = Log(devObj)
            commonUtils = CommonUtils(devObj, logger)
            msgInfo = MsgInfo(logger, commonUtils, disklogConf)
            isSuccess, is18000 = util.is18000Series(devObj)
            if not isSuccess :
                writeMsgLine(devObj, 'cannot figure out  system status.')
                return (False, "")
            util.refreshProcess(devObj, 2)        
            if isSuccess and is18000:
                log.info(devObj, "this is a high-end device")
                logger = Log(devObj)
                commonUtils = CommonUtils(devObj, logger)
                msgInfo = MsgInfo(logger, commonUtils, disklogConf)
                faultCollector = FltDiskLgCollector(devObj, commonUtils, logger, msgInfo, disklogConf, collectAllLog = collectAll)
                isCollectSucc, msg = faultCollector.collectFltDiskLg()
            else:
                isCollectSucc, msg = doCollect(devObj, collectAllLog = collectAll)
        util.refreshProcess(devObj, 99)  
        return isCollectSucc, msg
    except BaseException, excp:
        log.error(devObj, 'Collect isolated disk log exception:' + unicode(excp))
        return False, ''
        
    finally:
        #Remove isolated disk log directory when collecting failed.
        if not isCollectSucc:
            try:
                localFaultDisklogSaveDir = os.path.join(util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_DISKLOG), disklogConf.ISOLATED_DISKLOG_DIR_NAME)
                if util.isEmptyDir(localFaultDisklogSaveDir):
                    log.warn(devObj, 'Exception occurred and remove empty directory:' + unicode(localFaultDisklogSaveDir))
                    shutil.rmtree(localFaultDisklogSaveDir, True)
            except Exception, e:
                log.error(devObj, 'rmtree exception:' + unicode(e))
        util.refreshProcess(devObj, 100) 

def doCollect(devObj, collectAllLog = True):


    isQrySuc, engineNum = device.getEngineNum(devObj)
    if not isQrySuc:
        log.error(devObj, 'Query the engine number failed.')
        return False, ''
    
    #此处进入小系统模式，会对之后的代码中命令执行产生重大影响，语句顺序不要调换。
    if not systemMode.enterMinisystemMode(devObj):
        log.error(devObj, 'Enter into minisystem mode failed.')
        util.addPyDetailMsg(devObj, "failed.enter.minisystem.due.to.privilege")
        return False, ''
    util.refreshProcess(devObj, 3) 
    #depends minisystem
    curNodeBond0IP = device.getBond0IP(devObj)
    if not curNodeBond0IP:
        util.addPyDetailMsg(devObj, 'query.current.ctrl.bond0.IP.failed')
        systemMode.exitDiagnoseOrMinisystem(devObj)
        log.error(devObj, 'Query bond0 IP of current controller failed.')
        return False, ''
    util.refreshProcess(devObj, 4) 
    otherBond0IPs = []
    broadcastIpLists = disklogConf.BOND0_IP_LIST_OF_6U_4CTRL[:]
    broadcastIpLists.remove(curNodeBond0IP)
    log.info(devObj,"current controller IP list tobe checked:%s"%str(broadcastIpLists))
    for singleIp in broadcastIpLists : 
        if util.ping(devObj,singleIp):
            otherBond0IPs.append(singleIp)
    log.info(devObj,"current online controller IPs:%s"%str(otherBond0IPs))
    nodeNumInEngin = len(otherBond0IPs) + 1
    #下载信息到本地
    #/OSM/coffer_data/fault_disklog/internal_log
    sftp = util.getSftp(devObj)
    localFaultDisklogSaveDir = os.path.join(util.getLocalInfoPathByType(devObj, config.COLLECT_TYPE_DISKLOG), disklogConf.ISOLATED_DISKLOG_DIR_NAME)
    util.refreshProcess(devObj, 50) 
    curNodeDisklogSaveDir = os.path.join(localFaultDisklogSaveDir, curNodeBond0IP)      
    if not os.path.exists(curNodeDisklogSaveDir):
        os.makedirs(curNodeDisklogSaveDir)
        
    isNeedInstallHotPatch = False
    totalSucCntNum = 0
    
    try:
        sftp.getDirRecurse(disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR, File(curNodeDisklogSaveDir))
        if not collectAllLog:
            postProcess4RecentLogDownload(curNodeDisklogSaveDir, log, devObj)
    except ToolException, te:
        log.error(devObj, 'Caught ToolException when down loading fault disk log directory:' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ', exception:' + unicode(te))
        #权限拒绝说明需要安装热补丁解决权限问题.
        if 'Permission denied' in te.getMessage():
            isNeedInstallHotPatch = True
        elif sftp.isDirExist(disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR):
            util.addPyDetailMsg(devObj, "download.other.ctrl.fault.disk.log.failed", curNodeBond0IP)
            writeMsgLine(devObj, 'Controller ' + unicode(curNodeBond0IP) + ' fault disk log directory down load exception.',
                         disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
        else:
            log.warn(devObj, 'Fault disk log directory does not exist.')
            writeMsgLine(devObj, 'Controller ' + unicode(curNodeBond0IP) + ' fault disk log directory not exist.',
                         disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            shutil.rmtree(curNodeDisklogSaveDir, True)
            totalSucCntNum += 1
    except Exception, e:
        log.error(devObj, 'Caught Exception when down loading fault disk log directory:' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ', exception:' + unicode(e))
    else:
        log.info(devObj, 'Collect current controller: ' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ' success.')
        totalSucCntNum += 1
    util.refreshProcess(devObj, 55)
    
    hasPatch = False
    devSpcVer = device.getDeviceVersion(devObj)
    log.info(devObj, 'Current device version is:' + devSpcVer)
    for supportMinVer in disklogConf.HAS_ISOLATED_DISKLOG_PATCH_LIST:
        if devSpcVer == supportMinVer:
            hasPatch = True
            break
        
    if isNeedInstallHotPatch:
        if hasPatch:
            util.addPyDetailMsg(devObj, "install.hotpatch.collect.fault.disk.log")
        else:
            util.addPyDetailMsg(devObj, "current.version.does.not.support.fault.disk.log")
        systemMode.exitDiagnoseOrMinisystem(devObj)
        return False, ''
    util.refreshProcess(devObj, 58)
    if collectAllLog:
        #depends minisystem
        curNodeFreeMem = device.getFreeMemInMinisystem(devObj)
        if curNodeFreeMem == -1:
            log.error(devObj, 'Query free memory of current controller failed.')
            util.addPyDetailMsg(devObj, 'query.free.memory.of.current.ctrl.failed')
            systemMode.exitDiagnoseOrMinisystem(devObj)
            util.setCollectAllInfo(devObj, totalSucCntNum == nodeNumInEngin and engineNum == 1)
            return True if totalSucCntNum > 0 else False, ''
        
        if curNodeFreeMem < disklogConf.DISK_FAULT_LOG_MIN_FREE_MEM:
            log.error(devObj, 'Not enough free memory of current controller remained(MB):' + unicode(curNodeFreeMem))
            util.addPyDetailMsg(devObj, 'not.enough.free.memory.of.current.ctrl', (unicode(disklogConf.DISK_FAULT_LOG_MIN_FREE_MEM)))
            systemMode.exitDiagnoseOrMinisystem(devObj)
            util.setCollectAllInfo(devObj, totalSucCntNum == nodeNumInEngin and engineNum == 1)
            return True if totalSucCntNum > 0 else False, ''
        util.refreshProcess(devObj, 65)    
        #depends minisystem
        qryOk, isScpExist = systemMode.isScpCmdExist(devObj)
        if not qryOk:
            log.error(devObj, 'Query whether the scp command exist in minisystem failed.')
            systemMode.exitDiagnoseOrMinisystem(devObj)
            util.addPyDetailMsg(devObj, 'cmd.failed.and.fault.disklog.of.other.ctrl.in.this.engin.not.collect')
            util.setCollectAllInfo(devObj, totalSucCntNum == nodeNumInEngin and engineNum == 1)
            return True if totalSucCntNum > 0 else False, ''  
    
        otherCtrlSucNum = getDiskLogsOfOtherCtrls(devObj, otherBond0IPs, localFaultDisklogSaveDir, isScpExist)
        totalSucCntNum += otherCtrlSucNum
    else:
        nodeNumInEngin = 1
        engineNum = 1
    systemMode.exitDiagnoseOrMinisystem(devObj)
    
    if engineNum > 1:
        util.addPyDetailMsg(devObj, 'only.logs.of.ctrls.in.current.engine.collect')
        
    util.setCollectAllInfo(devObj, totalSucCntNum == nodeNumInEngin and engineNum == 1)
    return True if totalSucCntNum > 0 else False, '' 

def getDiskLogsOfOtherCtrls(devObj, otherBond0IPs, localFaultDisklogSaveDir, isScpExist):
    sucCntNum = 0
    sftp = util.getSftp(devObj)
    usrPwd = device.getDevicePassword(devObj)
    if not usrPwd:
        return sucCntNum
    currentProcess = 66
    percentNumber = 30.0
    if len(otherBond0IPs) > 0:
        percentNumber = 30.0 / len(otherBond0IPs)
    
    for otherBond0IP in otherBond0IPs:
        otherNodeLogRmtTmpDir = disklogConf.SFPT_HOME_DIR
        
        if not isScpExist:
            cpOtherNodeLogCmd = 'getremotedir ' + otherBond0IP + ' ' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ' ' + otherNodeLogRmtTmpDir
        else:
            cpOtherNodeLogCmd = 'scp -r admin@' + otherBond0IP + ':' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ' ' + otherNodeLogRmtTmpDir
        #Copy fault disk log from other controller to /home/permitdir/
        (isSuccess, cpFaultDiskLogRet) = cli.executeCmdWithTimout(devObj, cpOtherNodeLogCmd, disklogConf.COLLECT_DISK_LOG_CMD_TIME_OUT)
        if not isSuccess:
            log.error(devObj, "Execute copy peer fault disk log directory command failed:" + cpOtherNodeLogCmd)
        else:
            rmtDirToGet = otherNodeLogRmtTmpDir + '/' + disklogConf.FAULT_DISK_LOG_DIR_NAME
            if ('password:' in cpFaultDiskLogRet 
            or len(cpFaultDiskLogRet.strip().splitlines()) == 2#V3R6C00SPC100直接拷贝成功，无任何回显.
            or 'success' in cpFaultDiskLogRet):
                if 'password:' in cpFaultDiskLogRet:
                    (isInpuPwdSuc, cpPeerDirRet) = cli.executeCmdNoLogTimeout(devObj, usrPwd, disklogConf.COLLECT_DISK_LOG_CMD_TIME_OUT)
                    if not isInpuPwdSuc:
                        log.error(devObj, "Copy peer log dir to current controller failed when input password.")
                        util.addPyDetailMsg(devObj, "copy.other.ctrl.fault.disk.log.to.local.ctrl.failed", otherBond0IP)
                        continue
                    else:
                        if 'No such file or directory' in cpPeerDirRet:
                            log.warn(devObj, "Peer fault disk log directory not exist.")
                            sucCntNum += 1
                            writeMsgLine(devObj, 
                                         'Controller ' + unicode(otherBond0IP) + ' fault disk log directory not exist.',
                                          disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                            continue
                        elif 'failed' in cpPeerDirRet:
                            log.error(devObj, "Copy peer fault disk log directory failed.")
                            writeMsgLine(devObj, 'Controller ' + unicode(otherBond0IP) + ' fault disk log directory copy failed:' + cpPeerDirRet,
                                         disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                            util.addPyDetailMsg(devObj, "download.other.ctrl.fault.disk.log.failed", otherBond0IP)
                            continue
                    
                nodeDisklogSaveDir = os.path.join(localFaultDisklogSaveDir, otherBond0IP)
                if not os.path.exists(nodeDisklogSaveDir):
                    os.makedirs(nodeDisklogSaveDir)                
                try:
                    #Down load fault disk log from temporary directory to local
                    isException = False
                    sftp.getDirRecurse(rmtDirToGet, File(nodeDisklogSaveDir))
                except ToolException, te:
                    log.error(devObj, "Caught ToolException when down loading [" + rmtDirToGet + "] exception:" + unicode(te))
                    util.addPyDetailMsg(devObj, "download.other.ctrl.fault.disk.log.failed", otherBond0IP)
                    isException = True
                    writeMsgLine(devObj, 'Controller ' + unicode(otherBond0IP) + ' fault disk log down load failed.',
                                 disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                except Exception, e:
                    util.addPyDetailMsg(devObj, "download.other.ctrl.fault.disk.log.failed", otherBond0IP)
                    log.error(devObj, "Caught Exception when down loading [" + rmtDirToGet + "] exception:" + unicode(e))
                    isException = True
                    writeMsgLine(devObj, 'Controller ' + unicode(otherBond0IP) + ' fault disk log down load failed.',
                                 disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                else:
                    sucCntNum += 1
                    log.info(devObj, "Down loading  [" + rmtDirToGet + "] success.")
                finally:
                    systemMode.deleteDirectory(devObj, rmtDirToGet)
                    try:
                        if isException and util.isEmptyDir(nodeDisklogSaveDir):
                            log.warn(devObj, 'Exception occurred and remove empty directory:' + unicode(nodeDisklogSaveDir))
                            shutil.rmtree(nodeDisklogSaveDir, True)
                    except Exception, e:
                        log.error(devObj, 'rmtree exception:' + unicode(e))
                    
            elif 'failed' in cpFaultDiskLogRet:#if 
                util.addPyDetailMsg(devObj, 'copy.peer.fault.disklog.failed', otherBond0IP)
                #Delete temporary directory when copying failed.
                systemMode.deleteDirectory(devObj, rmtDirToGet)
                writeMsgLine(devObj, 'Controller ' + unicode(otherBond0IP) + ' fault disk log collect failed:' + cpFaultDiskLogRet,
                            disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                log.error(devObj, 'Copy peer fault disk log directory:' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ' failed.') 
            elif 'Permition denied' in  cpFaultDiskLogRet or 'Permission denied' in cpFaultDiskLogRet:
                util.addPyDetailMsg(devObj, "collect.ctrl.fault.disk.log.failed.because.permission.denied", otherBond0IP)
                #Delete temporary directory when copying failed.
                systemMode.deleteDirectory(devObj, rmtDirToGet)
                writeMsgLine(devObj, 'Controller ' + unicode(otherBond0IP) + ' fault disk log collect failed:' + cpFaultDiskLogRet,
                            disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                log.error(devObj, 'Copy peer fault disk log directory:' + disklogConf.DISK_FAULT_LOG_REMOTE_ROOT_DIR + ' failed.') 
        currentProcess = util.refreshProcessByStep(devObj, currentProcess, percentNumber)
    return sucCntNum

def postProcess4RecentLogDownload(logDir, logger, devObj):
    '''
    @summary: post_Process for collect recent fault disk log
    '''
    try:
        common_RemoveFile(os.path.join(logDir, "hdd"), logger, devObj)
        common_RemoveFile(os.path.join(logDir, "hssd"), logger, devObj)

        interLogDir = os.path.join(logDir, "internal_log")
        if not os.path.exists(interLogDir):
            logger.error(devObj, "[postProcessCtrlLog] internal_log dir not exist")
            return
        fileList = getRecentFileList(interLogDir)
        if not fileList:
            logger.error(devObj, "[postProcessCtrlLog] no internal_log")
            return
        totalSizeCount = 0L
        for fileTmp in fileList:
            fileTmpPath = os.path.join(interLogDir, fileTmp)
            fileTmpSize = os.path.getsize(fileTmpPath)
            if (totalSizeCount + fileTmpSize) > config.RECENT_FAULTLOG_MAX_SIZE:
                logger.error(devObj, "[postProcessCtrlLog] The file %s size %s is too large, need delete!" % (fileTmpPath, str(fileTmpSize)))
                common_RemoveFile(fileTmpPath, logger, devObj)
                continue
            
            totalSizeCount += fileTmpSize
        return
    except:
        logger.error(devObj, "[postProcessCtrlLog]error: " + traceback.format_exc())
        return

def common_RemoveFile(filePath, logger, devObj):
    '''
    @summary: common function for file or directory move action
    '''
    try:
        if not os.path.exists(filePath):
            return
        if os.path.isdir(filePath):
            shutil.rmtree(filePath, ignore_errors = True)
        elif os.path.isfile(filePath):
            os.remove(filePath)
        return
    except:
        logger.error(devObj, "[common_RemoveFile]error: " + traceback.format_exc())
        return
def getRecentFileList(fileDir):
    '''
    @summary: common function for file sort
    '''
    fileTmpList = os.listdir(fileDir)
    fileTmpList.sort(reverse = True)
    return fileTmpList
    
