# -*- coding: UTF-8 -*-

import traceback
from common.util import util
from common.util import log
from common.exportInfo import exportInfo
from common.config import config


def execute(devObj):
    """
    导出ftds日志入口
    :return: 收集结果
    """
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        # 收集前检查
        # 检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if not isSysNormal:
            return (False, "")
        is_succ = exportInfo.collect_item(
            devObj, config.COLLECT_TYPE_FTDS_STATDATA)
        is_exist_msg = util.isExistDetailMsg(devObj)
        if is_succ is False and is_exist_msg is False:
            util.setPyDetailMsg(devObj, "failed.collect.information")
        return (is_succ, "")

    except Exception:
        log.error(devObj, "except trace back:{error_str}".format(
            error_str=str(traceback.format_exc())))
        return (False, "")
