# -*- coding: UTF-8 -*-

class config():
    #**************预定义传输协议名称****************
    PROTOCOL_SFTP = "SFTP"

    #**************DHA配置****************
    DHA_TAR_LOG_FILE_EXTEND = ".tar.bz2"
    COLLECT_TYPE_DHA = "dha"
    COLLECT_INFO_PACKAGE_EXPORT_PATH_HEADER = "Package Path:"
    COLLECT_DHA_MAX_LOOP_TIMES = 5
    
    #********************信息收集类型********************
    EXPORT_TYPE_LOG = "log"
    EXPORT_TYPE_ALLLOG = "all_log"
    EXPORT_TYPE_EVENT = "event"
    EXPORT_TYPE_RUNNING_DATA = "running_data"
    EXPORT_TYPE_HISPERFORMANCE_DATA = "history_performance_data"
    COLLECT_TYPE_CLI = "cli"
    COLLECT_TYPE_ELABLE = "elable"
    COLLECT_TYPE_SMART = "smart"
    COLLECT_TYPE_DISKLOG = "disklog"
    COLLECT_TYPE_DHA_LOG = "disk_log"
    COLLECT_TYPE_HOST_INFO = "host_info"
    COLLECT_TYPE_DIAGNOSTIC = "diagnostic"
    COLLECT_TYPE_HISTORY_CAPACITY = "capacity_file"
    COLLECT_TYPE_FTDS_STATDATA = "ftds_statdata"
    COLLECT_TYPE_CLI_FAULT_TREE = "cli_fault_tree"
    COLLECT_TYPE_DISK_DATA_ERASURE_REPORT = "disk_data_erasure_report"
    COLLECT_TYPE_WORK_LOAD = 'performance_model_log'
    COLLECT_TYPE_WORK_LOAD_FILE = 'performance_model_log'
    COLLECT_TYPE_CONTAINER_LOG = 'container_log'
    COLLECT_TYPE_CONTAINER_EVENT = 'container_event'
    COLLECT_TYPE_CLOUDBACKUP_CONTAINER_LOG = 'cloudbackup_container_log'
    COLLECT_TYPE_CLOUDBACKUP_CONTAINER_EVENT = 'cloudbackup_container_event'
    COLLECT_PRIVATE_LOG = 'private'
    COLLECT_KEY_LOG = 'key_log'
    COLLECT_TYPE_POTENTIAL_RISK = 'potential_risk'
    SYSTEM_RUNNING_STATUS_UPGRADING = "upgrade:/>"
    WORK_LOAD_DEFAULT_START_DAY = 0
    WORK_LOAD_ONE_DAY_END = 1
    WORK_LOAD_ONE_MONTH = 30
    HIGH_END_SERIES_DEV_TYPE_LIST = ["18500", "18800", "18800F", "HVS88T", "HVS85T"]
    
    # 18000SVP设备型号
    SVP_DEV_TYPES = ["HVS85T", "HVS88T", "18500", "18800", "18800F", "18500 V3", "18800 V3", "18500F V3", "18800F V3", "18500 V5", "18800 V5", "18500F V5", "18800F V5"]

    # 使用RoleId判断用户权限的设备型号
    CHECK_RIGHT_BY_ROLEID_DEV_TYPES = ["OceanStor Dorado 3000 V6",
                                       "OceanStor Dorado 2000",
                                       "OceanStor Dorado 2020",
                                       "OceanStor Dorado 2100",
                                       "OceanStor Dorado 5000 V6",
                                       "OceanStor Dorado 5300 V6",
                                       "OceanStor Dorado 5500 V6",
                                       "OceanStor Dorado 5600 V6",
                                       "OceanStor Dorado 5800 V6",
                                       "OceanStor Dorado 6000 V6",
                                       "OceanStor Dorado 6800 V6",
                                       "OceanStor Dorado 8000 V6",
                                       "OceanStor Dorado 18000 V6",
                                       "OceanStor Dorado 18500 V6",
                                       "OceanStor Dorado 18800 V6",
                                       "OceanStor Dorado 18800K V6",
                                       "OceanStor Dorado 5600K V6",
                                       "OceanStor Dorado 3000",
                                       "OceanStor Dorado 5000",
                                       "OceanStor Dorado 6000",
                                       "OceanStor Dorado 8000",
                                       "OceanStor Dorado 18000",
                                       "OceanStor Dorado 5300",
                                       "OceanStor Dorado 5500",
                                       "OceanStor Dorado 5600",
                                       "OceanStor Dorado 6800",
                                       "OceanStor Dorado 18500",
                                       "OceanStor Dorado 18800",
                                       "OceanStor Dorado 5600K",
                                       "OceanStor Dorado 18800K",
                                       "OceanStor 2200",
                                       "OceanStor 2220",
                                       "OceanStor 5120",
                                       "OceanStor 2600",
                                       "OceanStor 2620",
                                       "OceanStor 5210",
                                       "OceanStor 5220",
                                       "OceanStor 5310",
                                       "OceanStor 5310 Capacity Flash",
                                       "OceanStor 5510 Capacity Flash",
                                       "OceanStor A300",
                                       "OceanStor 5320",
                                       "OceanStor 5510",
                                       "OceanStor 5510S",
                                       "OceanStor 5300K",
                                       "OceanStor 5500K",
                                       "OceanStor 5610",
                                       "OceanStor 5810-HS",
                                       "OceanStor 6810",
                                       "OceanStor 18510",
                                       "OceanStor 18500K",
                                       "OceanStor 18810",
                                       "OceanProtect X3000",
                                       "OceanProtect X8000",
                                       "OceanProtect E8000",
                                       "OceanProtect X9000",
                                       "OceanProtect A8000",
                                       "OceanProtect X6000",
                                       "OceanProtect X8000K",
                                       "OceanProtect X9000K",
                                       "OceanStor Micro 1300",
                                       "OceanStor Micro 1500",
                                       "OceanDisk 1300",
                                       "OceanDisk 1500",
                                       "OceanDisk 1600",
                                       "OceanDisk 1610",
                                       "OceanDisk 1500T",
                                       "OceanDisk 1600T",
                                       "OceanDisk 1610T",
                                       "OceanStor 2910",
                                       "OceanStor A800"]

    # DoradoV6的设备型号
    DORADO_V6_DEV_TYPES = ["OceanStor Dorado 3000 V6",
                           "OceanStor Dorado 2000",
                           "OceanStor Dorado 2020",
                           "OceanStor Dorado 2100",
                           "OceanStor Dorado 5000 V6",
                           "OceanStor Dorado 5300 V6",
                           "OceanStor Dorado 5500 V6",
                           "OceanStor Dorado 5600 V6",
                           "OceanStor Dorado 5800 V6",
                           "OceanStor Dorado 6000 V6",
                           "OceanStor Dorado 6800 V6",
                           "OceanStor Dorado 8000 V6",
                           "OceanStor Dorado 18000 V6",
                           "OceanStor Dorado 18500 V6",
                           "OceanStor Dorado 18800 V6",
                           "OceanStor Dorado 18800K V6",
                           "OceanStor Dorado 5600K V6",
                           "OceanStor Dorado 3000",
                           "OceanStor Dorado 5000",
                           "OceanStor Dorado 6000",
                           "OceanStor Dorado 8000",
                           "OceanStor Dorado 18000",
                           "OceanStor Dorado 5300",
                           "OceanStor Dorado 5500",
                           "OceanStor Dorado 5600",
                           "OceanStor Dorado 6800",
                           "OceanStor Dorado 18500",
                           "OceanStor Dorado 18800",
                           "OceanStor Dorado 5600K",
                           "OceanStor Dorado 18800K",
                           "OceanStor 2200",
                           "OceanStor 2220",
                           "OceanStor 5120",
                           "OceanStor 2600",
                           "OceanStor 2620",
                           "OceanStor 5210",
                           "OceanStor 5220",
                           "OceanStor 5310",
                           "OceanStor 5310 Capacity Flash",
                           "OceanStor 5510 Capacity Flash",
                           "OceanStor A300",
                           "OceanStor 5320",
                           "OceanStor 5510",
                           "OceanStor 5510S",
                           "OceanStor 5300K",
                           "OceanStor 5500K",
                           "OceanStor 5610",
                           "OceanStor 5810-HS",
                           "OceanStor 6810",
                           "OceanStor 18510",
                           "OceanStor 18500K",
                           "OceanStor 18810",
                           "OceanProtect X3000",
                           "OceanProtect X8000",
                           "OceanProtect E8000",
                           "OceanProtect X9000",
                           "OceanProtect A8000",
                           "OceanProtect X6000",
                           "OceanProtect X8000K",
                           "OceanProtect X9000K",
                           "OceanStor Micro 1300",
                           "OceanStor Micro 1500",
                           "OceanDisk 1300",
                           "OceanDisk 1500",
                           "OceanDisk 1600",
                           "OceanDisk 1610",
                           "OceanDisk 1500T",
                           "OceanDisk 1600T",
                           "OceanDisk 1610T",
                           "OceanStor 2910",
                           "OceanStor A800"]

    # container_log、container_event收集设备型号（需要收集容器特性的设备型号）
    COLLECT_CONTAINER_INFO_DEV_TYPES = ["OceanStor Dorado 5000 V6",
                                        "OceanStor Dorado 5500 V6",
                                        "OceanStor Dorado 5600 V6",
                                        "OceanStor Dorado 6000 V6",
                                        "OceanStor Dorado 6800 V6",
                                        "OceanStor Dorado 8000 V6",
                                        "OceanStor Dorado 18000 V6",
                                        "OceanStor Dorado 18500 V6",
                                        "OceanStor Dorado 18800 V6",
                                        "OceanStor Dorado 5000",
                                        "OceanStor Dorado 5500",
                                        "OceanStor Dorado 5600",
                                        "OceanStor Dorado 6000",
                                        "OceanStor Dorado 6800",
                                        "OceanStor Dorado 8000",
                                        "OceanStor Dorado 18000",
                                        "OceanStor Dorado 18500",
                                        "OceanStor Dorado 18800",
                                        "OceanStor 5510",
                                        "OceanStor 5510 Capacity Flash",
                                        "OceanStor A300",
                                        "OceanStor 5610",
                                        "OceanStor 5810-HS",
                                        "OceanStor 6810",
                                        "OceanStor 18510",
                                        "OceanStor 18810",
                                        "OceanStor 18500K",
                                        "OceanProtect A8000",
                                        "OceanProtect X3000",
                                        "OceanProtect X6000",
                                        "OceanProtect X8000",
                                        "OceanProtect E8000",
                                        "OceanProtect X8000K",
                                        "OceanProtect X9000",
                                        "OceanProtect X9000K"]

    # 所有版本均不做脱敏操作的设备型号
    # Dorado、新融合只有615之后版本的新型号、二级存只有1.2.0之后版本的新型号，配置在这里，不做脱敏操作
    NON_ANONYMIZATION_DEV_TYPES = ["OceanStor 2910",
                                   "OceanStor Micro 1300",
                                   "OceanStor Micro 1500",
                                   "OceanDisk 1300",
                                   "OceanDisk 1500",
                                   "OceanDisk 1600",
                                   "OceanDisk 1610",
                                   "OceanDisk 1500T",
                                   "OceanDisk 1600T",
                                   "OceanDisk 1610T",
                                   "OceanStor A800"]
    # 二级存储设备1.2.0及之后版本不做脱敏操作（二级存储新型号，确认底座版本全都在1.2.0之后，配置在【所有版本均不做脱敏操作】列表中）
    PARTIALLY_UNSENSITIZED_DEV_TYPES = ["OceanProtect X3000",
                                        "OceanProtect X8000",
                                        "OceanProtect E8000",
                                        "OceanProtect X9000",
                                        "OceanProtect A8000",
                                        "OceanProtect X6000",
                                        "OceanProtect X8000K",
                                        "OceanProtect X9000K"]

    # 收集cli命令，需要调用LIST_CLI_CMD_DORADO_V3的daradoV3设备
    CLI_TAILORED_DORADO_V3_DEV_TYPES = [
        "Dorado18000 V3",
        "Dorado6000 V3",
        "Dorado5000 V3",
        "Dorado3000 V3"
    ]

    # 18000设备SVP上带有FTP服务的linux VM系统的IP，可用户DHA文件的下载
    SVP_LINUX_VM_IP = "172.17.126.11"
    
    DISK_LOG_CLCT_USING_CLI_VERSION = ["V500R007C00", "V300R006C10"]
    #收集到得信息存放的本地路径
    COLLECT_INFO_LOCAL_PATH = "collect_info_local_path"
    
    #判断系统日志是否收集完全
    COLLECT_LOG_FILE_INFO = ["info_log.txt", "file_list.txt"]
    
    #判断导出命令的回显是否正常的标准
    COLLECT_INFO_RECROD_STANDARD = "File Path :"
    
    #收集信息所存放的目录名称
    COLLECT_INFO_DIR_NAME = {
        EXPORT_TYPE_LOG: "System_log",
        EXPORT_TYPE_ALLLOG: "System_log",
        EXPORT_TYPE_EVENT: "Alarm_log",
        EXPORT_TYPE_RUNNING_DATA: "Running_Data",
        EXPORT_TYPE_HISPERFORMANCE_DATA: "History_Performance_Data",
        COLLECT_TYPE_CLI: "CLI_command_info",
        COLLECT_TYPE_HOST_INFO: "Host_info",
        COLLECT_TYPE_ELABLE: "Electronical_label",
        COLLECT_TYPE_SMART: "Smart_information",
        COLLECT_TYPE_DISKLOG: "Disklog",
        COLLECT_TYPE_DHA: "DHA_information",
        COLLECT_TYPE_DIAGNOSTIC: "Diagnostic_file",
        COLLECT_TYPE_HISTORY_CAPACITY: "Capacity_file",
        COLLECT_TYPE_FTDS_STATDATA: "ftds_statdata",
        COLLECT_TYPE_CLI_FAULT_TREE: "CLI_command_info",
        COLLECT_TYPE_DISK_DATA_ERASURE_REPORT: "Disk_Data_Erasure_Report",
        COLLECT_TYPE_WORK_LOAD: "Performance_model_log",
        COLLECT_TYPE_CONTAINER_LOG: "Container_log",
        COLLECT_TYPE_CONTAINER_EVENT: "Container_event",
        COLLECT_TYPE_CLOUDBACKUP_CONTAINER_LOG: "cloudbackup/Container_log",
        COLLECT_TYPE_CLOUDBACKUP_CONTAINER_EVENT: "cloudbackup/Container_log/Container_event",
        COLLECT_PRIVATE_LOG: "Private_Log",
        COLLECT_KEY_LOG: "Key_Log",
        COLLECT_TYPE_DHA_LOG: "DHA_information",
        COLLECT_TYPE_POTENTIAL_RISK : "History_Fault_Table"
    }
    
    # Arm 架构的存储产品型号列表.
    ARM_ARCHITECTURE_DEV_TYPE_LIST = ['2200 V3', '2600 V3', '2600F V3', '2600 V3 for Video']
    
    #需要判断系统日志，具体信息是否收全的项
    IS_SYSTEM_INFO_FULL = [EXPORT_TYPE_LOG, EXPORT_TYPE_ALLLOG]
    
    #需要判断控制器，是否收全的项
    IS_CONTROLLER_INFO_FULL = [EXPORT_TYPE_LOG, EXPORT_TYPE_ALLLOG,
                               COLLECT_TYPE_SMART, COLLECT_PRIVATE_LOG,
                               COLLECT_KEY_LOG, COLLECT_TYPE_DHA_LOG]

    # 使用异步命令的收集信息，并且有IP框信息的收集项
    IS_ASYNCHRONOUS_CMD_HAS_IP_ENCLOSURE = [EXPORT_TYPE_LOG,
                                            EXPORT_TYPE_ALLLOG,
                                            COLLECT_TYPE_SMART,
                                            COLLECT_TYPE_FTDS_STATDATA,
                                            COLLECT_PRIVATE_LOG,
                                            COLLECT_KEY_LOG,
                                            COLLECT_TYPE_DHA_LOG]

    # 故障诊断->信息收集->自定义收集场景；只下发控制器的场景
    CUSTOM_ONLY_COLLECT_CONTROLLER_ITEM = [EXPORT_TYPE_LOG,
                                           COLLECT_TYPE_SMART,
                                           COLLECT_KEY_LOG,
                                           COLLECT_TYPE_FTDS_STATDATA]

    #删除阵列端临时文件判断标准
    DELETE_REMOTE_DATA_STANDARD = [
                                   "System is exporting files"
                                   ]
    
    #********************信息收集类型********************
    
    EXPORT_INFO_TIMEOUT = {
        EXPORT_TYPE_LOG: 23 * 60,
        EXPORT_TYPE_ALLLOG: 23 * 60,
        EXPORT_TYPE_EVENT: 23 * 60,
        EXPORT_TYPE_RUNNING_DATA: 23 * 60,
        COLLECT_TYPE_SMART: 183 * 60,
        COLLECT_TYPE_DISKLOG: 3 * 60,
        COLLECT_TYPE_DHA: 15 * 60,
        COLLECT_TYPE_FTDS_STATDATA: 33 * 60,
        COLLECT_PRIVATE_LOG: 23 * 60,
        COLLECT_KEY_LOG: 23 * 60,
        COLLECT_TYPE_DHA_LOG: 45 * 60,
        COLLECT_TYPE_POTENTIAL_RISK : 3 * 60
    }

    V6_EXPORT_INFO_TIMEOUT = {
        # 6.1.0之后的版本超时时间为45分钟
        COLLECT_TYPE_DHA: 45 * 60,
    }

    #并行方式收集的超时时间，单位：分
    PARALLEL_EXPORT_INFO_TIMEOUT = {
        EXPORT_TYPE_LOG: 60,
        EXPORT_TYPE_ALLLOG: 60,
        COLLECT_TYPE_SMART: 183,
        COLLECT_TYPE_DIAGNOSTIC: 10,
        COLLECT_TYPE_HISTORY_CAPACITY: 10,
        COLLECT_TYPE_FTDS_STATDATA: 33,
        COLLECT_PRIVATE_LOG: 60,
        COLLECT_KEY_LOG: 60,
        COLLECT_TYPE_DHA_LOG: 45,
        COLLECT_TYPE_DHA: 45
    }
	
    # 隔离盘日志收集超时时间，单位：分钟
    FAULT_DISK_LOG_TIMEOUT = 12

    #一般CLI命令的超时时间：2分钟
    COMMON_CMD_TIMEOUT = 2*60
    
    CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"
    
    #判断新命令执行成功的列表
    ISEXEC_CMD_SUCCESS_FLAG = [
                               "File Path : /OSM/export_import/",
                               "File Path : /OSM/coffer_data/omm/export_import",
                                ]
    
    #CLI回显、电子标签、smart信息收集，对应的文件名称
    CLI_FILE_NAMES_FOR_TYPE = {
        COLLECT_TYPE_CLI: "clicmd.txt",
        COLLECT_TYPE_ELABLE: "elabel_info.txt",
        COLLECT_TYPE_CLI_FAULT_TREE: 'fault_diagnose_info.txt'
    }
    
    #CLI回显收集的命令列表，为满足三板斧需求"show port bit_error"需要间隔收集6次
    LIST_CLI_CMD = ["show port bit_error",
                    "show alarm",
                    "show bond_port",
                    "show cache_partition general",
                    "show clone general",
                    "show consistency_group general",
                    "show controller general",
                    "show disk_domain general",
                    "show enclosure",
                    "show port bit_error",
                    "show event_restore",
                    "show host general",
                    "show host_group general",
                    "show initiator",
                    "show iostat policy",
                    "show iscsi initiator_name",
                    "show iscsi target",
                    "show iscsi target_name",
                    "show isns server_ip",
                    "show license",
                    "show license_active",
                    "show lun general",
                    "show port bit_error",
                    "show notification trap",
                    "show port general",
                    "show port_group general",
                    "show remote_device general",
                    "show remote_replication general",
                    "show schedule",
                    "show security_rule",
                    "show smartqos_policy general",
                    "show smartqos_template",
                    "show snapshot general",
                    "show snmp context_name",
                    "show snmp usm",
                    "show port bit_error",
                    "show ssd routeswitch",
                    "show storage_engine",
                    "show system general",
                    "show system media_scan",
                    "show system ntp",
                    "show system timezone",
                    "show system manufactory",
                    "show upgrade package",
                    "show user",
                    "show event_config",
                    "show notification syslog",
                    "show notification sms",
                    "show version all",
                    "show lun_migration general",
                    "show lun_destroy_data upgrade_status",
                    "show mapping_view general",
                    "show mirror_lun general",
                    "show remote_lun general array_type=replication",
                    "show remote_lun general array_type=heterogeneity",
                    "show smart_cache_pool general",
                    "show smart_cache_partition general",
                    "show lun dedup_compress",
                    "show logical_port general",
                    "show vlan count",
                    "show vlan general",
                    "show failover_group general",
                    "show disk general",
                    "show port bit_error",
					"show vstore",
                    "show fs_snapshot general",
                    "show file_system general",
                    "show service cifs",
                    "show common_config nfs",
                    "show service nfs",
                    "show virtual_machine general",
                    "show virtual_machine port",
                    "show vnc safe_policy",
                    "show vm_fs general",
                    "show virtual_machine block",
                    "show vm_container general",
                    "show vmtools general",
                    "show vhba general",
                    "show vhost_initiator general",
                    "show ib_port general",
					"show storage_pool general",
                    "show port bit_error",
                    "show host lun"
                   ]
    
    #Dorado V3 CLI回显信息收集命令列表
    LIST_CLI_CMD_DORADO_V3 = [
                            "show alarm",
                            "show bond_port",
                            "show consistency_group general",
                            "show controller general",
                            "show disk_domain general",
                            "show enclosure",
                            "show event",
                            "show event_restore",
                            "show host general",
                            "show host_group general",
                            "show initiator",
                            "show iostat policy",
                            "show iscsi initiator_name",
                            "show iscsi target",
                            "show iscsi target_name",
                            "show isns server_ip",
                            "show license",
                            "show license_active",
                            "show lun general",
                            "show notification trap",
                            "show port general",
                            "show port_group general",
                            "show remote_device general",
                            "show remote_replication general",
                            "show security_rule",
                            "show snapshot general",
                            "show snmp context_name",
                            "show snmp usm",
                            "show ssd routeswitch",
                            "show system general",
                            "show system media_scan",
                            "show system ntp",
                            "show system timezone",
                            "show system manufactory",
                            "show upgrade package",
                            "show user",
                            "show event_config",
                            "show notification syslog",
                            "show notification sms",
                            "show version all",
                            "show lun_migration general",
                            "show remote_lun general array_type=replication",
                            "show remote_lun general array_type=heterogeneity",
                            "show ib_port general",
                            "show host lun"
                              ]
    # Dorado V3 CLI回显信息收集命令列表
    LIST_CLI_CMD_DORADO_V6 = [
        "show alarm",
        "show bond_port",
        "show consistency_group general",
        "show controller general",
        "show disk_domain general",
        "show enclosure",
        "show event_restore",
        "show host general",
        "show host_group general",
        "show initiator",
        "show iostat policy",
        "show iscsi initiator_name",
        "show iscsi target",
        "show iscsi target_name",
        "show isns server_ip",
        "show license",
        "show license_active",
        "show lun general",
        "show notification trap",
        "show port general",
        "show port_group general",
        "show remote_device general",
        "show remote_replication general",
        "show security_rule",
        "show snapshot general",
        "show snmp context_name",
        "show snmp usm",
        "show ssd routeswitch",
        "show system general",
        "show system media_scan",
        "show system ntp",
        "show system timezone",
        "show system manufactory",
        "show upgrade package",
        "show user",
        "show event_config",
        "show notification syslog",
        "show notification sms",
        "show version all",
        "show lun_migration general",
        "show remote_lun general array_type=heterogeneity",
        "show host lun"
    ]

    # dorao616、新融合616、二级存储130及之后版本，配置文件里有的cli命令，收集配置文件则cli回显不收如下命令
    LIST_CLI_CMD_DORADO_V6_CONFIG_HAS = [
        "show bond_port",
        "show consistency_group general",
        "show controller general",
        "show disk_domain general",
        "show enclosure",
        "show event_restore",
        "show host general",
        "show host_group general",
        "show initiator",
        "show license",
        "show lun general",
        "show notification trap",
        "show port general",
        "show port_group general",
        "show remote_device general",
        "show remote_replication general",
        "show snapshot general",
        "show system general",
        "show system ntp",
        "show user",
        "show event_config",
        "show notification syslog",
        "show notification sms",
        "show version all",
        "show lun_migration general",
        "show host lun"
    ]

    # dorao616、新融合616、二级存储130及之后版本，告警文件里有的cli命令，收集告警文件项则cli回显不收这条命令
    LIST_CLI_CMD_DORADO_V6_ALARM_HAS = [
        "show alarm"
    ]

    # dorao616、新融合616、二级存储130及之后版本，cli回显必收命令命令
    LIST_CLI_CMD_DORADO_V6_ALL_NEED = [
        "show iostat policy",
        "show iscsi initiator_name",
        "show iscsi target",
        "show iscsi target_name",
        "show isns server_ip",
        "show security_rule",
        "show snmp context_name",
        "show snmp usm",
        "show ssd routeswitch",
        "show system media_scan",
        "show system timezone",
        "show system manufactory",
        "show upgrade package",
        "show remote_lun general array_type=heterogeneity"
    ]

    # dorao616、新融合616、二级存储130及之后版本，收集cli命令组合
    LIST_CLI_CMD_COMBO = {
        "two_item": LIST_CLI_CMD_DORADO_V6_ALL_NEED,
        "running_data": LIST_CLI_CMD_DORADO_V6_ALL_NEED + LIST_CLI_CMD_DORADO_V6_ALARM_HAS,
        "event": LIST_CLI_CMD_DORADO_V6_ALL_NEED + LIST_CLI_CMD_DORADO_V6_CONFIG_HAS
    }

    #需要收集详细信息的CLI列表
    LIST_MULTI_CLI_CMD = {
                          "show enclosure" : ["ID", "enclosure_id="],
                          "show storage_engine" : ["ID", "storage_engine_id="],
                          "show fs_snapshot general" : ["ID", "file_system_id=", "show file_system general"],
                          "show remote_lun general array_type=replication" : ["ID", "remote_device_id=", "show remote_device general array_type=replication"],
                          "show remote_lun general array_type=heterogeneity" : ["ID", "remote_device_id=", "show remote_device general array_type=heterogeneity"],
                          "show host lun" : ["ID", "host_id=", "show host general"]
                        }
    
    #需要进入developer模式发送的命令
    LIST_DEVELOPER_CMD = ["show dha judgeproportion", 
                          "show dha policy", 
                          "show dha servicestatus", 
                          "show mp_mode",
                          "show disk link_rate"
                        ]
    
    #收集电子标签的CLI列表
    LIST_ELABLE_CMD = [
                       "show controller general",
                       "show bbu general",
                       "show fan",
                       "show interface_module",
                       "show expansion_module"
                       ]
    
    #收集电子标签详细信息的CLI列表
    LIST_MULTI_ELABLE_CMD = {
                             "show bbu general" : ["ID", "bbu_id="],
                             "show fan" : ["ID", "fan_id="],
                             "show interface_module" : ["ID", "interface_module_id="],
                             "show expansion_module" : ["ID", "expansion_module_id="]
                             }
    
    #是否包含，收集CLI的详细信息
    MULTI_CLI_COLLECT = {
                         COLLECT_TYPE_CLI : LIST_MULTI_CLI_CMD,
                         COLLECT_TYPE_ELABLE : LIST_MULTI_ELABLE_CMD
                         }
    
    
    #电子标签文件的头信息
    ELABLE_LIST_HEADER = '<?xml version="1.0" encoding="iso-8859-1" standalone="yes" ?>\n'
    
    #电子标签文件的内容，XML格式的标签名称
    LIST_ELABLE_PROPERTY = {
                            "show controller general" : "Device",
                            "show bbu general" : "BBU",
                            "show fan" : "FAN",
                            "show interface_module" : "INTERFACE_MODULE",
                            "show expansion_module" : "EXPANSION_MODULE"
                            }
    #CLI命令的超时时间(部分CLI执行时间不是默认的2min)
    cmdLimitTimeDict = {
                        "show event" : 300,
                        }

    RECENT_FAULTLOG_MAX_SIZE = 10L * 1024 * 1024

    COLLECT_ITEM = {
        "all_log": EXPORT_TYPE_ALLLOG,
        "all_logs": EXPORT_TYPE_ALLLOG,
        "smart": COLLECT_TYPE_SMART,
        "dha": COLLECT_TYPE_DHA
    }
