# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from common.util import util
from java.lang import Exception as JException
from com.huawei.ism.tool.infocollect.util import ComputeStorageFcvCollectImpl

TOTAL_PROGRESS = 90
INITIAL_PROGRESS = 1


def get_current_process(current_process, process):
    return (process - current_process) / 3 + current_process


class ComputeNodesCollect:

    def __init__(self, dev_obj, logger):
        self.dev_obj = dev_obj
        self.logger = logger
        self.dev_node = dev_obj.get("devNode")
        self.compute_nodes_info_collector = ComputeStorageFcvCollectImpl(self.dev_node)
        self.item = dev_obj.get("currentItem")
        self.is_all_failed = True
        self.err_msg = []

    def execute_collect(self):
        self.logger.info(self.dev_obj, "Start collect compute nodes.")
        try:
            self.collect_compute_info()
            util.refreshProcess(self.dev_obj, 92)
            self.error_msg_handle()
            self.save_collect_status()
        except (Exception, JException) as e:
            self.logger.error(self.dev_obj, "collect compute nodes failed. \n{}".format(str(e)))
            return self.exception_handle(e)
        return True

    def collect_compute_info(self):
        current_process = INITIAL_PROGRESS
        groups_count = self.item.getGroupsCount()
        self.logger.info(self.dev_obj, "groups count is {}".format(groups_count))
        for group_index in range(1, groups_count + 1):
            process = self.get_process(groups_count, group_index)
            self.compute_nodes_info_collector.cleanErrMsg()
            self.compute_nodes_info_collector.packComputeNodes(group_index)
            current_process = get_current_process(current_process, process)
            util.refreshProcess(self.dev_obj, current_process)
            self.compute_nodes_info_collector.queryPackingProgress()
            self.compute_nodes_info_collector.downloadFile(self.dev_obj.get("collect_info_local_path"))
            current_process = process
            util.refreshProcess(self.dev_obj, current_process)
            self.is_all_failed = False

    def get_process(self, groups_count, group_index):
        try:
            return TOTAL_PROGRESS / (groups_count * group_index)
        except ZeroDivisionError:
            self.logger.error(self.dev_obj, "the groups_count * group_index is zero")
            return INITIAL_PROGRESS

    def exception_handle(self, e):
        # java侧抛出的异常，保存ErrorId中的信息
        if isinstance(e, JException):
            self.err_msg.append(e.getErrorId())
        # 如果之前有收集成功的项，则整体部分成功，保存错误信息
        if not self.is_all_failed:
            self.error_msg_handle()
            self.save_collect_status()
            return True
        self.save_collect_status()
        return False

    def error_msg_handle(self):
        msg = self.compute_nodes_info_collector.getErrorMsg()
        if msg:
            self.err_msg.append(msg)
        self.save_collect_status()

    def save_collect_status(self):
        if not self.err_msg:
            return
        self.dev_obj["py_detail"] = "\n".join(self.err_msg)
        self.dev_obj["collectAllInfo"] = False
