# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import os
import shutil
import stat
import time
import traceback
import subprocess
from common.util import device
from common.util import log
from common.util import util
from frameone.util import collect_util
from com.huawei.ism.tool.obase.utils import FileAssistant

# 写 | 创建并打开 | 截断
OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC
# 拥有者具有读写权限
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR


def execute(dev_obj):
    try:
        util.refreshProcess(dev_obj, 1)
        local_dir = util.getLocalDir(dev_obj)
        collect_ret_file_name = dev_obj.get("collectRetFileName")
        collect_path = local_dir + os.path.sep + collect_ret_file_name

        # 压缩前，增加eServer描述文件
        creat_pkginfo(collect_path, dev_obj)
        util.refreshProcess(dev_obj, 10)

        # 压缩文件
        local_file_final = collect_ret_file_name + ".7z"
        # util.getLocalDir里在保存目录新增了一层temp，这里最后结果仍然保存到用户指定路径
        compress_file_path = dev_obj.get("collectRetDir") + os.path.sep + local_file_final
        log.info(dev_obj, "compress_file_path:{}".format(compress_file_path))
        collect_util.copy_log_and_ini_to_collect_ret_dir(dev_obj, collect_path)
        FileAssistant.compressDirTo7ZFile(compress_file_path, collect_path + os.path.sep + "*", "-t7z")
        dev_obj["collectRetFileName"] = local_file_final
        util.refreshProcess(dev_obj, 50)
        util.cleanDir(collect_path, dev_obj, log)
        # 删除temp文件夹
        if local_dir.endswith("temp") and not os.listdir(local_dir):
            util.deleteDir(local_dir)
        util.refreshProcess(dev_obj, 80)

        # 去掉权限
        try:
            subprocess.check_call('icacls "' + compress_file_path + '" /inheritance:d')
            subprocess.check_call('icacls "' + compress_file_path + '" /remove:g Users')
        except Exception:
            log.info(dev_obj, "check call fail:{}".format(str(traceback.format_exc())))
        util.refreshProcess(dev_obj, 99)
        return True, ""
    except Exception:
        log.info(dev_obj, "except trace back:{}".format(traceback.format_exc()))
        dev_obj["py_detail"] = "catch except when compress file.~~~over!"
        return False, ""
    finally:
        util.refreshProcess(dev_obj, 100)


def creat_pkginfo(collect_path, dev_obj):
    pkginfo_path = collect_path + os.sep + "pkginfo"
    type_file = pkginfo_path + os.sep + "type_collect"
    domain_file = pkginfo_path + os.sep + "domain_storage"
    desc_file = pkginfo_path + os.sep + "desc"
    sn_fmt = "deviceSN=${%s}\n"
    time_fmt = "fileCreateTime=%s"
    try:
        # 如果pkginfo已存在，则需要先删除
        delete_pkginfo_file(pkginfo_path)
        os.mkdir(pkginfo_path)

        # 先创建type文件，然后拷贝type并重命名为domain文件
        file_obj = os.fdopen(os.open(type_file, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        file_obj.close()
        shutil.copy(type_file, domain_file)

        # 创建Desc文件并写入SN号和时间（UTC）,获取SN号和时间毫秒数
        desc_file = os.fdopen(os.open(desc_file, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        desc_file.writelines([sn_fmt % str(device.getDeviceSn(dev_obj)), time_fmt % str(long(time.time() * 1000))])
        desc_file.close()
        log.info(dev_obj, "[creatPkginfo] Creat the pkginfo succeed!")
    except Exception:
        delete_pkginfo_file(pkginfo_path)
        log.error(dev_obj, "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))


def delete_pkginfo_file(pkginfo_path):
    if os.path.exists(pkginfo_path):
        shutil.rmtree(pkginfo_path, True)
