﻿# -*- coding: UTF-8 -*-
from java.io import File
from common.util import util, log
from common.cliFactory import cli
from common.config import config
import traceback
import time
import os


def collect(devObj, cmdType):
    """
    @summary: cmdType
    """
    util.refreshProcess(devObj, 1)
    util.initPyDetailMsg(devObj)
    
    # 检查系统状态
    isNormal = util.checkSystemNormal(devObj)
    util.refreshProcess(devObj, 3)
    if not isNormal:
        return False
    
    # 检查用户权限：管理员/超级管理员
    isMeet = util.checkUserPrivilege(devObj)
    util.refreshProcess(devObj, 5)
    if not isMeet:
        return False
    
    # 通知导出文件
    isSucc = notifyArray(devObj, cmdType)
    util.refreshProcess(devObj, 10)
    if not isSucc:
        return False
    
    # 查看诊断文件的导出状态。
    isSucc = checkExportingStatus(devObj, cmdType)
    util.refreshProcess(devObj, 85)
    if not isSucc:
        return False
    
    # 查看导出的文件在阵列上的存放路径。
    filePath = getFilePath(devObj, cmdType)
    util.refreshProcess(devObj, 90)
    if not isSucc:
        return False
    
    # 下载阵列上的文件到本地
    isSucc = downLoadFile(devObj, filePath, cmdType)
    util.refreshProcess(devObj, 99)
    
    # 删除阵列上的临时文件
    deleteFile(devObj, cmdType)
    
    util.refreshProcess(devObj, 100)        
    return isSucc
    

def notifyArray(devObj, cmdType):
    """
    @summary: 
    """
    cmd = "show file export_path file_type=%s" % cmdType
    timeout = config.PARALLEL_EXPORT_INFO_TIMEOUT.get(cmdType)
    isSucc, rec = cli.executeCmdWithTimout(devObj, cmd, timeout * 60)
    if not isSucc:
        util.setPyDetailMsg(devObj, "dev.conn.failure")
        return False
    
    if config.CLI_EXECUTE_CMD_SUCCESS not in rec: 
        util.setPyDetailMsg(devObj, "cli.excute.failure", rec)
        return False
    
    return True

def checkExportingStatus(devObj, cmdType):
    """
    @summary: Check the diagnostic file exporting status 
    """
    cmd = "show file package_result file_type=%s" % cmdType
    process = 10
    timeout = config.PARALLEL_EXPORT_INFO_TIMEOUT.get(config.COLLECT_TYPE_HISTORY_CAPACITY)
    checkTimes = timeout * 60 / 30
    for times in range(0, checkTimes):
        isSucc, rec = cli.executeCmdWithTimout(devObj, cmd, 30)
        
        if process < 85:
            process += 10
        util.refreshProcess(devObj, process)
        
        if not isSucc:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return False
        
        statusDictList = cli.getCliTable2DictList(rec)
        if not statusDictList:
            util.setPyDetailMsg(devObj, "cli.excute.failure", rec)
            return False
    
        status = statusDictList[0].get("Total Result")
        if status == "Packaging":
            time.sleep(30)
            continue
        
        if status == "Successful":
            return True
        else:
            util.setPyDetailMsg(devObj, "cli.excute.failure", rec)
            return False
    
    # 收集超时（5min）   
    log.info(devObj, "Get diagnostic file failed, time over!")
    util.setPyDetailMsg(devObj, "cli.excute.failure", rec)
    return False

def getFilePath(devObj, cmdType):
    """
    @summary: Check the path of the exported diagnostic file in the storage system 
    """
    cmd = "show file notification file_type=%s" % cmdType
    timeout = config.PARALLEL_EXPORT_INFO_TIMEOUT.get(cmdType)
    isSucc, rec = cli.executeCmdWithTimout(devObj, cmd, timeout * 60)
    if not isSucc:
        util.setPyDetailMsg(devObj, "dev.conn.failure")
        return ""
    
    if config.COLLECT_INFO_RECROD_STANDARD not in rec: 
        util.setPyDetailMsg(devObj, "cli.excute.failure", rec)
        return ""
    
    for line in rec.splitlines():
        if config.COLLECT_INFO_RECROD_STANDARD in line:
            filePath = line.split(":")[1].strip()
            return filePath
    
    return ""


def downLoadFile(devObj, filePath, cmdType):
    """
    @summary: 下载阵列诊断文件到本地
    """
    sftp = util.getSftp(devObj)
    localDir = util.getLocalInfoPathByType(devObj, cmdType)
    fileName = os.path.basename(filePath)
    localPath = localDir + fileName
    try:
        log.info(devObj, "file path is %s." % filePath)
        log.info(devObj, "file is putted %s." % localPath)
        localFile = File(localPath)
        sftp.getFile(filePath, localFile, None)
        return True
    except:
        util.setPyDetailMsg(devObj, "downLoad.file.failure")
        log.error(devObj, "download diagnostic file failed.")
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return False
    
def deleteFile(devObj, cmdType):
    """
    @summary: 删除阵列上的临时诊断文件
    """
    cmd = "delete file filetype=%s" % cmdType
    isSucc, rec = cli.executeCmdWithTimout(devObj, cmd, 30)
    if not isSucc:
        log.warn(devObj, "delete file failed.")
        
        
        
        
        
        