# -*- coding:utf-8 -*-
from common.util import *

# 检查LUN拷贝的工作控制器涉及的版本及型号
checking_work_controller_for_lun_copy_version = ['V300R001C10', 'V300R001C10SPC100', 'V300R001C10SPC200', 'V300R001C20',
                                                 'V300R001C20SPC100', 'V300R001C20SPC200', 'V300R002C10',
                                                 'V300R002C10SPC100', 'V300R002C10SPC200', 'V300R003C00',
                                                 'V300R003C00SPC100', 'V300R003C10', 'V300R003C10SPC100',
                                                 'V300R003C20SPC100', 'V300R003C20SPC200', 'V300R005C00SPC300',
                                                 'V300R006C00', 'V300R006C00SPC100', 'V300R006C10']
checking_work_controller_for_lun_copy_model = ['2100 V3', '2200 V3', '2600 V3', '5300 V3', '5500 V3', '5600 V3',
                                               '5800 V3', '6800 V3', '18500 V3', '18800 V3']
# 无LUN拷贝问题的版本及补丁
no_risk_version_and_patch_for_lun_copy = {
    'V300R001C20SPC200': 'V300R001C20SPH211', 'V300R003C10SPC100': 'V300R003C10SPH117',
    'V300R003C20SPC200': 'V300R003C20SPH210', 'V300R005C00SPC300': 'V300R005C00SPH308',
    'V300R006C00SPC100': 'V300R006C00SPH111'
}
ALL_CLI_RET = ''
ALL_ERR_MSG_NO_CHECK = ''
ALL_ERR_MSG_FALSE = ''
standard_value = '2A'
RESULT_NOCHECK = "NOCHECK"


def joinLines(originLines, postLines):
    """
    @summary: 将postLines追加originLines后
    """
    if not (originLines or postLines):
        return ""

    if not originLines:
        return postLines

    if not postLines:
        return originLines

    return "\n".join([originLines, postLines])


def check_lun_copy(dev_obj):
    """
    步骤1 以admin用户登录设备；
    步骤2 执行命令：show lun_copy general，查询LUN拷贝配置，记录LUN拷贝ID；
    步骤3 执行命令：show upgrade package，查询是否有大于或等于“2A”的控制器；
    步骤4 执行命令：show lun_copy member lun_copy_id=ID（ID步骤2中查询到的LUN拷贝ID），并记录源LUN ID（第5行的LUN ID）；
    步骤5 执行命令：show lun general lun_id=ID（ID为步骤5中查询到的源LUN ID），并记录Work Controller字段值；
    检查标准：
    1. 若步骤2不存在LUN拷贝配置则通过，否则继续检查；
    2. 若步骤3中存在大于或等于“2A”的控制器，否则继续检查；
    3. 若步骤5中的Work Controller值小于“2A”则检查通过，否则检查不通过；
    :param dev_obj:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, ALL_ERR_MSG_FALSE
    try:
        flag, software_version, controller_list, hot_patch_version = show_package(dev_obj)
        if software_version in no_risk_version_and_patch_for_lun_copy:
            return_hot_patch = no_risk_version_and_patch_for_lun_copy.get(software_version, '')
        else:
            return_hot_patch = ''
        if not flag:
            return RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
        
        # 检查控制器是否大于2A
        flag = check_controller(controller_list)
        if flag != True:
            return True, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
        
        # 检查是否风险版本
        if not check_product_info(dev_obj, software_version, hot_patch_version):
            return True, ALL_CLI_RET, '', return_hot_patch
        
        #检查是否有LUN COPY
        flag, lun_copy_id_list = get_lun_copy(dev_obj)
        
        # 如果没有lun_copy 则检查通过。
        if not lun_copy_id_list:
            return True, ALL_CLI_RET, '', return_hot_patch
        
        if flag != True:
            return True, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
        
        origin_lun_id_list = []
        for lun_copy_id in lun_copy_id_list:
            flag, origin_lun_id = get_origin_lun_id(dev_obj, lun_copy_id)
            if not flag:
                continue
            origin_lun_id_list.append(origin_lun_id)
        if not origin_lun_id_list:
            return RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
        work_controller_dict = {}
        for origin_lun_id in origin_lun_id_list:
            flag, work_controller = get_work_controller(dev_obj, origin_lun_id)
            if not flag:
                continue
            work_controller_dict[origin_lun_id] = work_controller
        if not work_controller_dict:
            return RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
        check_result(dev_obj, work_controller_dict)
    except:
        log.info(dev_obj, str(traceback.format_exc()))
        return RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
    else:
        if ALL_ERR_MSG_FALSE:
            return False, ALL_CLI_RET, joinLines(ALL_ERR_MSG_FALSE, ALL_ERR_MSG_NO_CHECK), return_hot_patch
        if ALL_ERR_MSG_NO_CHECK:
            return RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK, return_hot_patch
        return True, ALL_CLI_RET, '', return_hot_patch


def check_result(dev_obj, work_controller_dict):
    """
    若步骤6中的Work Controller值小于“2A”则检查通过，否则检查不通过
    :param dev_obj:
    :param work_controller_dict:
    :return:
    """
    global ALL_ERR_MSG_FALSE
    for lun_id, work_controller in work_controller_dict.items():
        if work_controller >= standard_value:
            ALL_ERR_MSG_FALSE = joinLines(ALL_ERR_MSG_FALSE,
                                          util.getMsg(dev_obj, 'exit.work.controller', (lun_id, work_controller)))


def get_work_controller(dev_obj, lun_id):
    """
    执行命令：show lun general lun_id=ID（ID为步骤5中查询到的源LUN ID），并记录Work Controller字段值
    :param dev_obj:
    :param lun_id:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    work_controller = ''
    cmd = 'show lun general lun_id=%s' % lun_id
    flag, cli_ret = cli.executeCmdNoLogTimeout(dev_obj, cmd)
    ALL_CLI_RET = joinLines(ALL_CLI_RET, cli_ret)
    if not flag:
        ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK, util.getMsg(dev_obj, 'cmd.execute.failed', cmd))
        return False, work_controller
    cli_ret_list = util.getVerticalCliRet(cli_ret)
    for cli_ret_dict in cli_ret_list:
        work_controller = cli_ret_dict.get('Work Controller', '')
        if not work_controller:
            ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK,
                                             util.getMsg(dev_obj, 'work.controller.not.exist', lun_id))
            return False, work_controller
    return True, work_controller


def get_origin_lun_id(dev_obj, lun_id):
    """
    执行命令：show lun_copy member lun_copy_id=ID（ID步骤2中查询到的LUN拷贝ID），并记录源LUN ID（第5行的LUN ID）
    :param dev_obj:
    :param lun_id:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    origin_lun_id = ''
    cmd = 'show lun_copy member lun_copy_id=%s' % lun_id
    flag, cli_ret = cli.executeCmdNoLogTimeout(dev_obj, cmd)
    ALL_CLI_RET = joinLines(ALL_CLI_RET, cli_ret)
    if not flag:
        ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK, util.getMsg(dev_obj, 'cmd.execute.failed', cmd))
        return False, origin_lun_id
    cli_ret_lines = cli_ret.splitlines()
    for cli_ret_line in cli_ret_lines:
        if cli_ret_line.strip().startswith('LUN ID'):
            origin_lun_id = cli_ret_line.split(':')[-1].strip()
            break
    if not origin_lun_id:
        ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK, util.getMsg(dev_obj, 'origin.lun.id.not.exist', lun_id))
        return False, origin_lun_id
    return True, origin_lun_id


def check_product_info(dev_obj, software_version, hot_patch_version):
    """
    判断产品是否满足检查的版本及型号范围
    :param dev_obj:
    :param software_version:
    :param hot_patch_version:
    :return:
    """
    product_model = str(device.getDeviceType(dev_obj))
    if software_version in no_risk_version_and_patch_for_lun_copy:
        no_risk_patch = no_risk_version_and_patch_for_lun_copy.get(software_version, '')
        if hot_patch_version >= no_risk_patch:
            return False
    if software_version in checking_work_controller_for_lun_copy_version and product_model in checking_work_controller_for_lun_copy_model:
        return True
    return False


def get_lun_copy(dev_obj):
    """
    执行命令：show lun_copy general，查询LUN拷贝配置，记录LUN拷贝ID
    :param dev_obj:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    cmd = 'show lun_copy general'
    flag, cli_ret = cli.executeCmdNoLogTimeout(dev_obj, cmd)
    ALL_CLI_RET = joinLines(ALL_CLI_RET, cli_ret)
    lun_copy_id_list = []
    if util.queryResultWithNoRecord(cli_ret):
        return True, lun_copy_id_list
    if flag != True:
        return False, lun_copy_id_list
    cli_ret_list = util.getHorizontalCliRet(cli_ret)
    for index, cli_ret_dict in enumerate(cli_ret_list):
        lun_copy_id = cli_ret_dict.get('ID', '')
        if not lun_copy_id:
            ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK,
                                             util.getMsg(dev_obj, 'get.lun.copy.id.failed', index + 1))
            continue
        lun_copy_id_list.append(lun_copy_id)
        
    return True, lun_copy_id_list


def show_package(dev_obj):
    """
    执行命令：show upgrade package；
    :param dev_obj:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    cmd = 'show upgrade package'
    software_version = ''
    contr_name_list = []
    hot_patch_version = ''
    flag, cli_ret = cli.executeCmdNoLogTimeout(dev_obj, cmd)
    ALL_CLI_RET = joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK, util.getMsg(dev_obj, 'cmd.execute.failed', cmd))
        return False, software_version, contr_name_list, hot_patch_version
    software_version_index = cli_ret.find('Software Version')
    hot_patch_version_index = cli_ret.find('HotPatch Version')
    software_version_list = []
    hot_patch_version_list = []
    if software_version_index != -1 and hot_patch_version_index != -1:
        software_version_list = util.getHorizontalCliRet(cli_ret[software_version_index:hot_patch_version_index])
        hot_patch_version_list = util.getHorizontalCliRet(cli_ret[hot_patch_version_index:])
    for software_version_dict in software_version_list:
        software_version = software_version_dict.get('Current Version', '')
        contr_name = software_version_dict.get('Name', '')
        contr_name_list.append(contr_name)
    for hot_patch_version_dict in hot_patch_version_list:
        hot_patch_version = hot_patch_version_dict.get('Current Version', '')
    if software_version and (contr_name_list and '' not in contr_name_list) and hot_patch_version:
        return True, software_version, contr_name_list, hot_patch_version
    ALL_ERR_MSG_NO_CHECK = joinLines(ALL_ERR_MSG_NO_CHECK, util.getMsg(dev_obj, 'query.result.abnormal'))
    return False, software_version, contr_name_list, hot_patch_version


def check_controller(controller_list):
    """
    检查是否存在大于等于2A的控制器
    :param controller_list:
    :return:
    """
    flag = False
    for controller_name in controller_list:
        if controller_name >= standard_value:
            flag = True
    return flag
