﻿# -*- coding: UTF-8 -*-
import traceback
import time
import os

from common.util import *
from common.util import log
from common.exportCmd import *
from common.exportInfo import *
from common.exportInfo import exportInfo

from cbb.frame.cli.cli_con_check_4_info_collect import CliUtil as CliCheckUtil
from cbb.business.collect.deviceInfo.collect_cmd import MultiCmdExecuter

from common.dealSmartInfo import dealSmartInfo
from common.DhaInfoCollector import DhaInfoCollector
import diagnosticCollector
from check_item_service_work_controller_luncopy import check_lun_copy,show_package
from frameone.util import contextUtil
from common.commonUtils import CommonUtils
from common.commonUtils import Log
from common.sshTools import SSHToolUtils
from common.config import config

FILE_NUM_THRESHOLD = 1000


def collectLog(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        checkFlag, msg = __isPreCollectionLogCheck(devObj, config.CHECK_KVM_PATH)
        if not checkFlag:
            util.setPyDetailMsg(devObj, msg)
            return checkFlag, ""
        log.info(devObj, "start check lun copy...")
        flag, cli_ret, err_msg, return_hot_patch = check_lun_copy(devObj)
        if flag != True:
            log.error(devObj, "check lun copy failed, all_cli_ret:%s, err_msg:%s" % (cli_ret, err_msg))
            if return_hot_patch:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.patch", return_hot_patch)
            else:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.no.patch")
            return False, ""
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_LOG)
        util.refreshProcess(devObj, 100)        
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectAllLog(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        checkFlag, msg = __isPreCollectionLogCheck(devObj, config.CHECK_KVM_PATH)
        if not checkFlag:
            util.setPyDetailMsg(devObj, msg)
            return checkFlag, ""
        log.info(devObj, "start check lun copy...")
        flag, cli_ret, err_msg, return_hot_patch = check_lun_copy(devObj)
        if flag != True:
            log.error(devObj, "check lun copy failed, all_cli_ret:%s, err_msg:%s" % (cli_ret, err_msg))
            if return_hot_patch:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.patch", return_hot_patch)
            else:
                util.setPyDetailMsg(devObj, "exist.lun.copy.risk.no.patch")
            return False, ""
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_ALLLOG)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")

   
def collectEvent(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False,"")
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_EVENT)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
 
   
def collectRunningData(devObj):
    # 收集完config限制CLI命令收集时间，已和LMT/eservice对齐，
    # 时间2019.12.27
    collect_limit_time = 600
    try:
        CliCheckUtil.check_cli_connect(devObj)
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False,"")
        isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA)
        util.refresh_progress_by_add(devObj, 5)
        current_time = time.time()
        # 为eService收集cli命令的回显，存放到与config文件相同的路径下
        localDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_RUNNING_DATA)
        time_out = exportCmd.collectCliCmd4eService(devObj, localDir,
                                                    current_time,
                                                    collect_limit_time)
        if time_out:
            log.info(devObj, "collect cli cmd time out!")
            util.refreshProcess(devObj, 100)
            return (isSucc, "")

        util.refresh_progress_by_add(devObj, 5)
        #为eService收集rest命令的回显，存放到与config文件相同的路径下,非定时场景才收集
        if not devObj.get("isTiming"):
            localDir = util.getLocalInfoPathByType(devObj, config.EXPORT_TYPE_RUNNING_DATA)
            exportCmd.collectRestCmd4eService(devObj, localDir, current_time,
                                              collect_limit_time)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
 
    
def collectCliCmd(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(False, "")
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if False == isSysNormal:
            return(False, "")

        # 单独先收集故障诊断CLI命令回显
        collect_fault_diagnose_cmd(devObj)

        devType = devObj.get("devNode").getDeviceType()
        log.info(devObj, "change cmd list devType:%s" % devType)
        listCmd = config.LIST_CLI_CMD
        if devType == "Dorado NAS":
            listCmd = config.LIST_CLI_CMD_DORADONAS
        isSucc = exportCmd.exportCliCmd(devObj, listCmd, config.COLLECT_TYPE_CLI)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
   

def collect_fault_diagnose_cmd(dev_obj):
    """
    收集故障诊断命令信息
    :param dev_obj:
    :return:
    """
    try:
        # 收集类型
        collect_type = config.COLLECT_TYPE_CLI_FAULT_TREE
        exportCmd.writeCliCmdFile(dev_obj, '', collect_type)
        res_file_dir = util.getLocalInfoPathByType(dev_obj, collect_type)
        res_file_name = config.CLI_FILE_NAMES_FOR_TYPE.get(collect_type)
        # 结果文件路径
        res_file_path = os.path.join(res_file_dir, res_file_name)
        script_path = os.path.dirname(os.path.abspath(__file__))
        # 命令配置xml路径在package目录下
        xml_path = os.path.join(
            script_path,
            os.path.join("..", "..", "FaultTreeCmdList.xml")
        )
        log.info(
            dev_obj, "xml_path:{}, res_file_path:{}".format(
                xml_path, res_file_path
            )
        )
        multi_cmd_executer = MultiCmdExecuter(dev_obj, xml_path, res_file_path)
        multi_cmd_executer.execute()
    except Exception:
        log.error(dev_obj, "collect diagnose cmd except:" + str(
            traceback.format_exc()))
        ssh = dev_obj["SSH"]
        systemMode.reconnect_ssh(ssh, log)


def collectElableCmd(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(False, "")
        #检查系统是否正常
        isSysNormal = util.checkSystemNormal(devObj)
        if False == isSysNormal:
            return(False, "")
        isSucc = exportCmd.exportElableCmd(devObj, config.COLLECT_TYPE_ELABLE)
        util.refreshProcess(devObj, 100)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def collectDHA(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        
        #保留此检查过程，以便后续维护更改
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(False, "")
        
        dhaInfoCollector = DhaInfoCollector()
        
        # DHA信息收集结果仅用于机器学习，因此总是返回成功。
        # 若发生任何错误仅记录日志
        # 2020年12月12日删除DHA无论如何都会收集成功的判断
        status, msg = dhaInfoCollector.exportDhaInfo(devObj)
        msg = util.getMsg(devObj, msg)
        log.info(devObj, "error message from DHA collection:%s" % msg)
        util.refreshProcess(devObj, 100)
        return status, ""
    except :
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return False, ""


def collectSmart(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return (False,"")
        isSucc = exportInfo.exportSysInfo(devObj, config.COLLECT_TYPE_SMART)
        if not os.path.exists(os.path.join(devObj.get("collect_info_local_path"), "Running_Data")):
            devObj.setdefault("runningDataClean", True)
            log.info(devObj, "To collect Smart information, download the config file and delete it.")
            if not exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_RUNNING_DATA):
                log.error(devObj, "Failed to download the config file during Smart Information Collection.")
        #处理收集到得smart信息，将其转换为日志分析工具需要的格式
        if isSucc:
            (isSucc, errMsgKey) = dealSmartInfo(devObj)
            CliCheckUtil.check_cli_connect(devObj)
            if not isSucc:
                util.setPyDetailMsg(devObj, errMsgKey)
        util.refreshProcess(devObj, 100)        
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
    

def collectDiagnostic(devObj):
    try:
        CliCheckUtil.check_cli_connect(devObj)
        isSucc = diagnosticCollector.collect(devObj)
        return (isSucc, "")
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")


def __isPreCollectionLogCheck(devObj, kvmPath):
    '''
    @summary: 系统日志收集前检查队列是否存在海量KVM日志小文件
    @param devObj: 上下文对象
    @param kvmPath: 文件路径 
    @return: True 没有做相关检查或检查通过
             False 检查没有通过，文件数量大于阈值
    '''
    log.info(devObj, "pre-collection checking of system logs ...")  
    devTypeList = ["6800 V3", "18500 V3", "18800 V3", "18500F V3", "18800F V3"]
    devCurVer = contextUtil.getCurVersion(devObj)        
    devType = contextUtil.getDevType(devObj)
    flag, _, _, hot_patch_version = show_package(devObj)
    if flag != True:
        return False, "cannot.get.hotpatch.version.info"
    log.info(devObj, "get system hot_patch_version:" + str(hot_patch_version))
    if devCurVer == "V300R006C00SPC100" and hot_patch_version < "V300R006C00SPH111" and str(devType) not in devTypeList:
        return __preCollectionLogCheck(devObj, kvmPath)
    return True, None

     
def __preCollectionLogCheck(devObj, kvmPath):
    '''
    @summary: 工具通过控制器IP连接集群中所有控制器做检查,检查队列是否存在海量KVM日志小文件
    @param devObj: 上下文对象
    @param kvmPath: 文件路径 
    @return:flag: True 控制器通过相关检查；
                  False 存在控制器检查没有通过，文件数量大于阈值1000
            errMsg: 错误消息。
    '''
    logger = Log(devObj)
    devIp = contextUtil.getIp(devObj)
    commonUtils = CommonUtils(devObj, logger)
    flag, controllerIpList = commonUtils.getControllerIpList()
    if flag == False:
        return False, "failed.controller.ip.obtain"
    sshtoolUtils = SSHToolUtils(devObj, logger)
    for curIp in controllerIpList:
        if curIp == devIp:
            sftp = contextUtil.getSFTP(devObj)
            files = sftp.listFiles(kvmPath)
            fileNum = len(files)
            log.info(devObj, "current system files number:" + str(fileNum))
            if fileNum > FILE_NUM_THRESHOLD:
                return False, "failed.collect.information.check" 
            continue
        isSuccess, sshController = sshtoolUtils.newSshUsingCrntUsrCredential(curIp)
        if isSuccess:
            log.info(devObj,"successfully built ssh connection to %s" % str(curIp))
            isSftpSuccess, sftpController = sshtoolUtils.deriveSftpTransporter(sshController)
            if isSftpSuccess:
                log.info(devObj,"successfully built sftp connection to %s" % str(curIp))
                files = sftpController.listFiles(kvmPath)
                fileNum = len(files)
                log.info(devObj, "current controller system files number:" + str(fileNum))
                if fileNum > FILE_NUM_THRESHOLD:
                    sshtoolUtils.closeSshConnection(sshController)
                    sshtoolUtils.closeSftpConnection(sftpController)
                    return False, "failed.collect.information.check"
                sshtoolUtils.closeSshConnection(sshController)
                sshtoolUtils.closeSftpConnection(sftpController)
            else:
                log.info(devObj, "unsuccessfully built sftp connection to %s" % str(curIp))
                sshtoolUtils.closeSshConnection(sshController)
        else:
            log.info(devObj, "unsuccessfully built ssh connection to %s" % str(curIp))
            continue
    return True, None
