# -*- coding: UTF-8 -*-

from common.util import util
from common.util import log
from common.config import config
from common.exportInfo import exportInfo


##############
# 导出Pool关键日志入口
##############
def execute(devObj):
    try:
        util.refreshProcess(devObj, 1)
        util.initPyDetailMsg(devObj)
        is_upgrading = util.isSystemUpgrading(devObj)
        if is_upgrading:
            return (False, "")
        is_succ = exportInfo.export_meg_info(
                devObj, config.COLLECT_TYPE_POOL_CRITICAL_LOG)
        exportInfo.delete_file_without_node(
            devObj, config.COLLECT_TYPE_POOL_CRITICAL_LOG)
        is_exist_msg = util.isExistDetailMsg(devObj)
        if is_succ is False and is_exist_msg is False:
            util.setPyDetailMsg(devObj, "failed.collect.information")
        return (is_succ, "")
    except Exception as exception:

        log.error(
            devObj, "collect pool critical log "
                    "except: %s" % str(exception))
        util.setPyDetailMsg(devObj, "failed.collect.information")
        return (False, "")
