# -*- coding: UTF-8 -*-
'''
Created on 2017年10月17日

'''
from commonUtils import CommonUtils
from commonUtils import Log
from cliFactory import cli
from util import util
from util import device
from config import config
from disklogConf import disklogConf
import os
import threading
from threading import Thread, Lock
import com.huawei.ism.tool.infocollect.util.DataCollectConstants as dataConstant
from com.huawei.ism.tool.framework.pubservice.hardware import DiskLocation
from java.io import File
import java.lang.Exception as Jexception
from dataStructure.simpleQueue import SimpleQueue
import time
import ast
import traceback

sshLock = Lock()
recordLock = Lock()
fileLock = Lock()

class DiskInnerLogCollector(object):
    '''
    classdocs
    '''
    progressLock = Lock()
    finishDiskNum = 0.0
    totalDiskNum = 1

    def __init__(self, devObj, disklogConf, msgInfo):
        '''
        Constructor
        '''
        self.devObj = devObj
        self.disklogConf = disklogConf
        self.msgInfo = msgInfo
        self.logger = Log(self.devObj)
        self.util = CommonUtils(self.devObj, self.logger)


    def doCollect(self, interval):
        '''
        @summary: start to collect disk inner log
        '''

        selDiskList = self.devObj.get(dataConstant.SELECTTED_DISK_KEY_IN_PYENV)
        self.logger.info(
            "selDiskList collected:{disks}".format(disks=str(selDiskList)))
        self.msgInfo.writeMsgLine('selectedDisk=' + unicode(len(selDiskList)))
        if not self.checkUsrPrivilege():
            self.msgInfo.writeMsgLine('Running disk log failed to collect: user privilege insufficient ...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            return False, ""
        if not selDiskList:
            msg = "error.no.disk.selected"
            self.util.addPyDetailMsg(msg)
            self.msgInfo.writeMsgLine("failed to collect running disk log:" +
                          " no disk selected.",
                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)

            return False, ""

        selectedDiskIdList = self.getDiskIdList(selDiskList)
        self.logger.info("selected disk list of which running log to be collected:%s" % str(selectedDiskIdList))
        sortedIds = self.checkDiskEngine(selectedDiskIdList)
        DiskInnerLogCollector.totalDiskNum = len(selectedDiskIdList)

        for engineId in sortedIds:
            self.logger.info("engine %s attached diskIds to be processed: %s" % (engineId, str(sortedIds[engineId])))
        #thread soul:collection result recorder & command processor
        collectUtil = CollectionUtil(self.devObj, selectedDiskIdList)
        self.logger.info("now start to collect disk information with engine separately...")
        taskList = []
        self.logger.info("each time disklog collection is finished,")

        # 屏蔽部分版本部分硬盘MODEL号
        disk_mode_dict = self.get_disk_model(selDiskList)
        self.logger.info(
            "disk model dict:{disks}".format(disks=str(disk_mode_dict)))
        no_support_disk = self.check_not_support_disk_model(disk_mode_dict)
        self.logger.info(
            "no support:{disks}".format(disks=str(no_support_disk)))
        if no_support_disk:
            collectUtil.record_no_support_disk(no_support_disk)
            sortedIds = self.kickout_not_support_disk(sortedIds,
                                                      no_support_disk)
        for engine in sortedIds:
            try:
                thread = DiskCollectTask(
                    sortedIds[engine], self.devObj, collectUtil, interval, 10,
                    70.0)
                taskList.append(thread)
                thread.start()
                util.refreshProcess(self.devObj, 10)
            except BaseException as excp:

                self.logger.error("failed to fork engine %s's disk into thread: %s" % (engine, str(excp)))
                for diskId in sortedIds[engine]:
                    collectUtil.recordFailedDisk(diskId,
                                        "failed to fork new thread about engine which this disk locates in")
            time.sleep(1)
        for tasks in taskList:
            tasks.join()
        util.refreshProcess(self.devObj, 80)

        self.logger.info("now all disk log has finished collection... ")
        return self.calcualteStatus(collectUtil, selectedDiskIdList)

    def kickout_not_support_disk(self, disk_dict, no_support_disk):
        """
        剔出不支持的盘
        :param disk_dict:待收集的盘
        :param no_support_disk:不收集的盘
        :return:
        """
        res_dict = {}
        for engine_id in disk_dict:
            disk_list = disk_dict.get(engine_id)
            res_dict[engine_id] = [disk_id for disk_id in disk_list if
                                   disk_id not in no_support_disk]

        return res_dict

    def check_not_support_disk_model(self, disk_mode_dict):
        """屏蔽不支持的model号
        1. 先检查版本是否是风险版本
        2. 风险版本再检查是否风险MODEL号
        :param disk_mode_dict:待检查的硬盘model号
        :return:不支持收集的硬盘信息 硬盘ID：model号
        """
        not_support_disk = {}
        p_version = str(device.getDeviceVersion(self.devObj))
        is_version_risk = False
        for risk_version in disklogConf.CCTV_RISK_C_VERSION:
            if p_version.startswith(risk_version):
                is_version_risk = True
                break

        if not is_version_risk:
            is_version_risk = p_version in disklogConf.CCTV_RISK_ALL_VERSION

        if not is_version_risk:
            return not_support_disk

        for disk_id in disk_mode_dict:
            model_str = disk_mode_dict.get(disk_id)
            if model_str in disklogConf.CCTV_MODEL_NO_SUPPORT_DISK_MODEL:
                not_support_disk[disk_id] = model_str

        return not_support_disk


    def checkUsrPrivilege(self):
        '''
        @summary: check user privilege, only administrator and upper level are permitted
        '''
        isPrivilege = util.checkUserPrivilege(self.devObj)
        if not isPrivilege:
            return False
        else:
            return True

    def calcualteStatus(self, collectUtil, selectedDiskIdList):
        '''
        @summary: calcualte disk inner log collection status, record to return message if not successful
        '''
        self.logger.info("calculate disk collection process result...")
        networkEnvThresHold = self.devObj.get("networkEnvThresHold", "")
        if  str(networkEnvThresHold).isdigit() and networkEnvThresHold < 1 :
            self.util.addPyDetailMsg("failed.to.reconnect.after.several.times")
        collectStatus = collectUtil.getCollectStatus()
        failedItem = ""

        no_support_disk_dict = collectUtil.get_record_no_support_disk()
        if no_support_disk_dict:
            self.msgInfo.writeMsgLine(
                'not support={no_support_disk_num}'.format(
                    no_support_disk_num=len(no_support_disk_dict)))
            self.util.setCollectAllInfo(False)
            msg_list = []
            for disk_id in no_support_disk_dict:
                model = no_support_disk_dict.get(disk_id, "")
                msg_list.append(
                    "{disk_id}(Model:{model})".format(disk_id=disk_id,
                                                      model=model))
            self.util.addPyDetailMsg("collect.disk.log.not.support",
                                     "\n".join(msg_list))
            # All normal disk log collection is not support.
            if len(no_support_disk_dict) == len(selectedDiskIdList):
                return False, ''

        if len(collectStatus) >= 1:
            self.msgInfo.writeMsgLine('failed=' + str(len(collectStatus)))
            self.util.setCollectAllInfo(False)
            for item in collectStatus:
                self.msgInfo.writeMsgLine("engine " + item[3] + "'s disk " + item + ": " + collectStatus[item] + ".",
                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                failedItem += item + ", "
            self.util.addPyDetailMsg("collect.disk.log.failed", failedItem[:-2])

        stoppedDiskLogIdList = collectUtil.getStoppedDiskId()
        if stoppedDiskLogIdList:
            self.util.setCollectAllInfo(False)
            self.util.addPyDetailMsg("collect.disk.log.stopped", ','.join(stoppedDiskLogIdList))
            self.msgInfo.writeMsgLine('Stopped=' + str(len(stoppedDiskLogIdList)))
            if len(stoppedDiskLogIdList) == len(selectedDiskIdList):#All normal disk log collection is stopped.
                return False, ''

        self.msgInfo.writeMsgLine(
            "success={success_num}".format(success_num=str(
                len(selectedDiskIdList) - len(collectStatus) - len(
                    stoppedDiskLogIdList) - len(no_support_disk_dict))))
        if len(collectStatus) == len(selectedDiskIdList):
            return False, ""
        return True, ""

    def getDiskIdList(self, selDiskList):
        '''
        @summary: convert Disk information Pojo(java) into tuple obj
        @return: selectedDiskIdList: list
        '''
        selectedDiskIdList = []
        for diskInfoDto in selDiskList:
            diskId = diskInfoDto.getDiskLocation().toString()
            selectedDiskIdList.append(str(diskId))
        self.logger.info("now selected disk count:%s" % str(len(selectedDiskIdList)))
        return selectedDiskIdList

    def get_disk_model(self, sel_disk_list):
        """获取disk model
        :param sel_disk_list: 选中的硬盘
        :return: 硬盘id:model号
        """
        disk_model_dict = {}
        for diskInfoDto in sel_disk_list:
            diskId = diskInfoDto.getDiskLocation().toString()
            disk_model = str(diskInfoDto.getModelNum())
            disk_model_dict[str(diskId)] = disk_model
        return disk_model_dict

    def checkDiskEngine(self, selectedDiskIdList):
        sortedIds = {}
        if util.is_X10(self.devObj):
            result, sortedIdsResult = self.checkEngine(selectedDiskIdList)
            if result:
                sortedIds = sortedIdsResult
            else:
                self.logger.info("RestConnection quer engine failure.")
                sortedIds["0"] = []
                for diskId in selectedDiskIdList:
                    sortedIds["0"].append(diskId)
        else:
            # diskID  DAE000.01
            #           |- engine number where disk locates
            for diskId in selectedDiskIdList:
                if not sortedIds.get(diskId[3], ""):
                    sortedIds[diskId[3]] = []
                sortedIds[diskId[3]].append(diskId)
        return sortedIds

    def checkEngine(self, selectedDiskIdList):
        sortedIds = {}
        # 根据enclosureID，使用Rest命令查询框所属引擎
        (isSuccess, engineInfoList) = self.querEngineByRest()
        if isSuccess:
            # 从硬盘ID中截取框Name
            for diskId in selectedDiskIdList:
                spiltTip = "."
                if diskId.count(spiltTip) != 0:
                    enclosureName = diskId.split(spiltTip)[0]
                    if engineInfoList.get(enclosureName, ""):
                        engineID = engineInfoList[enclosureName]
                        if not sortedIds.get(engineID, ""):
                            sortedIds[engineID] = []
                        sortedIds[engineID].append(diskId)
                    else:
                        self.logger.info("The engineInfoList not has enclosureID, enclosureID is " + enclosureName)
                        return False, sortedIds
                else:
                    self.logger.info("The disk ID format is error, diskID is " + diskId)
                    return False, sortedIds
        else:
            return False, sortedIds
        self.logger.info("RestConnection quer engine is Success.")
        return True, sortedIds

    def querEngineByRest(self):
        restConnectionManager = self.devObj.get("restMamager")
        devNode = self.devObj.get("devNode")
        engineInfoDict = {}
        try:

            restConnection = restConnectionManager.getRestConnection(devNode)
            URL = r"https://%s:%s/deviceManager/rest/%s/enclosure" % \
                  (self.devObj.get("devIp"), str(8088), str(devNode.getDeviceSerialNumber()))
            responseInfo = restConnection.execGet(URL)
            responseDict = ast.literal_eval(responseInfo.getContent())
            errInfo = responseDict.get("error", "")
            errCode = "0"
            if not errInfo:
                code = ast.literal_eval(errInfo).get("code", "")
                if not code:
                    errCode = str(code)
            if errCode == "0":
                dataList = responseDict.get("data", [])
                if not dataList:
                    return False, engineInfoDict
                for data in dataList:
                    engineInfoMap = ast.literal_eval(str(data))
                    engineId = engineInfoMap.get("visibleAreaId", "")
                    enclosureName = engineInfoMap.get("NAME", "")
                    if engineId and enclosureName:
                        if not engineInfoDict.get(enclosureName, ""):
                            engineInfoDict[enclosureName] = engineId
                    else:
                         return False, engineInfoDict
            else:
                return False, engineInfoDict
        except:
            self.logger.error("Querying disk corresponding engine is error: " + str(traceback.format_exc()))
            return False, engineInfoDict
        finally:
            restConnectionManager.releaseConn(devNode)
        return True, engineInfoDict

class CollectionUtil(object):
    '''
    classDoc
    all
    '''
    def __init__(self, devObj, diskIdsAll):
        '''
        init
        '''
        self.devObj = devObj
        self.diskIdsAll = diskIdsAll
        self.logger = Log(self.devObj)
        self.clctStatus = {}
        self.stoppedDiskIdList = []
        self.no_support_disk = {}

    def record_no_support_disk(self, disks):
        with recordLock:
            self.no_support_disk.update(disks)

    def get_record_no_support_disk(self):
        """返回不支持的列表
        :return:不支持的列表
        """
        return self.no_support_disk

    def getCollectStatus(self):
        '''
        @summary: get collection status
        '''
        return self.clctStatus

    def executeCmd(self, command, timeOut = 3 * 60):
        '''
        @execute command, with semaphore lock, which is thread safe
        '''
        sshLock.acquire()
        networkEnvThresHold = self.devObj.get("networkEnvThresHold", "")
        if  str(networkEnvThresHold).isdigit() and networkEnvThresHold < 1 :
            sshLock.release()
            return False, ""
        isSucc, cliEcho = cli.executeCmdWithTimoutAndRetry(self.devObj, command, timeOut)
        confirmCnt = 0
        while '(y/n)' in cliEcho.lower() and confirmCnt < 5:
            isConfirmSucc, cliEcho = cli.executeCmd(self.devObj, 'y')
            if not isConfirmSucc:
                self.logger.warn('Confirm to collect disk log failed.')
        sshLock.release()
        return isSucc, cliEcho

    def recordFailedDisk(self, diskId, status):
        '''
        @summary: record disk collection status
        @note: thread safe
        '''
        recordLock.acquire()
        if diskId in self.diskIdsAll:
            self.clctStatus[diskId] = status
        recordLock.release()

    def recordStoppedDiskId(self, diskId):
        """Record disk id of which disk log collection is stopped

        Thread safe
        @:param diskId: disk id.
        """
        recordLock.acquire()
        self.stoppedDiskIdList.append(diskId)
        recordLock.release()


    def getStoppedDiskId(self):
        """Get all stopped disk ID list.

        :return:
        """
        return self.stoppedDiskIdList


    def copyLog2LocalAndClean(self, logName, controllerId, diskId, localDir):
        '''
        @summary: thread safe function, copy remote file to local directory and inform device to clean
        '''
        fileLock.acquire()
        result = False
        needRetry = False
        try:
            self.logger.info("[%s] now start to copy and download log about %s to local." % \
                    (str(threading.currentThread().name), str(diskId)))
            cmd = "show file notification file_type=running_disklog interlog_name=" + logName.strip() + \
                    " controller_id=" + controllerId.strip()
            filePath = ""
            fileName = ""
            isOK, cliMsg = self.executeCmd(cmd)
            if not isOK:
                needRetry = True
                raise
            if "error:" in cliMsg.lower():
                raise
            for line in cliMsg.splitlines():
                if "file path" in line.lower() and ":" in line and len(line.split(":")) >= 2:
                    filePath = line.split(":")[1].strip()
            if not filePath:
                raise
            fileName = filePath.split("/")[-1]
            self.logger.info("[%s]download %s's remote log to local...%s" % \
                    (str(threading.currentThread().name), str(diskId), filePath))
            self.devObj["SFTP"].getFile(filePath, File(localDir), None)
            self.logger.info("[%s]finished downloading file..." % \
                    str(threading.currentThread().name))
            self.logger.info("[%s]now start to clean tmp files about disk %s..." % \
                    (str(threading.currentThread().name), str(diskId)))
            os.rename(os.path.join(localDir, fileName), os.path.join(localDir, diskId + ".tgz"))
            cmd = "delete file filetype=running_disklog interlog_name=" + logName.strip() + \
                            " controller_id=" + controllerId.strip()
            self.executeCmd(cmd)
            result = True
        except BaseException, baseExp:
            self.logger.error("%s exception occurred!! %s" % (str(threading.currentThread().name), str(baseExp)))
            result = False
        except Jexception, jex:
            self.logger.error("%s java exception occurred!! %s" % (str(threading.currentThread().name), str(jex)))
            result = False
        fileLock.release()
        return result, needRetry

class DiskCollectTask(Thread):
    '''
    classDoc:
    @summary: disk log collection task
    @todo: collect disk log in multi-threading mode
    '''

    running_log_time_out_secs_per_disk = 610

    def __init__(self, diskIds, devObj, collectUtil, interval, basicProgress,
                 progressLength):
        '''
        Constructor
        '''
        Thread.__init__(self)
        self.name = "Thread-engine-" + diskIds[0][3]
        self.devObj = devObj
        self.idQueue = SimpleQueue(diskIds)
        self.logger = Log(self.devObj)
        self.collectUtil = collectUtil
        self.retryList = []
        self.logger.info("Thread-engine-" + diskIds[0][3] + "initialized...")
        self.interval = interval
        self.basicProgress = basicProgress
        self.progressLength = progressLength

    def run(self):
        '''
        super_function override
        '''
        self.logger.info(" %s now start to process..." % str(threading.currentThread().name))
        isStoped = False
        while not self.idQueue.isEmpty():
            diskId = self.idQueue.poll()
            if None == diskId :
                continue

            isStoped = self.devObj.get('stop').isStopped()
            self.logger.warn('disk log collect stop flag: %s.' %isStoped)
            if isStoped:
                self.collectUtil.recordStoppedDiskId(diskId)
                self.logger.warn('disk log collect is stopped.')
                break

            fileName, ctrlrId = self.inform2ClctDiskLog(diskId)
            if not fileName or not ctrlrId:
                continue
            self.logger.info("[%s] %s is on controller %s and destination file name is %s" % \
                                (str(threading.currentThread().name), str(diskId), ctrlrId, fileName))
            isOk = self.getClctnStatus(diskId, ctrlrId)
            if not isOk:
                if diskId not in self.retryList:
                    self.retryList.append(diskId)
                    self.idQueue.add(diskId)
                    continue
                else:
                    self.collectUtil.recordFailedDisk(diskId, "get disk package result but found failure")
                    continue
            isDownLoadOk, needRetry = self.copyRemoteFileAndDownload(fileName, ctrlrId, diskId)
            if not isDownLoadOk:
                self.logger.info("[%s] %s 's log failed to copy to local dir" % \
                                 (str(threading.currentThread().name), str(diskId)))
                if needRetry and  diskId not in self.retryList:
                    self.logger.info("[%s] %s will retry again..." % \
                                 (str(threading.currentThread().name), str(diskId)))
                    self.retryList.append(diskId)
                    self.idQueue.add(diskId)
                else:
                    self.collectUtil.recordFailedDisk(diskId, "failed to show file notification or download file")
            self.calcProgress()
            self.logger.info("now start to sleep %s seconds after one disk collection finished." % str(self.interval))
            time.sleep(self.interval)

        if isStoped:
            for diskId in self.idQueue.objQueue:
                self.collectUtil.recordStoppedDiskId(diskId)

    def calcProgress(self):
        """
        基于基础进度以及当前完成百分比，计算需要刷新的进度
        :return:
        """
        with DiskInnerLogCollector.progressLock:
            DiskInnerLogCollector.finishDiskNum += 1
            progress = self.basicProgress + \
                DiskInnerLogCollector.finishDiskNum / \
                DiskInnerLogCollector.totalDiskNum * \
                self.progressLength
            util.refreshProcess(self.devObj, progress)
            self.logger.info("Current finishDiskNum is %s, fresh progress" %
                             str(progress))

    def inform2ClctDiskLog(self, diskId):
        '''
        @summary: execute show file export_path command to inform BDM to start to collect
        '''
        cmd = "show file export_path file_type=running_disklog disk_id=" + diskId
        isSucc, cliRet = self.collectUtil.executeCmd(
            cmd, timeOut=self.running_log_time_out_secs_per_disk)
        fileName = ""
        controllerId = ""
        if not isSucc:
            self.logger.info("[%s] %s execute show file export path failed..." % \
                                (str(threading.currentThread().name), str(diskId)))
            if diskId not in self.retryList:
                self.retryList.append(diskId)
                self.idQueue.add(diskId)
            else:
                self.collectUtil.recordFailedDisk(diskId, "failed to execute show file export path command")
            return "", ""

        if "file name" in cliRet.lower() and "controller id" in cliRet.lower():
            for line in cliRet.splitlines():
                if "file name" in line.lower() and ":" in line and len(line.split(":")) >= 2:
                    fileName = line.split(":")[1].strip()
                if "controller id" in line.lower() and ":" in line and len(line.split(":")) >= 2:
                    controllerId = line.split(":")[1].strip()
            if not fileName or not controllerId:
                self.collectUtil.recordFailedDisk(diskId,
                                "failed to parse file export path or which controller this disk locates to")
            return fileName, controllerId
        if "error:" in cliRet.lower():
            if "system is exporting file" in cliRet.lower():
                self.logger.info("[%s] %s execute 1st operation failed, system is exporting, try later. " % \
                                 (str(threading.currentThread().name), str(diskId)))
                if diskId not in self.retryList:
                    self.retryList.append(diskId)
                    self.idQueue.add(diskId)
                else:
                    self.collectUtil.recordFailedDisk(diskId,
                                    "failed to execute show file export path command, system is exporting file")
                return "", ""

        self.logger.info("[%s] %s execute 1st operation but failed and no need to retry... " % \
                         (str(threading.currentThread().name), str(diskId)))
        self.collectUtil.recordFailedDisk(diskId, "failed to get file export path")
        return "", ""

    def getClctnStatus(self, diskId, ctrlrId):
        '''
        @summary: get disk collection BDM layer  status
        '''
        self.logger.info("[%s] %s now fetching BDM collection status" % (threading.currentThread().name, str(diskId)))
        time.sleep(20)
        totalWaits = 5 * 60 - 20
        cmd = "show file package_result file_type=running_disklog disk_id=" + diskId + " controller_id=" + ctrlrId
        resultStatus = False
        while totalWaits > 0:
            result = self.collectUtil.executeCmd(cmd)
            if "successful" in result[1].lower():
                resultStatus = True
                break
            if "fail" in result[1].lower():
                resultStatus = False
                break
            totalWaits -= 10
            time.sleep(10)
        return resultStatus

    def copyRemoteFileAndDownload(self, logName, controllerId, diskId):
        '''
        @summary:  notify ALARM to copy disk inner log to current ctrlr and download to local file
        '''
        localDir = os.path.join(self.devObj[config.COLLECT_INFO_LOCAL_PATH],
                config.COLLECT_INFO_DIR_NAME[config.COLLECT_TYPE_DISKLOG],
                disklogConf.RUNNING_DISKLOG_DIR_NAME)
        if not os.path.exists(localDir):
            os.makedirs(localDir)
        returnStatus, needRetry = self.collectUtil.copyLog2LocalAndClean(logName, controllerId, diskId, localDir)
        return returnStatus, needRetry
