# -*- coding: UTF-8 -*-
import os
import traceback
import codecs
import time
from common.util import *
from common.config import *
from com.huawei.oss.cn.common.anonymize import FileAnonymizeUtil
from com.huawei.oss.cn.common.anonymize import AnonymizeType
from cliFactory import cli
from frameone.util import contextUtil
from frameone.rest import restUtil

list_cli_cmd_eService = [
                "show share nfs",
                "show share cifs share_id=[show share cifs?Share ID]",
                "show share_permission ftp",
                "show share_permission nfs share_id=(show share nfs?Share ID)",
                "show share_permission cifs share_id=(show share cifs?Share ID)",
                "show snapshot general snapshot_id=[show snapshot general?ID]",
                "show fs_snapshot general file_system_id=[show file_system general?ID]",
                ]

list_rest_cmd_eService = [
                "luncapacities",
                ]

class exportCmd():
    
    @staticmethod
    def getExecuteCliCmd(strCmd, type):
        '''
        #CLI回显收集，判断当前收集的命令，是否收集详细信息，及详细信息参数的来源
        '''
        result = strCmd
        #判断是否收集详细信息，不收集则直接返回当前命令
        flag = exportCmd.isMultiCmd(strCmd, type)
        if not flag:
            return result
        
        #获取查询详细信息CLI的构造列表
        list_cmd = exportCmd.getMultiCmdList(type)
        tempList = list_cmd[strCmd]
        
        
        if len(tempList) <= 2:
            return result
        
        #列表大于2，则需要根据配置的CLI命令，获取参数值
        tempCmd = tempList[2]
        if tempCmd:
            result = tempCmd
    
        return result
       
    @staticmethod
    def writeCliCmdFile(devObj, strCmd, type):
        '''
        @summary: CLI回显信息收集，将回显信息写入文件中
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        strCmd=回显信息
        @return:
        '''
        #需要写入的目录
        path = util.getLocalInfoPathByType(devObj, type)
        strCmd = FileAnonymizeUtil.anonymizeMultiLine(strCmd, AnonymizeType.LOG)
        result = exportCmd.writeCliCmdFileByPath(devObj, path, strCmd, type)
        return result
    
    @staticmethod
    def writeCliCmdFileByPath(devObj, path, strCmd, type):
        '''
        @summary: 将回显信息写入文件中
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        strCmd=回显信息
                        path=写入的目录
        @return:
        '''
        try:
            f = None
            if True != os.path.exists(path):
                os.mkdir(path)
                
            fileName = config.CLI_FILE_NAMES_FOR_TYPE[type]
            
            f = codecs.open(path + fileName, "a", "utf-8")
            f.write(strCmd)
            return True
        except:
            log.error(devObj, "write except:{}, except trace back:{}".format(strCmd, traceback.format_exc()))
            return False
        finally:
            if None != f:
                f.close()
    
    @staticmethod
    def getMultiCmdList(type):
        '''
                    根据收集的类型，获取需要收集详细信息的命令列表
        '''
        list_cmd = None
        
        if type in config.MULTI_CLI_COLLECT.keys():
            list_cmd = config.MULTI_CLI_COLLECT[type]
            
        return list_cmd
    
    
    @staticmethod
    def isMultiCmd(strCmd, type):
        '''
                    判断是否需要获取CLI命令的详细信息
        '''
        flag = False
        list_cmd = exportCmd.getMultiCmdList(type)
        
        if None == list_cmd:
            return flag
            
        if strCmd in list_cmd.keys():
            flag = True
        
        return flag
        
    @staticmethod
    def getMultiCmdIds(devObj, cliRet, type, strCmd):
        '''
                    获取CLI回显中ID列的信息，返回ID列表
        '''
        list_multi_cmd = []
        
        list_cliRet =cli.getCliTable2DictList(cliRet)
        list_multi = exportCmd.getMultiCmdList(type)
        
        fieldName = list_multi[strCmd][0]
        
        for field in list_cliRet:
            if fieldName in field.keys():
                id = field[fieldName]
                list_multi_cmd.append(id)
            
        return list_multi_cmd
    
    
    @staticmethod
    def getCliResultInfo(devObj, strCmd, type):
        '''
                    获取CLI回显信息，若需要获取详细信息，则获取详细信息
        '''
        result = ""
        list_multi_cmd_ids = []
        if strCmd == None:
            log.info(devObj, "get cmd is none")
            return result
        
        execCmd = exportCmd.getExecuteCliCmd(strCmd, type)
        
        if execCmd in config.cmdLimitTimeDict:
            limitTime = config.cmdLimitTimeDict.get(execCmd, 120)
            (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, execCmd, limitTime)
        else:
            (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, execCmd)
            
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return ""
        
        cmdIsExist = cli.isExistCmdForRec(rec)
        if not cmdIsExist:
            return ""
        
        if False == exportCmd.isMultiCmd(strCmd, type):
            result = rec
        else:
            list_multi_cmd_ids = exportCmd.getMultiCmdIds(devObj, rec, type, strCmd)
            list_multi_cmd = exportCmd.getMultiCmdList(type)
            
            for field_cmd in list_multi_cmd_ids:
                cmd = strCmd + " " + list_multi_cmd[strCmd][1] + field_cmd
                (isSuccess, recs) = cli.executeCmdNoLogTimeout(devObj, cmd)
                if not isSuccess:
                    util.setPyDetailMsg(devObj, "dev.conn.failure")
                    return ""
                result = result + recs
            
        return result
    
    @staticmethod
    def exportCliCmd(devObj, cliList, type):
        '''
        @summary: 收集CLI回显信息的入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        (isSuccess, userName) = util.getUsername(devObj)
        result = userName + ":/>"
        flag = exportCmd.writeCliCmdFile(devObj, result, type)
        if flag == False:
            log.info(devObj, "write cli into to file fail")
            return flag
        
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        
        #获取所有Cli模式下命令回文
        currentProcess = 2
        percentNumber = 70.0 / len(cliList)
        for field in cliList:
            currentProcess = util.refreshProcessByStep(devObj, currentProcess, percentNumber)
            result = exportCmd.getCliResultInfo(devObj, field, type)
            if result == "":
                flag = False
                continue
            if cli.CLI_RET_END_FLAG in result:
                isInRightMode = True
                
            exportCmd.writeCliCmdFile(devObj, result, type)
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
            return False
        
        #进入developer模式
        changeFlag = systemMode.enterDeveloperMode(devObj)
        #切换到developer模式失败
        if False == changeFlag:
            #设置部分收集成功
            util.setCollectAllInfo(devObj, False)
            #设置界面显示信息
            key = "cli.collect.debug.login.fail"
            util.setPyDetailMsg(devObj, key)
            if True == systemMode.isInDeveloperMode(devObj):
                systemMode.developerMode2CliMode(devObj)
            
            return False
        currentProcess = 73
        percentNumber = 20.0 / len(config.LIST_DEVELOPER_CMD)
        #获取所有developer模式下命令回文
        for field in config.LIST_DEVELOPER_CMD:
            
            result = exportCmd.getCliResultInfo(devObj, field, type)
            
            if True == systemMode.isInDeveloperMode(devObj):
                isInRightMode = True
                
            exportCmd.writeCliCmdFile(devObj, result, type)
            currentProcess = util.refreshProcessByStep(devObj, currentProcess, percentNumber)
        
        #收集完成，需要退回到Cli模式
        systemMode.developerMode2CliMode(devObj)
        
        #关闭开关
        switch = devObj.get("switch")
        if switch is False:
            systemMode.closeDeveloperSwitch(devObj)
            
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
            
        return isInRightMode
    
    @staticmethod
    def isElableEnd(line):
        '''
                    判断电子标签是否结束，根据结束标记和-----判断
        '''
        reg = "^\s*-+\s*$"
        reg_headline = re.compile(reg)
        match_headline = reg_headline.search(line)
        if (cli.CLI_RET_END_FLAG in line) or (None != match_headline):
            return True
        else:
            return False
        
    @staticmethod
    def getElableKeyAndValue(strInfo):
        '''
                        获取电子标签的Key和Value值,如：
        '''
        list = strInfo.splitlines()
        flag_start = False
        list_elable_key = []
        list_elable_value = []
        keyValue = {}
        for field in list:
            if "Electronic Label" in field:
                flag_start = True
            
            if True == exportCmd.isElableEnd(field):
                
                flag_start = False
                if 0 < len(keyValue):
                    list_elable_value.append(keyValue)
                keyValue = {}
            
            if True == flag_start and ("=" in field):
                
                list_temp = field.split("=")
                key = list_temp[0].strip()
                value = list_temp[1].strip()
                
                if key not in list_elable_key:
                    list_elable_key.append(key)
                
                keyValue[key] = value
                    
        return (list_elable_key, list_elable_value)
        
    @staticmethod
    def getFieldType(atrribute_name):
        '''
                    获取标签的类型，当前默认为string，此方法方便后续扩展
        '''
        type = "string"
        return type
    
    
    @staticmethod
    def parseElableInfo(strInfo, strProperty):
        '''
                        根据当前回显返回，对应格式的XML标签    如：
        '''
        result = """\n        <TABLE attribute="%s">
            <METADATA>
                <FIELDS>%s
                </FIELDS>
            </METADATA>
            <ROWDATA>%s
            </ROWDATA>
        </TABLE>"""
        
        keyValue = exportCmd.getElableKeyAndValue(strInfo)
        
        list_elable_key = keyValue[0]
        list_elable_value = keyValue[1]
        
        if len(list_elable_key) == 0:
            result = result % (strProperty, "", "")
            return result
        
        value0 = list_elable_value[0]
        tempFields = ""
        for field in list_elable_key:
            tempField = '\n' + 20*" " + '<FIELD attribute="%s" fieldtype="%s" width="%s" required="true"/>'
            field_type = exportCmd.getFieldType(field)
            valueLen = 0
            if field in value0.keys():
                valueLen = len(value0[field])
            
            tempField = tempField % (field, field_type, valueLen)
            tempFields += tempField
        
        tempRows = ""
        for elable_value in list_elable_value:
            
            tempRow = '\n' + 16*" " + '<ROW%s/>'
            temps = ""
            for elable_key in list_elable_key:
                temp = ' %s="%s"'
                va = ""
                if elable_key in elable_value.keys():
                    va = elable_value[elable_key]
                temp = temp % (elable_key, va)
                temps += temp
                
            tempRow = tempRow % temps
            tempRows += tempRow
            
        result = result % (strProperty, tempFields, tempRows)
        return result
            
    @staticmethod
    def exportElableCmd(devObj, type):
        '''
        @summary: 收集电子标签的入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        result = '''<DATAPACKET Version="2.0">
    <FILELABEL>
        <VERDESC Ver="1.4" />
    </FILELABEL>
    <TABLES>%s
    </TABLES>
</DATAPACKET>'''
        flag = True
        exportCmd.writeCliCmdFile(devObj, config.ELABLE_LIST_HEADER, type)

        #添加cli回文是否正常判断标识位
        isCliRetNormal = False
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        tempResults = ""
        currentProcess = 5
        percentNumber = 90.0 / len(config.LIST_ELABLE_CMD)
        for field in config.LIST_ELABLE_CMD:
            tempResult = exportCmd.getCliResultInfo(devObj, field, type)
            if tempResult == "":
                continue
            
            if ("Error:" not in tempResult) or ("license" in tempResult):
                isCliRetNormal = True
                
            if cli.CLI_RET_END_FLAG in tempResult:
                isInRightMode = True
                
            if field in config.LIST_ELABLE_PROPERTY.keys():
                tempResults += exportCmd.parseElableInfo(tempResult, config.LIST_ELABLE_PROPERTY[field])
            else:
                tempResults += exportCmd.parseElableInfo(tempResult, "default")
            currentProcess = util.refreshProcessByStep(devObj, currentProcess, percentNumber)
        result = result % tempResults
        flag = exportCmd.writeCliCmdFile(devObj, result, type)
        
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
        
        #三种情况同时满足，则收集电子标签成功
        flag = isCliRetNormal and flag and isInRightMode
        
        return flag
    
    @staticmethod
    def logCollectAdditionalInfoFailed(logger):
        logger.error("Collect Additional-Info failed.")
    
    @staticmethod
    def logCollectAdditionalInfoPartFailed(logger):
        logger.error("Collect Additional-Info part failed.")
    
    @staticmethod   
    def logCollectAdditionalInfoSuccess(logger):
        logger.info("Collect Additional-Info success.")
    
    @staticmethod   
    def joinLines(originLines, postLines):
        """
        @summary: 将postLines追加originLines后
        """
        if not (originLines or postLines):
            return ""
        
        if not originLines:
            return postLines
        
        if not postLines:
            return originLines
        
        return "\n".join([originLines, postLines])
    
    @staticmethod
    def collectCliCmd4eService(devObj, fileBaseDir, current_time,
                               collect_limit_time):
        """
        219.12.27 更新限制回文收集10分钟。
        # 函数名称: 为eService收集cli回显。
        # 功能说明: 获取CLI命令信息
        # 其 他   :  无
        """
        logger = devObj.get("logger")
        time_out = False
        try:
            cli_ret_list = []
            ssh = devObj.get("SSH")
            for cmd in list_cli_cmd_eService:
                # 如果当前时间大于等于限制时间则返回。
                if time.time() - current_time >= collect_limit_time:
                    time_out = True
                    break

                one_cli_ret_list = exportCmd.getCliRet(ssh, cmd,
                                                       current_time,
                                                       collect_limit_time)
                if not one_cli_ret_list:
                    exportCmd.logCollectAdditionalInfoPartFailed(logger)
                    logger.error("Command execution result is empty:%s" % cmd)
                    continue

                # 过滤不支持的命令
                cli_ret_list.extend([i for i in one_cli_ret_list
                                     if util.cli_res_is_support(i)])

            if not cli_ret_list:
                exportCmd.logCollectAdditionalInfoFailed(logger)
                return time_out
            
            cliCmdFile = os.path.join(fileBaseDir, "Additional-Info.txt")
            if exportCmd.writeFile(cliCmdFile, "\n".join(cli_ret_list),
                                   logger):
                exportCmd.logCollectAdditionalInfoSuccess(logger)
            else:
                exportCmd.logCollectAdditionalInfoFailed(logger)

            return time_out
        except:
            exportCmd.logCollectAdditionalInfoFailed(logger)
            logger.error(str(traceback.format_exc()))
            return time_out


    @staticmethod
    def collectRestCmd4eService(devObj, fileBaseDir, current_time,
                                collect_limit_time):
        """
        219.12.27 更新限制回文收集10分钟。
        # 函数名称: 为eService收集rest回显。
        # 功能说明: 获取rest命令信息
        # 其 他   :  无
        """
        logger = devObj.get("logger")
        time_out = False
        try:
            logger.info("Start collect Rest-Command-Info")
            restRet = ""
            rest = contextUtil.getRest(devObj)
            logger.info("Get rest is [%s]" % rest)
            for uri in list_rest_cmd_eService:
                # 如果当前时间大于等于限制时间则返回。
                if time.time() - current_time >= collect_limit_time:
                    time_out = True
                    break

                restRet = exportCmd.joinLines(restRet, "Command : %s" % uri)
                oneRestRetDictList = restUtil.CommonRestService.get4Big(rest, uri)
                logger.info("Get command URI result [%s]" % oneRestRetDictList)
                if not oneRestRetDictList:
                    exportCmd.logCollectAdditionalInfoPartFailed(logger)
                    logger.error("Command execution result is empty:%s" % uri)
                    continue
                for oneRestRetDict in oneRestRetDictList:
                    restRet = exportCmd.joinLines(restRet, str(oneRestRetDict))

            logger.info("Release the rest connection. {}".format(rest))
            contextUtil.releaseRest(devObj)

            if not restRet:
                exportCmd.logCollectAdditionalInfoFailed(logger)
                return time_out
            
            cliCmdFile = os.path.join(fileBaseDir, "Rest-Command-Info.txt")
            if exportCmd.writeFile(cliCmdFile, restRet, logger):
                exportCmd.logCollectAdditionalInfoSuccess(logger)
            else:
                exportCmd.logCollectAdditionalInfoFailed(logger)
            return time_out
        except:
            exportCmd.logCollectAdditionalInfoFailed(logger)
            logger.error(str(traceback.format_exc()))
            return time_out
        finally:
            contextUtil.releaseRest(devObj)


    @staticmethod    
    def writeFile(cliInfoFileName, cliRet, logger):
        """
        # 函数名称: 将cli回显写入文件。
        # 功能说明: 获取CLI命令信息
        # 其 他   :  无
        """
        cliInfoFile = None
        try:
            cliInfoFile = codecs.open(cliInfoFileName, "a", "utf-8")
            cliInfoFile.write(cliRet)
            cliInfoFile.flush()
            return True
        except:
            logger.error("Failed to write file:" + str(traceback.format_exc()))
            return False
        finally:
            if cliInfoFile != None:
                cliInfoFile.close()


    @staticmethod    
    def getCliRet(ssh, cmd, current_time, collect_limit_time):
        """
        # 函数名称: 获取cli回显。
        # 功能说明: 获取CLI命令信息
        # 其 他   :  无
        """
        cli_ret_list = []
        if "=[" in cmd:
            index0 = cmd.find("[")
            index1 = cmd.find("?")
            dependCmd = cmd[index0+1:index1]
            dependCmdCliRet = ssh.execCmd(dependCmd)
            cli_ret_list.append(dependCmdCliRet)
            baseCmd = cmd[:index0]
            index2 = cmd.find("]")
            param = cmd[index1+1:index2]
            dependInfoDictList = cli.getHorizontalNostandardCliRet(dependCmdCliRet)
            for dependInfoDic in dependInfoDictList:
                if time.time() - current_time >= collect_limit_time:
                    return cli_ret_list
                paramValue = dependInfoDic.get(param, "")
                detailsCmd = baseCmd + paramValue
                detailsCmdCliRet = ssh.execCmdNoLog(detailsCmd)
                cli_ret_list.append(detailsCmdCliRet)

        elif "=(" in cmd:
            index0 = cmd.find("(")
            index1 = cmd.find("?")
            dependCmd = cmd[index0+1:index1]
            dependCmdCliRet = ssh.execCmd(dependCmd)
            cli_ret_list.append(dependCmdCliRet)
            baseCmd = cmd[:index0]
            index2 = cmd.find(")")
            param = cmd[index1+1:index2]
            dependInfoDictList = cli.getHorizontalNostandardCliRet(dependCmdCliRet)
            for dependInfoDic in dependInfoDictList:
                if time.time() - current_time >= collect_limit_time:
                    return cli_ret_list
                paramValue = dependInfoDic.get(param, "")
                detailsCmd = baseCmd + paramValue
                detailsCmdCliRet = ssh.execCmdNoLog(detailsCmd)
                cli_ret_list.append(detailsCmdCliRet)
        else:
            cliRet = ssh.execCmd(cmd)
            cli_ret_list.append(cliRet)
        return cli_ret_list
