# -*- coding: UTF-8 -*-
'''
Created on 2017 - 10 - 16

'''
from cliFactory import cli
from config import config
import java.lang.Exception as JException
from java.io import File
import time
import os
from commonUtils import CommonUtils, Log
from util import util
import shutil
import traceback
import tarfile
from cbb.frame.util.tar_util import decompress_tar_all_file


def decompress_tar(file_name, savedir):
    decompress_tar_all_file(file_name, savedir, "r")


class FaultDiskLogCollector(object):
    '''
    classdocs
    '''
    def __init__(self, devObject, disklogConf, msgInfo, collectAllLog = True):
        '''
        Constructor
        '''
        self.devObj = devObject
        self.disklogConf = disklogConf
        self.msgInfo = msgInfo
        self.logger = Log(self.devObj)
        self.util = CommonUtils(self.devObj, self.logger)
        self.collectStatus = {}
        self.collectAll = collectAllLog
        self.collectIPBoxHaveEorr = False

    def doCollect(self):
        '''
        @summary: start to collect fault disk log here
        @return status
        '''
        self.logger.info("system now export fault disk log using show command interface...")
        if not self.checkUsrPrivilege():
            self.msgInfo.writeMsgLine('Isolated disk log failed to collect:' +
                                      ' user privilege insufficient ...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)

            return False, ""
        isInformSucc = self.inform2Collect()
        if not isInformSucc:
            return False, ""
        util.refreshProcess(self.devObj, 5)
        controllerStatus = self.getCtrlrCollectionStatus()        
        for controller in controllerStatus:
            if "success" in controllerStatus[controller].lower():
                isCltSucc = self.getCtlrFaultLog2Local(controller)
                self.logger.info("controller %s collection status:%s" % (str(controller), str(isCltSucc)))
                if not isCltSucc:
                    self.collectStatus[controller] = -1
                else:
                    self.collectStatus[controller] = 1
            else:
                self.msgInfo.writeMsgLine('controller ' + controller + "'s Isolated disk log" +
                                          " failed to collect: get file export path failed.",
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
                msg = "failed.get.fault.disk.log.on.ctrlr"
                self.collectStatus[controller] = -1
                self.util.addPyDetailMsg(msg, controller)
        if util.is_X10(self.devObj):
            (isSuccess, failMesage) = self.collectIPBox()
            if failMesage != "":
                util.setPyDetailMsg(self.devObj, failMesage)
                self.collectIPBoxHaveEorr = True
        util.refreshProcess(self.devObj, 90)
        return self.countCollectionStatus()

    def inform2Collect(self):
        '''
        @summary: inform device to collect fault disk log on 
        @summary: isSuccess
        '''
        collectSpecialId = ""
        if not self.collectAll:
            flag, collectSpecialId = self.util.getCtrlIDByIP(self.util.getLoginIp(self.devObj))
            if not (flag and collectSpecialId):
                self.logger.info("get controller id failed by loginIP:%s" % str(self.getLoginIp(self.devObj)))
                return False
        if collectSpecialId:
            cmd = "show file export_path file_type=isolated_disklog controller_id=%s" % collectSpecialId
        else:
            cmd = "show file export_path file_type=isolated_disklog"
        timeout = 1 * 60
        isSucc , cliEcho = cli.executeCmdWithTimout(self.devObj, cmd, timeout)
        if isSucc and "command executed successfully" in cliEcho.lower():
            return True
        elif "error:" in cliEcho.lower():
            if "system is exporting file" in cliEcho.lower():
                self.util.addPyDetailMsg(cliEcho)
                self.msgInfo.writeMsgLine('Isolated disk log failed to collect: ' +
                                          'show file export path failed, system is exporting files...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)

            elif "no enough available space" in cliEcho.lower():
                msg = "failed.export.fault.disk.log.current.ctlr.insufficient.space"
                self.util.addPyDetailMsg(msg)
                self.msgInfo.writeMsgLine('Isolated disk log failed to collect: ' +
                                          'show file export path failed, system has insufficient space...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            else:
                msg = "please.try.again.later"
                self.util.addPyDetailMsg(msg)
                self.msgInfo.writeMsgLine('Isolated disk log failed to collect: ' +
                                          'show file export path failed, system export file failed...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            self.logger.info("inform system to export but got failure return code...")
            return False
        self.logger.info("failed to inform system to export fault disk log...")
        return False

    def getCtrlrCollectionStatus(self):
        '''
        @summary: get fault disk log collection status on controllers 
        @return: isCollection status okay to continue, controller Ids to process download operation.
        '''
        self.logger.info("now start to sleep about 20s to wait for system exporting files...")
        time.sleep(20)
        cmd = "show file package_result file_type=isolated_disklog"
        timeout = 1 * 60
        waitTotalTime = config.FAULT_DISK_LOG_TIMEOUT * 60
        ctrlrStatus = {}
        currentProcess = 6
        percentNumber = 80.0 / 28
        if util.is_X10(self.devObj):
            percentNumber = 40.0 / 28
        while waitTotalTime > 0:
            isSucc , cliEcho = cli.executeCmdWithTimout(self.devObj, cmd, timeout)
            currentProcess = util.refreshProcessByStep(self.devObj, currentProcess, percentNumber)
            if isSucc:
                hasFinished, ctrlrStatus = self.parseCollectResultStatus(cliEcho)
                if hasFinished :
                    return ctrlrStatus
            time.sleep(10)
            waitTotalTime -= 10
        self.logger.warn("still found unfinished item(s) after 3 minute waiting for fault disk log ...")
        return ctrlrStatus

    def checkUsrPrivilege(self):
        '''
        @summary: check user privilege, only administrator and upper level are permitted
        '''
        isPrivilege = util.checkUserPrivilege(self.devObj)
        if not isPrivilege:
            return False
        else:
            return True

    def parseCollectResultStatus(self, cmdEcho):
        '''
        @summary: parse collection statue, if unfinished item is detected, return False.
        @return has Finished or not , collected controller status
        '''
        ctrlrStatus = {}
        dictList = self.util.getHorizontalCliRet(cmdEcho)
        hasFinished = True
        for resultDict in dictList:
            if resultDict.get("Controller ID", "") and resultDict.get("Single Result", ""):
                ctrlrStatus[resultDict.get("Controller ID")] = resultDict.get("Single Result")
            for controller in ctrlrStatus:
                if "exporting" in ctrlrStatus[controller].lower():
                    hasFinished = False

        return hasFinished, ctrlrStatus

    def getCtlrFaultLog2Local(self, ctrlrId):
        '''
        @summary: get controller's fault disk log 
        '''
        self.logger.info("now try to get fault disk log about controller %s to local directory" % str(ctrlrId))
        cmd = "show file notification file_type=isolated_disklog controller_id=" + ctrlrId
        timeout = 1 * 60
        isSucc, cliEcho = cli.executeCmdWithTimout(self.devObj, cmd, timeout)
        if not isSucc:
            msg = "failed.get.fault.disk.log.location.about.ctrlr"
            self.util.addPyDetailMsg(msg, ctrlrId)
            self.msgInfo.writeMsgLine('Isolated disk log on controller ' + ctrlrId + ' failed to collect: ' +
                                      'show file notification command execute failed...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            return False
        if "file path :" in cliEcho.lower():
            filePath = ""
            for line in cliEcho.splitlines():
                if "file path :" in line.lower() and len(line.split(":")) >= 2:
                    filePath = line.split(":")[1].strip()
            self.logger.info("fetched remote file location %s" % str(filePath))
            isSuccess = self.downloadFile2Local(filePath, ctrlrId)
            if not isSuccess:
                msg = "failed.download.fault.disk.log.on.ctrlr"
                self.util.addPyDetailMsg(msg, ctrlrId)
            self.deleteRemoteFile(ctrlrId)
            return isSuccess
        elif "no enough available space" in cliEcho.lower():
            msg = "failed.export.fault.disk.log.insufficient.space"
            self.logger.info("no space to copy controller %s's fault disk log to current controller." % str(ctrlrId))
            self.util.addPyDetailMsg(msg, ctrlrId)
            self.msgInfo.writeMsgLine('Isolated disk log on controller ' + ctrlrId + ' failed to collect: ' +
                                      'show file notification command execute failed, no enough space...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            return False
        else:
            msg = "failed.get.fault.disk.log.location.about.ctrlr"
            self.logger.info("failed to copy controller %s's fault disk log to current controller." % str(ctrlrId))
            self.util.addPyDetailMsg(msg, ctrlrId)
            self.msgInfo.writeMsgLine('Isolated disk log on controller ' + ctrlrId + ' failed to collect: ' +
                                      'show file notification command execute failed, error occurred...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
            return False

    def downloadFile2Local(self, remoteFile, localDir, isNotIPBox = True):
        '''
        @summary: download remote file to local directory
        '''
        sftp = self.devObj["SFTP"]
        curNodeDisklogSaveDir = os.path.join(self.devObj[config.COLLECT_INFO_LOCAL_PATH], \
                                 config.COLLECT_INFO_DIR_NAME[config.COLLECT_TYPE_DISKLOG], \
                                  self.disklogConf.ISOLATED_DISKLOG_DIR_NAME, localDir)
        if not os.path.exists(curNodeDisklogSaveDir):
            os.makedirs(curNodeDisklogSaveDir)
        collectionStatus = False
        try:
            self.logger.info("download remote file to local:")
            sftp.getFile(remoteFile, File(curNodeDisklogSaveDir), None)
            self.logger.info("finished downloading file...")
            if not self.collectAll and isNotIPBox:
                logFile = os.path.join(curNodeDisklogSaveDir, remoteFile.split("/")[-1])
                if os.path.exists(logFile) and os.path.isfile(logFile):
                    self.postProcess4RecentLogDownload(curNodeDisklogSaveDir, logFile)
            collectionStatus = True
        except JException, excp:
            self.logger.error("Tool exception occurred while downloading file(s): %s" % str(excp))
            self.msgInfo.writeMsgLine('Isolated disk log on controller ' + localDir + ' failed to collect: ' +
                                      'download file  but triggered ToolException...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
        except BaseException, baseExcp:
            self.logger.error("exception occurred while downloading file(s) : %s" % str(baseExcp))
            self.msgInfo.writeMsgLine('Isolated disk log on controller ' + localDir + ' failed to collect: ' +
                                      'download file  but found Exception...',
                                      self.disklogConf.DISK_LOG_COLLECT_ERRMSG_FILE_NAME)
        return collectionStatus

    def deleteRemoteFile(self, controllerId):
        '''
        @summary: delete remote file on controller using  CLI interface
        '''
        cmd = "delete file filetype=isolated_disklog controller_id=" + controllerId
        timeout = 1 * 60
        try:
            cli.executeCmdWithTimout(self.devObj, cmd, timeout)
        except:
            self.logger.error("exception occurred while processing delete file command...")

    def countCollectionStatus(self):
        '''
        @summary: count fault disk log collection status
        '''
        hasFailed = False
        hasSucceed = False
        self.logger.info("current collection status %s" % str(self.collectStatus))
        for controller in self.collectStatus:
            if self.collectStatus[controller] < 0:
                hasFailed = True
            else:
                hasSucceed = True

        if hasSucceed and (hasFailed or self.collectIPBoxHaveEorr):
            self.util.setCollectAllInfo(False)
            return  True, ""
        elif hasFailed:
            return False, ""
        else:
            return True, ""
    def postProcess4RecentLogDownload(self, logDir, logTgzFile):
        '''
        @summary: post_Process for collect recent fault disk log
        '''
        try:
            self.logger.info("[postProcessCtrlLog] path:%s, logDir:%s"%(logTgzFile, logDir))
            
            if os.path.getsize(logTgzFile) <= config.RECENT_FAULTLOG_MAX_SIZE:
                self.logger.info("[postProcessCtrlLog] The size of internal_log is less than 10MB")
                return
            
            if logTgzFile.endswith(".tgz"):
                decompress_tar(logTgzFile, logDir)
                self.logger.info("common_RemoveFile logTgzFile")
                
            for fileTmp in os.listdir(logDir):
                fileTmpPath = os.path.join(logDir, fileTmp)
                if fileTmp.endswith(".tar"):
                    decompress_tar(fileTmpPath, logDir)
                    self.common_RemoveFile(fileTmpPath)
                
            self.common_RemoveFile(os.path.join(logDir, "fault_disklog", "hdd"))
            self.common_RemoveFile(os.path.join(logDir, "fault_disklog", "hssd"))
            interLogDir = os.path.join(logDir, "fault_disklog", "internal_log")
            self.logger.info("[postProcessCtrlLog] interLogDir:%s, logDir:%s"%(interLogDir, logDir))
            if not os.path.exists(interLogDir):
                self.logger.error("[postProcessCtrlLog] internal_log dir not exist")
                return
            
            fileList = self.getRecentFileList(interLogDir)
            if not fileList:
                self.logger.error("[postProcessCtrlLog] no internal_log")
            
            totalSizeCount = 0L
            for fileTmp in fileList:
                fileTmpPath = os.path.join(interLogDir, fileTmp)
                fileTmpSize = os.path.getsize(fileTmpPath)
                if (totalSizeCount + fileTmpSize) > config.RECENT_FAULTLOG_MAX_SIZE:
                    self.logger.error("[postProcessCtrlLog] The file %s size %s is too large, need delete!" % (fileTmpPath, str(fileTmpSize)))
                    self.common_RemoveFile(fileTmpPath)
                    continue
                
                totalSizeCount += fileTmpSize
            
            exPath = os.path.join(os.path.join(logDir, "fault_disklog"))
            self.logger.info("temp file path = %s" % exPath)
            
            tarFile = tarfile.open(logTgzFile,'w:gz')
            tarFile.add(exPath , arcname = "fault_disklog")
            
            #删除解压的临时文件
            fault_disklog_path = os.path.join(logDir, "fault_disklog")
            self.logger.info("fault_disklog_path = %s" % fault_disklog_path)
            if os.path.exists(fault_disklog_path):
                try:
                    util.cleanDir(fault_disklog_path)
                except:
                    self.logger.error("del temp file fail")
                self.logger.info("del temp file success")
                
            self.logger.info("compress ok!" )
            tarFile.close()
            return
        except:
            self.logger.error("[postProcessCtrlLog]error: " + traceback.format_exc())
            return
            
        
    def common_RemoveFile(self, filePath):
        '''
        @summary: common function for file or directory move action
        '''
        try:
            if not os.path.exists(filePath):
                return
            util.add_permission(filePath)
            if os.path.isdir(filePath):
                shutil.rmtree(filePath, ignore_errors = True)
            elif os.path.isfile(filePath):
                os.remove(filePath)
            return
        except:
            self.logger.error("[common_RemoveFile]error: " + traceback.format_exc())
            return
    def getRecentFileList(self, fileDir):
        '''
        @summary: common function for file sort
        '''
        fileTmpList = os.listdir(fileDir)
        fileTmpList.sort(reverse = True)
        self.logger.info("fileTmpList sort:%s"%(",".join(fileTmpList)) )
        return fileTmpList

    def collectIPBox(self):
        '''
        @summary:
        @return:
        '''
        (isSuccess, failMesage) = (False, "")
        limitTime = config.FAULT_DISK_LOG_TIMEOUT
        repeatTimes = limitTime * 6
        successNoedList = []  # 收集成功的节点
        hasErrMsgNodeList = []  # 收集失败的节点
        percentNumber = 40.0 / 20
        currentProcess = 46
        while repeatTimes != 0:
            repeatTimes -= 1
            (isSuccess, collectStatus, cmd4statusRet) = self.queryCollectStatus()
            self.logger.info("QueryCollect StatusisSuccess is " + str(isSuccess))
            if not isSuccess:
                break
            # 兼容没有IP框的场景，将包含的定错误信息的回显，当做收集结束，等同于Packaging消失(标志由产品提供)
            if "Failed to query the export status" in str(cmd4statusRet) \
                    and 'Run the "show file export_path" command' in str(cmd4statusRet):
                return (True, "")
            totalResult = collectStatus["totalResult"]
            singleResultDict = collectStatus["singleResultDict"]
            for key in singleResultDict.keys():
                NodeID = key
                singleResult = singleResultDict[key]
                if singleResult in ["Busy", "Failed", "Out of Memory"] :
                    self.deleteRemoteFile(NodeID)
                    hasErrMsgNodeList.append(NodeID)
                if "Successful" in singleResult:
                    cmd = "show file notification file_type=isolated_disklog controller_id=" + NodeID
                    timeout = 1 * 60
                    isSucc, cliEcho = cli.executeCmdWithTimout(self.devObj, cmd, timeout)
                    if not isSucc:
                        hasErrMsgNodeList.append(NodeID)
                        break
                    if "file path :" in cliEcho.lower():
                        filePath = ""
                        for line in cliEcho.splitlines():
                            if "file path :" in line.lower() and len(line.split(":")) >= 2:
                                filePath = line.split(":")[1].strip()
                        isSuccess = self.downloadFile2Local(filePath, NodeID, False)
                        if not isSuccess:
                            hasErrMsgNodeList.append(NodeID)
                            msg = "failed.download.fault.disk.log.on.ctrlr"
                            self.util.addPyDetailMsg(msg, NodeID)
                        else:
                            successNoedList.append(NodeID)
                    self.deleteRemoteFile(NodeID)
            if "Packaging" not in totalResult:
                break
            #以10秒为间隔时间进行轮询
            time.sleep(10)
            currentProcess = util.refreshProcessByStep(self.devObj, currentProcess, percentNumber)

        successNoedNum = len(successNoedList)
        errNoedNum = len(hasErrMsgNodeList)
        # 收集失败
        if successNoedNum == 0:
            isSuccess = False
            failMesage = util.getMsg(self.devObj, "collect.FaultDisklog.IPBox.failed")
            # 成功或部分成功
        else:
            isSuccess = True

        if isSuccess and errNoedNum != 0:
            failMesage = util.getMsg(self.devObj, "collect.FaultDisklog.IPBox.some.Success")
        return (isSuccess, failMesage)

    def queryCollectStatus(self):
        '''
        #轮询收集进度
        @return 1:True or False,命令执行成功
        @return 2:收集进度{"总的进度" : "" , "单个节点的进度" : {"节点" : "进度"}..}
        @return 3:cli回显
        '''
        (isSuccess, collectStatus, cliRet) = (False, {"totalResult": "", "singleResultDict": {}}, "")

        cmd4status = "show file package_result file_type=isolated_disklog"
        (isSuccess, cliRet) = cli.executeCmdNoLogTimeout(self.devObj, cmd4status)
        self.logger.info("queryCollectStatus and the cliRet is " + str(cliRet))
        if not isSuccess:
            util.setPyDetailMsg(self.devObj, "dev.conn.failure")
            return (isSuccess, collectStatus, cliRet)
        if "Total Result" not in cliRet:
            if "Failed to query the export status" not in str(cliRet) \
                    or 'Run the "show file export_path" command' not in str(cliRet):
                 util.setPyDetailMsg(self.devObj, "cli.excute.failure", cliRet)
            return (isSuccess, collectStatus, cliRet)

        totalResult = ""
        NodeID = ""
        singleResult = ""

        dictList = cli.getCliTable2DictList(cliRet)
        for dict in dictList:
            totalResult = dict["Total Result"]
            if totalResult != "" and totalResult != "--":
                collectStatus["totalResult"] = totalResult

            singleResultDict = collectStatus["singleResultDict"]
            NodeID = dict["Controller ID"]
            singleResult = dict["Single Result"]
            singleResultDict.update({NodeID: singleResult})
            collectStatus["singleResultDict"] = singleResultDict

        return (True, collectStatus, cliRet)

