﻿# coding:utf-8
import os
import stat
import subprocess
import time
import traceback
from cbb.common.util.system import clean_permission_on
from common import common_cli_utils
from cbb.frame.context import contextUtil
from frameone.common import copy_file_to_smart_and_rename
from frameone.util import collect_util
from common.util import *

OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


def execute(devObj):
    try:
        util.refreshProcess(devObj, 1)
        collectPath = util.getLocalDir(devObj) + os.path.sep + devObj["collectRetFileName"]
        copy_file_to_smart_and_rename.add_smart_file(devObj)
        #压缩前，增加eServer描述文件
        creatPkginfo(collectPath, devObj)
        util.refreshProcess(devObj, 10)
        #删除临时文件
        system_log_path = os.path.join(collectPath, "DataCollect", "System_log")
        check_lost_folder(devObj, system_log_path)
        #压缩文件
        localFileFinal = devObj["collectRetFileName"] + ".7z"
        compressFilePath = util.getLocalDir(devObj) + os.path.sep + localFileFinal
        collect_util.copy_log_and_ini_to_collect_ret_dir(devObj)
        from com.huawei.ism.tool.obase.utils import FileAssistant
        res_list = FileAssistant.compressDirTo7ZFileWithResDump(compressFilePath, collectPath + os.path.sep + "*",
                                                                "-t7z")
        log.info(devObj, "compress res:{}".format(res_list))
        if not check_compress_res(devObj, res_list, compressFilePath):
            return False, ""
        devObj["collectRetFileName"] = localFileFinal
        util.refreshProcess(devObj, 50)
        util.cleanDir(collectPath)
        util.refreshProcess(devObj, 80)
        clean_permission_on(compressFilePath, devObj.get("logger"))
        util.refreshProcess(devObj, 99)
        return (True, "")
    except Exception:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")
    finally:
        if contextUtil.is_run_in_svp() and \
                common_cli_utils.can_enter_debug_mode_for_read_only_user(
                devObj):
            common_cli_utils.restore_connection(devObj)


def check_compress_res(dev_obj, res_list, result_file):
    """
    检查压缩文件的结果，根据7z的压缩堆栈确认部分根因
    :param dev_obj: 上下文
    :param res_list: 压缩结果
    :param result_file: 目标压缩文件
    :return: 检查结果 True 成功， False 失败。
    """
    if os.path.exists(result_file):
        log.info(dev_obj, "result_file:{} is compress success!".format(result_file))
        return True

    err_msg_key_dict = {
        "Can't allocate required memory": "memory.not.enought.error",
    }
    res_list = list(res_list)
    if len(res_list) != 2:
        util.setPyDetailMsg(dev_obj, "compress.file.error")
        return False
    dump_info = str(res_list[1])
    if str(res_list[0]) == "true":
        return True

    for err_key, msg_key in err_msg_key_dict.items():
        if err_key in dump_info:
            util.setPyDetailMsg(dev_obj, msg_key)
            return False

    util.setPyDetailMsg(dev_obj, "compress.file.error")
    return False


def check_lost_folder(device_object, local_file_path):
    """
    判断如果存在文件夹，则加权限删掉这个文件夹
    :param device_object:
    :param local_file_path:
    :return:
    """
    log.info(device_object, "delete lost files begin:{}".format(local_file_path))
    if not os.path.exists(local_file_path):
        return
    for temp_file in os.listdir(local_file_path):
        temp_file_path = os.path.join(local_file_path, temp_file)
        log.info(device_object, "delete lost files temp_file_path:{}".format(temp_file_path))
        if os.path.isdir(temp_file_path):
            log.info(device_object, "delete lost files begin delete:{}".format(temp_file_path))
            util.cleanDir(temp_file_path)


def creatPkginfo(rootPath, devObj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    pkginfoPath = rootPath + os.sep + "pkginfo"
    typeFile = pkginfoPath + os.sep + "type_collect"
    domainFile = pkginfoPath + os.sep + "domain_storage"
    descFile = pkginfoPath + os.sep + "desc"
    snFmt = "deviceSN=${%s}\n"
    timeFmt = "fileCreateTime=%s"
    try:
        #如果pkginfo已存在，则需要先删除
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)
            
        os.mkdir(pkginfoPath)
        #先创建type文件，然后拷贝type并重命名为domain文件
        fileObj = os.fdopen(os.open(typeFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        fileObj.close()
        shutil.copy(typeFile, domainFile)
         #创建Desc文件并写入SN号和时间（UTC）
        #获取SN号和时间毫秒数
        snInfo = snFmt % str(device.getDeviceSn(devObj))
        timeInfo = timeFmt % str(long(time.time()*1000))
        from com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil import getAllToolVersion
        tool_version = "\ntool-version={{{}}}".format(",\n".join(getAllToolVersion()))
        desc_file = os.fdopen(os.open(descFile, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        seq = [snInfo, timeInfo, tool_version]
        desc_file.writelines(seq)
        desc_file.close()
        log.info(devObj, "[creatPkginfo] Creat the pkginfo succeed!")
    
    except:
        if os.path.exists(pkginfoPath):
            shutil.rmtree(pkginfoPath, True)  
        log.error(devObj, "[creatPkginfo] Creat the pkginfo failed! except trace back: " + str(traceback.format_exc()))
        
    