﻿# -*- coding: UTF-8 -*-
import traceback
import os
from common.util import *
from common.exportCmd import *
from common.exportInfo import *
from common.config import config

from cbb.business.collect.deviceInfo.collect_cmd import MultiCmdExecuter


def collectLog(devObj):
    try:
        log.info(devObj, "Begin to collect log.")
        util.initPyDetailMsg(devObj)
        devVersion = device.getDeviceVersion(devObj)
        if "V100" in devVersion:
            isSucc = exportInfo.exportSysInfoForTv1(devObj, config.EXPORT_TYPE_LOG)
        else:
            isSucc = exportInfo.exportSysInfo(devObj, config.EXPORT_TYPE_LOG)
        return (isSucc, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
    

def collectCliCmd(devObj):
    try:
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            return(False, "")

        # 单独先收集故障诊断CLI命令回显
        collect_fault_diagnose_cmd(devObj)

        flag = exportCmd.exportCliCmdReport(devObj)
        return (flag, "")
    except:
        log.info(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")
    

def collect_fault_diagnose_cmd(dev_obj):
    """
    收集故障诊断命令信息
    :param dev_obj:
    :return:
    """
    try:
        # 收集类型
        collect_type = config.COLLECT_TYPE_CLI_FAULT_TREE
        exportCmd.writeCliCmdFile(dev_obj, '', collect_type, '')
        res_file_dir = util.getLocalInfoPathByType(dev_obj, collect_type)
        res_file_name = config.CLI_FILE_NAMES_FOR_TYPE.get(collect_type)
        # 结果文件路径
        res_file_path = os.path.join(res_file_dir, res_file_name)
        script_path = os.path.dirname(os.path.abspath(__file__))
        # 命令配置xml路径在package目录下
        xml_path = os.path.join(
            script_path,
            os.path.join("..", "..", "FaultTreeCmdList.xml")
        )
        log.info(
            dev_obj, "xml_path:{}, res_file_path:{}".format(
                xml_path, res_file_path
            )
        )
        multi_cmd_executer = MultiCmdExecuter(dev_obj, xml_path, res_file_path)
        multi_cmd_executer.execute()
    except Exception:
        log.error(dev_obj, "collect diagnose cmd except:{}".format(str(
            traceback.format_exc())))
        ssh = dev_obj["SSH"]
        systemMode.reconnect_ssh(ssh, log)

   
    
