# -*- coding: UTF-8 -*-

class config():

    # ********************信息收集类型********************
    EXPORT_TYPE_LOG = "log"  # collect log
    COLLECT_TYPE_CLI = "cli"

    SYSTEM_RUNNING_STATUS_UPGRADING = "upgrade:/>"

    # 收集到得信息存放的本地路径
    COLLECT_INFO_LOCAL_PATH = "collect_info_local_path"

    # 判断系统日志是否收集完全
    COLLECT_LOG_FILE_INFO = "info_log.txt"

    COLLECT_TYPE_CLI_FAULT_TREE = "cli_fault_tree"

    # 判断导出命令的回显是否正常的标准
    COLLECT_INFO_RECROD_STANDARD = "The log collection is finished"

    # 收集信息所存放的目录名称
    COLLECT_INFO_DIR_NAME = {
        EXPORT_TYPE_LOG: "System_log",
        COLLECT_TYPE_CLI: "CLI_command_info",
        COLLECT_TYPE_CLI_FAULT_TREE: "CLI_command_info"
    }

    # 需要判断系统日志，具体信息是否收全的项
    IS_SYSTEM_INFO_FULL = [EXPORT_TYPE_LOG]

    # 需要判断控制器，是否收全的项
    IS_CONTROLLER_INFO_FULL = [EXPORT_TYPE_LOG]

    # 删除阵列端临时文件判断标准
    DELETE_REMOTE_DATA_STANDARD = [
        "System is exporting files"
    ]

    # ********************信息收集类型********************

    EXPORT_INFO_TIMEOUT = {
        EXPORT_TYPE_LOG: 23 * 60,
    }

    # 并行方式收集的超时时间，单位：分
    PARALLEL_EXPORT_INFO_TIMEOUT = {
        EXPORT_TYPE_LOG: 33,
    }
    # 一般CLI命令的超时时间：2分钟
    COMMON_CMD_TIMEOUT = 2 * 60

    CLI_EXECUTE_CMD_SUCCESS = "Command executed successfully"

    # 判断新命令执行成功的列表
    ISEXEC_CMD_SUCCESS_FLAG = [
        "/home/permitdir"
    ]

    # CLI回显、电子标签、smart信息收集，对应的文件名称
    CLI_FILE_NAMES_FOR_TYPE = {
        COLLECT_TYPE_CLI: "minisystemCLI_",
        COLLECT_TYPE_CLI_FAULT_TREE: 'fault_diagnose_info.txt'
    }

    # CLI回显收集的命令列表
    LIST_CLI_CMD = [
        "om_show_omm_info.sh -c",
        "showbootmode",
        "showdevstate",
        "showdiskinfo",
        "showsysflow 1",
        "showsysstatus",
        "showsystrace",
        "showsystrace 2",
        "showsystrace 11",
        "showversion",
    ]

    # CLI命令的超时时间(部分CLI执行时间不是默认的2min)
    cmdLimitTimeDict = {
        "show event": 300,
    }
