# -*- coding: UTF-8 -*-
import os
import re
import traceback
import codecs
from common.exportInfo import exportInfo
from common.util import device
from common.util import util
from common.util import log
from common.cliFactory import cli
from common.config import config

class exportCmd():
    
    @staticmethod
    def getExecuteCliCmd(strCmd, type):
        '''
        #CLI回显收集，判断当前收集的命令，是否收集详细信息，及详细信息参数的来源
        '''
        result = strCmd
        #判断是否收集详细信息，不收集则直接返回当前命令
        flag = exportCmd.isMultiCmd(strCmd, type)
        if not flag:
            return result
        
        #获取查询详细信息CLI的构造列表
        list_cmd = exportCmd.getMultiCmdList(type)
        tempList = list_cmd[strCmd]
        
        
        if len(tempList) <= 2:
            return result
        
        #列表大于2，则需要根据配置的CLI命令，获取参数值
        tempCmd = tempList[2]
        if tempCmd:
            result = tempCmd
    
        return result
       
    @staticmethod
    def writeCliCmdFile(devObj, strCmd, type, suffix):
        '''
        @summary: CLI回显信息收集，将回显信息写入文件中
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        strCmd=回显信息
        @return:
        '''
        #需要写入的目录
        path = util.getLocalInfoPathByType(devObj, type)
        result = exportCmd.writeCliCmdFileByPath(devObj, path, strCmd, type, suffix)
        return result
    
    @staticmethod
    def writeCliCmdFileByPath(devObj, path, strCmd, type, suffix):
        '''
        @summary: 将回显信息写入文件中
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
                        strCmd=回显信息
                        path=写入的目录
        @return:
        '''
        try:
            f = None
            if True != os.path.exists(path):
                os.mkdir(path)
                
            fileName = config.CLI_FILE_NAMES_FOR_TYPE[type] + suffix
            
            f = codecs.open(path + fileName, "a", "utf-8")
            f.write(strCmd)
            return True
        except:
            log.error(devObj, "write except: {}, except trace back: {}".format(strCmd, traceback.format_exc()))
            return False
        finally:
            if None != f:
                f.close()
    
    @staticmethod
    def getMultiCmdList(type):
        '''
                    根据收集的类型，获取需要收集详细信息的命令列表
        '''
        list_cmd = None
        
        return list_cmd
    
    
    @staticmethod
    def isMultiCmd(strCmd, type):
        '''
                    判断是否需要获取CLI命令的详细信息
        '''
        flag = False
        list_cmd = exportCmd.getMultiCmdList(type)
        
        if None == list_cmd:
            return flag
            
        if strCmd in list_cmd.keys():
            flag = True
        
        return flag
        
    @staticmethod
    def getMultiCmdIds(devObj, cliRet, type, strCmd):
        '''
                    获取CLI回显中ID列的信息，返回ID列表
        '''
        list_multi_cmd = []
        
        list_cliRet =cli.getCliTable2DictList(cliRet)
        list_multi = exportCmd.getMultiCmdList(type)
        
        fieldName = list_multi[strCmd][0]
        
        for field in list_cliRet:
            if fieldName in field.keys():
                id = field[fieldName]
                list_multi_cmd.append(id)
            
        return list_multi_cmd
    
    
    @staticmethod
    def getCliResultInfo(devObj, strCmd, type):
        '''
                    获取CLI回显信息，若需要获取详细信息，则获取详细信息
        '''
        result = ""
        list_multi_cmd_ids = []
        if strCmd == None:
            log.info(devObj, "get cmd is none")
            return result
        
        execCmd = exportCmd.getExecuteCliCmd(strCmd, type)
        
        if execCmd in config.cmdLimitTimeDict:
            limitTime = config.cmdLimitTimeDict.get(execCmd, 12000000)
            (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, execCmd, limitTime)
        else:
            (isSuccess, rec) = cli.executeCmdNoLogTimeout(devObj, execCmd)
            
        if not isSuccess:
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return ""
        
        if False == exportCmd.isMultiCmd(strCmd, type):
            result = rec
        else:
            list_multi_cmd_ids = exportCmd.getMultiCmdIds(devObj, rec, type, strCmd)
            list_multi_cmd = exportCmd.getMultiCmdList(type)
            
            for field_cmd in list_multi_cmd_ids:
                cmd = strCmd + " " + list_multi_cmd[strCmd][1] + field_cmd
                (isSuccess, recs) = cli.executeCmdNoLogTimeout(devObj, cmd)
                if not isSuccess:
                    util.setPyDetailMsg(devObj, "dev.conn.failure")
                    return ""
                result = result + recs
            
        return result
    
    @staticmethod
    def exportCliFromOppositeEquip(devObj): 
        oppositeEquip = device.getPeerEth2IP(devObj) #对端设备命名
        log.info(devObj, "Peer controller eth2 IP is:" + unicode(oppositeEquip))
        
        usrPwd = device.getDevicePassword(devObj)
        execSucc = device.heartbeatToPeer(devObj, usrPwd)
        if not execSucc:
            log.info(devObj, "Heart beat to peer failed when collecting peer CLI text.")
            util.setPyDetailMsg(devObj, "heart.beat.to.peer.failed")
            return False
        
        if "Normal" == execSucc:
            log.warn(devObj, "Peer controller is normal, need not to collect CLI.")
            util.setPyDetailMsg(devObj, "peer.ctrl.is.not.minisystem")
            return False
        
        log.info(devObj, "Heart beat to peer successfully when collecting peer CLI command!")
        
        suffix = oppositeEquip+".txt"
        isExecSuccess = exportCmd.exportCliCmd(devObj, config.LIST_CLI_CMD, config.COLLECT_TYPE_CLI, suffix) #收集对端CLI回显
        if not isExecSuccess:
            log.info(devObj, "peer controller CLI collect failed!")
        
        #退出心跳
        device.exitHeartbeatToPeer(devObj)
        return isExecSuccess
        
    @staticmethod
    def exportCliCmdReport(devObj):
        
        nodeCfg = device.getDeviceNodeCfg(devObj)
        devVersion = device.getDeviceVersion(devObj)
        
            
        #1.收本端日志，日志包后缀suffix.
        curDevIp = device.getDeviceIP(devObj)
        suffix = curDevIp.replace(':', '_') + ".txt"
        getSuccCur = exportCmd.exportCliCmd(devObj, config.LIST_CLI_CMD, config.COLLECT_TYPE_CLI, suffix)
        
        if nodeCfg == 1 :  #单控
            log.info(devObj, "the device is single controller.")
            util.setCollectAllInfo(devObj, getSuccCur)
            return getSuccCur
        elif nodeCfg == 2 or (nodeCfg == 0 and "V100" in devVersion): #双控
            #获取对端CLI
            getSuccOpp = exportCmd.exportCliFromOppositeEquip(devObj)
            log.info(devObj, "the device is double controller.")
            isCliCollectSucc = getSuccCur or getSuccOpp     #状态：只要有一端收集成功CLI收集项即为成功
            isAllCollectSucc = getSuccCur and getSuccOpp    #状态：所有节点的CLI收集成功时表示全部成功，否则表示部分成功或者失败。
            util.setCollectAllInfo(devObj, isAllCollectSucc)
            return isCliCollectSucc
        elif nodeCfg >2: #多控
            #获取对端日志 文件 
            getSuccOpp = exportCmd.exportCliFromOppositeEquip(devObj)
            
            log.info(devObj, "the device is more than double controller.")
            collectFlag = getSuccCur or getSuccOpp
            isAllSucc = False
            if getSuccOpp and getSuccCur:
                util.setPyDetailMsg(devObj, "cur.only.support.double.controller")
            util.setCollectAllInfo(devObj, isAllSucc)
            return collectFlag
        else:#获取控制器节点个数失败
            #获取对端CLI 文件 
            getSuccOpp = exportCmd.exportCliFromOppositeEquip(devObj)
            
            log.info(devObj, "get the number of controller information fail")
            collectFlag = getSuccCur or getSuccOpp
            isAllSucc = False
            if getSuccOpp and getSuccCur:
                util.setPyDetailMsg(devObj, "get.controller.info.fail")
            util.setCollectAllInfo(devObj, isAllSucc)
            return collectFlag

    @staticmethod
    def exportCliCmd(devObj, cliList, type, suffix):
        '''
        @summary: 收集CLI回显信息的入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        
        result = "Storage: minisystem>"
        flag = exportCmd.writeCliCmdFile(devObj, result, type, suffix)
        if flag == False:
            log.info(devObj, "write cli into to file fail")
            util.setPyDetailMsg(devObj, "dev.conn.failure")
            return flag
        
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        
        #获取所有Cli模式下命令回文
        for field in cliList:
            result = exportCmd.getCliResultInfo(devObj, field, type)
            if result == "":
                flag = False
                continue
            
            if cli.CLI_NOT_EXIST_FLAG in result:
                continue
            
            if cli.CLI_RET_END_FLAG in result:
                isInRightMode = True
                
            exportCmd.writeCliCmdFile(devObj, result, type, suffix)
        
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
            return False
        
        return isInRightMode
    
    @staticmethod
    def isElableEnd(line):
        '''
                    判断电子标签是否结束，根据结束标记和-----判断
        '''
        reg = "^\s*-+\s*$"
        reg_headline = re.compile(reg)
        match_headline = reg_headline.search(line)
        if (cli.CLI_RET_END_FLAG in line) or (None != match_headline):
            return True
        else:
            return False
        
    @staticmethod
    def getElableKeyAndValue(strInfo):
        '''
                        获取电子标签的Key和Value值,如：
        '''
        list = strInfo.splitlines()
        flag_start = False
        list_elable_key = []
        list_elable_value = []
        keyValue = {}
        for field in list:
            if "Electronic Label" in field:
                flag_start = True
            
            if True == exportCmd.isElableEnd(field):
                
                flag_start = False
                if 0 < len(keyValue):
                    list_elable_value.append(keyValue)
                keyValue = {}
            
            if True == flag_start and ("=" in field):
                
                list_temp = field.split("=")
                key = list_temp[0].strip()
                value = list_temp[1].strip()
                
                if key not in list_elable_key:
                    list_elable_key.append(key)
                
                keyValue[key] = value
                    
        return (list_elable_key, list_elable_value)
        
    @staticmethod
    def getFieldType(atrribute_name):
        '''
                    获取标签的类型，当前默认为string，此方法方便后续扩展
        '''
        type = "string"
        return type
    
    
    @staticmethod
    def parseElableInfo(strInfo, strProperty):
        '''
                        根据当前回显返回，对应格式的XML标签    如：
        '''
        result = """\n        <TABLE attribute="%s">
            <METADATA>
                <FIELDS>%s
                </FIELDS>
            </METADATA>
            <ROWDATA>%s
            </ROWDATA>
        </TABLE>"""
        
        keyValue = exportCmd.getElableKeyAndValue(strInfo)
        
        list_elable_key = keyValue[0]
        list_elable_value = keyValue[1]
        
        if len(list_elable_key) == 0:
            result = result % (strProperty, "", "")
            return result
        
        value0 = list_elable_value[0]
        tempFields = ""
        for field in list_elable_key:
            tempField = '\n' + 20*" " + '<FIELD attribute="%s" fieldtype="%s" width="%s" required="true"/>'
            field_type = exportCmd.getFieldType(field)
            valueLen = 0
            if field in value0.keys():
                valueLen = len(value0[field])
            
            tempField = tempField % (field, field_type, valueLen)
            tempFields += tempField
        
        tempRows = ""
        for elable_value in list_elable_value:
            
            tempRow = '\n' + 16*" " + '<ROW%s/>'
            temps = ""
            for elable_key in list_elable_key:
                temp = ' %s="%s"'
                va = ""
                if elable_key in elable_value.keys():
                    va = elable_value[elable_key]
                temp = temp % (elable_key, va)
                temps += temp
                
            tempRow = tempRow % temps
            tempRows += tempRow
            
        result = result % (strProperty, tempFields, tempRows)
        return result
            
    @staticmethod
    def exportElableCmd(devObj, type):
        '''
        @summary: 收集电子标签的入口
        @param cliRet:  devObj=上下文对象
                        type=收集的类型
        @return:
        '''
        result = '''<DATAPACKET Version="2.0">
    <FILELABEL>
        <VERDESC Ver="1.4" />
    </FILELABEL>
    <TABLES>%s
    </TABLES>
</DATAPACKET>'''
        flag = True
        exportCmd.writeCliCmdFile(devObj, config.ELABLE_LIST_HEADER, type)

        #添加cli回文是否正常判断标识位
        isCliRetNormal = False
        #用于判断是否在正确的模式下，只要有一个命令是在正确的模式下就成功
        isInRightMode = False
        tempResults = ""
        for field in config.LIST_ELABLE_CMD:
            tempResult = exportCmd.getCliResultInfo(devObj, field, type)
            if tempResult == "":
                continue
            
            if ("Error:" not in tempResult) or ("license" in tempResult):
                isCliRetNormal = True
                
            if cli.CLI_RET_END_FLAG in tempResult:
                isInRightMode = True
                
            if field in config.LIST_ELABLE_PROPERTY.keys():
                tempResults += exportCmd.parseElableInfo(tempResult, config.LIST_ELABLE_PROPERTY[field])
            else:
                tempResults += exportCmd.parseElableInfo(tempResult, "default")
        
        result = result % tempResults
        flag = exportCmd.writeCliCmdFile(devObj, result, type)
        
        #系统未在正确模式下
        if False == isInRightMode:
            util.setPyDetailMsg(devObj, "system.not.in.right.mode.noparam")
        
        #三种情况同时满足，则收集电子标签成功
        flag = isCliRetNormal and flag and isInRightMode
        
        return flag