﻿# coding:utf-8
import os
import stat
import time
import traceback
import shutil

from cbb.common.util.system import clean_permission_on
from common.util import *

OS_OPEN_FLAGS = os.O_WRONLY | os.O_CREAT | os.O_TRUNC  # 写 | 创建并打开 | 截断
OS_OPEN_MODES = stat.S_IWUSR | stat.S_IRUSR  # 拥有者具有读写权限


def execute(devObj):
    try:
        #压缩文件
        localFileFinal = devObj["collectRetFileName"] + ".7z"
        collectPath = util.getLocalDir(devObj) + os.path.sep + devObj["collectRetFileName"]
        create_package_info(collectPath, devObj)
        compressFilePath = util.getLocalDir(devObj) + os.path.sep + localFileFinal
        tar_class = devObj.get("PYENGINE.PY_ZIP")
        tar_class.compressFile(compressFilePath, collectPath)
        devObj["collectRetFileName"] = localFileFinal
        util.cleanDir(collectPath)
        clean_permission_on(compressFilePath, devObj.get("logger"))
        return (True, "")
    except Exception:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        devObj["py_detail"] = "catch except when compress file.~~~over!"
        return (False, "")


def create_package_info(root_path, dev_obj):
    '''
    @summary: 创建与datacollect同级的目录pkginfo，用于表示该包是信息收集的包。
        pkginfo下有两个空文件
            type_collect: 信息收集的包
            domain_storage: 存储设备
    '''
    info_path = root_path + os.sep + "pkginfo"
    type_file = info_path + os.sep + "type_collect"
    domain_file = info_path + os.sep + "domain_storage"
    desc_file = info_path + os.sep + "desc"
    sn_string = "deviceSN=${%s}\n"
    time_string = "fileCreateTime=%s"
    try:
        # 如果pkginfo已存在，则需要先删除
        if os.path.exists(info_path):
            shutil.rmtree(info_path, True)

        os.mkdir(info_path)
        # 先创建type文件，然后拷贝type并重命名为domain文件
        with os.fdopen(os.open(type_file, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w') as f:
            f.write("")
        shutil.copy(type_file, domain_file)
        # 创建Desc文件并写入SN号和时间（UTC）
        # 获取SN号和时间毫秒数
        sn_info = sn_string % str(device.getDeviceSn(dev_obj))
        time_info = time_string % str(long(time.time() * 1000))
        desc_file = os.fdopen(os.open(desc_file, OS_OPEN_FLAGS, OS_OPEN_MODES), 'w')
        seq = [sn_info, time_info]
        desc_file.writelines(seq)
        desc_file.close()
        log.info(dev_obj, "[creatPkginfo] Creat the pkginfo succeed!")
    except Exception:
        if os.path.exists(info_path):
            shutil.rmtree(info_path, True)
        log.error(dev_obj, "[creatPkginfo] Creat the pkginfo fail {}".format(
            str(traceback.format_exc())))
