# -*- coding: UTF-8 -*-
import math
from common.util import *

def execute(devObj):
    '''
    @summary: 判断收集smart信息时，是否需要用户确认收集
    @return: 
        1、True|False：True:表示要提示用户确认收集；False:不提示
        2、确认提示信息：只有当第一个元素为True时，该值才有效
    '''
    try:
        util.initPyDetailMsg(devObj)
        isUpgrading = util.isSystemUpgrading(devObj)
        if isUpgrading:
            log.error(devObj, "The system is upgrading.")
            return (False,"")
        
        isSucc = util.changeCliMoreEnabled(devObj)
        if not isSucc:
            log.error(devObj, "Change cli more_enabled=no failed.")
            return (False, "")
        
        (isSucc, diskNum) = util.getDiskNum(devObj)
        if not isSucc:
            log.error(devObj, "Get system disk number failed.")
            return (False, "")
        
        # 收集463块硬盘的smart信息,耗费时间大概为10分钟;收集时间超过10分钟时,要求弹出确认框确认操作
        if diskNum >= 463:
            time = math.ceil(diskNum * 10 / 463.0)
            comfirmInfo = util.getMsg(devObj, "operation.require.long.time", time)
            log.info(devObj, comfirmInfo)
            return (True, comfirmInfo)
        
        return (False, "")
    except:
        log.error(devObj, "except trace back:" + str(traceback.format_exc()))
        return (False, "")