# -*- coding: UTF-8 -*-

import sys
import os
import re
import time
import string
import types
import platform

CODE_ZH_FILE_NAME = r"..\res\resource_zh.properties" if platform.system() == "Windows" \
    else r"../res/resource_zh.properties"
CODE_EN_FILE_NAME = r"..\res\resource_en.properties" if platform.system() == "Windows" \
    else r"../res/resource_en.properties"

class Properties(object):
    
    #文件名称
    fileName = ""
    #映射关系
    valueMap = {}
    #参数分隔符
    paramPart = ""
    
    #类初始化函数
    def __init__(self, fileName):

        #文件更新，重新设置
        if fileName != self.fileName:
            self.fileName = fileName
            self.valueMap = {}
            self.paramPart = ""
            self._createMap()
    
    #重新设置参数分隔符
    def setParamPartStr(self, paramPartStr):
        self.paramPart = paramPartStr
    
    #获取Properties描述
    def getProperties(self, msg):
        
        propertyValue = ""
        if not msg:
            return ""
        
        #传入参数为字符串
        if type(msg) is types.StringType:
            msgStruct = [msg]
        #传入参数为列表类型
        elif type(msg) is types.ListType:
            msgStruct = msg
        else:
            return ""

        #key值有效性判断
        key = msgStruct[0]
        if self.valueMap.has_key(key):
            propertyValue = self.valueMap.get(key)
        
        #判断分隔符是否为空
        if self.paramPart == "":
            return propertyValue

        #msg中删除key值，剩余为输入参数
        msgStruct.pop(0)
        inputParamList = msgStruct
        #输入参数个数
        inputParamCounter = len(inputParamList)
        
        #判断需要输入参数的个数
        needParCnt = self._getParamPartCounter(propertyValue)

        #判断输入参数个数是否匹配
        if needParCnt == inputParamCounter:
            return self._createFullDesc(propertyValue, inputParamList)
        else:
            return propertyValue

        
    #创建映射关系
    def _createMap(self):
        
        #打开文件
        file = open(self.fileName)
        resourceInfo = file.read().decode("utf-8")
        #关闭文件
        file.close()
        lineList = resourceInfo.splitlines()
        #读取解析文件
        for line in lineList:
            #跳过无效行
            if line.find("=") == -1:
                continue
            field = line.split("=")
            if len(field) == 2:
                #将Unicode码转换成中英文
                self.valueMap[field[0]] = field[1].decode('unicode_escape')
    
    #获取Properties描述对应的参数个数
    def _getParamPartCounter(self, propertyValue):
        
        counter = 0
        tempStr = propertyValue
        
        if self.paramPart == "":
            return counter
        
        if propertyValue.find(self.paramPart) == -1:
            return counter
        
        tempStr = tempStr.replace(self.paramPart, "")
        counter = (len(propertyValue) - len(tempStr)) / len(self.paramPart)
        
        return counter
    
    def _createFullDesc(self, propertyValue, inputParamList):
        
        fullDescStr = propertyValue
        
        #实参替换形参
        for param in inputParamList:
            
            temp = ""
            
            if fullDescStr.find(self.paramPart) == -1:
                break

            startIndex = fullDescStr.index(self.paramPart)
            endIndex = startIndex + len(self.paramPart)
            
            temp = fullDescStr[0:startIndex] + param + fullDescStr[endIndex:]
            fullDescStr = temp
        
        return fullDescStr
