# -*- coding: UTF-8 -*-
import os
import shutil
import traceback

from common.util import log

RUNNING_DATA = "Running_Data"
DISKSMARTINFO = "disksmartinfo"
DATACOLLECT = "DataCollect"
CONFIG = "config.txt"


def add_smart_file(devObj):
    path = devObj.get("collect_info_local_path")
    config_path = os.path.join(path, RUNNING_DATA, CONFIG)
    pool_path = os.path.join(path, DISKSMARTINFO, CONFIG)
    smart_path = os.path.join(path, DISKSMARTINFO)
    running_data_path = os.path.join(path, RUNNING_DATA)

    try:
        if os.path.isfile(config_path) and os.path.exists(smart_path):
            shutil.copyfile(config_path, pool_path)
            log.info(devObj, "Smart information collection copying the config file and "
                             "renaming the file to the pool file successfully")
    except Exception:
        log.error(devObj, "Failed to copy the config file and rename the file to the pool file."
                  + str(traceback.format_exc()))
    finally:
        if devObj.get("runningDataClean") and os.path.exists(running_data_path):
            shutil.rmtree(running_data_path)
            log.info(devObj, "Delete the config file and Running_Data folder.")
