﻿# -*- coding: UTF-8 -*-
from frameone.rest import restDataType


class RestCfg():
    REST_CMD_TIMEOUT = 120
    REST_SCOPE_DEFAULT = "0"

class PublicAttributes():
    TYPE = {"key":"TYPE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
    ID = {"key":"ID", "type":restDataType.DataType.DATA_TYPE_STRING}
    NAME = {"key":"NAME", "type":restDataType.DataType.DATA_TYPE_STRING}
    PARENT_TYPE = {"key":"PARENTTYPE", "type":restDataType.DataType.DATA_TYPE_ENUM}
    PARENT_ID = {"key":"PARENTID", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCATION = {"key":"LOCATION", "type":restDataType.DataType.DATA_TYPE_STRING}
    HEALTH_STATUS = {"key":"HEALTHSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}
    RUNNING_STATUS = {"key":"RUNNINGSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}

class System(PublicAttributes):
    CONFIG_MODEL = {"key":"CONFIGMODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}
    PRODUCT_VERSION = {"key":"PRODUCTVERSION", "type":restDataType.DataType.DATA_TYPE_STRING}

#控制器属性
class Controller (PublicAttributes):
    CPU_USAGE = {"key":"CPUUSAGE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
    LIGHT_STATUS = {"key":"LIGHT_STATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}

#框属性
class Enclosure (PublicAttributes):
    LOGIC_TYPE = {"key":"LOGICTYPE", "type":restDataType.DataType.DATA_TYPE_ENUM}
    MODEL = {"key":"MODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}
    HEIGHT = {"key":"HEIGHT", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}

#IBC属性    
class IBC ():
    PWD_CHANGED = {"key":"passwordChanged", "type":restDataType.DataType.DATA_TYPE_STRING}
    KEYPAIR_CHANGED = {"key":"keyPairChanged", "type":restDataType.DataType.DATA_TYPE_STRING}

class ControllerIo():
    ID = {"key":"id", "type":restDataType.DataType.DATA_TYPE_STRING}
    PORT_TYPE = {"key":"portType", "type":restDataType.DataType.DATA_TYPE_ENUM}
    PORT_ID = {"key":"portID", "type":restDataType.DataType.DATA_TYPE_STRING}
    BACKEND_IO = {"key":"backEndIO", "type":restDataType.DataType.DATA_TYPE_SIGN_INT}
    BACKEND_LIMIT = {"key":"backEndLimit", "type":restDataType.DataType.DATA_TYPE_SIGN_INT}

class ErrorInfo:
    CODE = {"key":"code", "type":restDataType.DataType.DATA_TYPE_STRING}
    DESCRIPTION = {"key":"description", "type":restDataType.DataType.DATA_TYPE_STRING}

class SfpOpticalTransceiver(PublicAttributes):
    CMO_EXPORT_DB_DATA_DIR = {"key":"CMO_EXPORT_DB_DATA_DIR", "type":restDataType.DataType.DATA_TYPE_STRING}

class FcPort(PublicAttributes):
    pass

class IntfModule(PublicAttributes):
    MODEL = {"key":"MODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}

class EthPort(PublicAttributes):
    IPV4_ADDR = {"key":"IPV4ADDR", "type":restDataType.DataType.DATA_TYPE_STRING}
    IPV6_ADDR = {"key":"IPV6_ADDR", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOGIC_TYPE = {"key":"LOGICTYPE", "type":restDataType.DataType.DATA_TYPE_SIGN_INT}

class FcoePort(PublicAttributes):
    pass

class License:
    LICENSE_USAGE_INFO = {"key":"LicenseUsageInfo", "type":restDataType.DataType.DATA_TYPE_JSON}
    LICENSE_RESOURCE = {"key":"LicenseResource", "type":restDataType.DataType.DATA_TYPE_JSON}

class LicenseUsageInfo:
    FEATURE_ID = {"key":"FeatureId", "type":restDataType.DataType.DATA_TYPE_ENUM}
    STATE = {"key":"State", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}

class LicenseResource:
    FEATURE_ID = {"key":"FeatureId", "type":restDataType.DataType.DATA_TYPE_ENUM}

class ReplicationPair(PublicAttributes):
    LOCAL_RES_NAME = {"key":"LOCALRESNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
    REMOTE_RES_NAME = {"key":"REMOTERESNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
    REMOTE_DEVICE_ID = {"key":"REMOTEDEVICEID", "type":restDataType.DataType.DATA_TYPE_STRING}
    RECOVERY_POLICY = {"key":"RECOVERYPOLICY", "type":restDataType.DataType.DATA_TYPE_ENUM}

class PubRemoteDevPortAttr:
    DEVICE_ID = {"key":"DEVICEID", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCAL_PORT_ID = {"key":"LOCALPORTID", "type":restDataType.DataType.DATA_TYPE_STRING}
    HEALTH_STATUS = {"key":"HEALTHSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}
    RUNNING_STATUS = {"key":"RUNNINGSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}
class FcLink(PubRemoteDevPortAttr):
    pass

class IscsiLink(PubRemoteDevPortAttr):
    pass

class QuorumServerLink():
    TYPE = {"key":"TYPE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
    ID = {"key":"ID", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCALCONTROLLERID = {"key":"LOCALCONTROLLERID", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCALCONTROLLERNAME = {"key":"LOCALCONTROLLERNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCALPORTID = {"key":"LOCALPORTID", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCALPORTNAME = {"key":"LOCALPORTNAME", "type":restDataType.DataType.DATA_TYPE_STRING}
    PARENTID = {"key":"PARENTID", "type":restDataType.DataType.DATA_TYPE_STRING}
    PARENTTYPE = {"key":"PARENTTYPE", "type":restDataType.DataType.DATA_TYPE_STRING}
    QUORUMSERVERIP = {"key":"QUORUMSERVERIP", "type":restDataType.DataType.DATA_TYPE_STRING}
    RUNNINGSTATUS = {"key":"RUNNINGSTATUS", "type":restDataType.DataType.DATA_TYPE_ENUM}

class ExportData():
    EXPORT_DATA_TYPE = {"key":"exportDataType", "type":restDataType.DataType.DATA_TYPE_ENUM}
    NODE_ID = {"key":"nodeId", "type":restDataType.DataType.DATA_TYPE_STRING}
    CMO_EXPORT_DB_TYPE = {"key":"CMO_EXPORT_DB_TYPE", "type":restDataType.DataType.DATA_TYPE_ENUM}
    CMO_EXPORT_DRIVE_ID = {"key":"CMO_EXPORT_DRIVE_ID", "type":restDataType.DataType.DATA_TYPE_ENUM}

class Expboard(PublicAttributes):
    WWN = {"key":"WWN", "type":restDataType.DataType.DATA_TYPE_STRING}
    MODEL = {"key":"MODEL", "type":restDataType.DataType.DATA_TYPE_ENUM}

class BackupPower(PublicAttributes):
    pass

class SasPort(PublicAttributes):
    enclosureWWNList = {"key":"ENCLOSURE_WWN_LIST", "type":restDataType.DataType.DATA_TYPE_STRING}
    WWN = {"key":"WWN", "type":restDataType.DataType.DATA_TYPE_STRING}
    CURRENT_PEER_PORT_ID = {"key":"CURRENT_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}
    SUGGEST_PEER_PORT_ID = {"key":"SUGGEST_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}

class PciePort(PublicAttributes):
    CURRENT_PEER_PORT_ID = {"key":"CURRENT_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}
    SUGGEST_PEER_PORT_ID = {"key":"SUGGEST_PEER_PORT_ID", "type":restDataType.DataType.DATA_TYPE_STRING}

class Alarm:
    EVENTID = {"key":"eventID", "type":restDataType.DataType.DATA_TYPE_STRING}
    SUGGESTION = {"key":"suggestion", "type":restDataType.DataType.DATA_TYPE_STRING}
    STREVENTID = {"key":"strEventID", "type":restDataType.DataType.DATA_TYPE_STRING}
    DESCRIPTION = {"key":"description", "type":restDataType.DataType.DATA_TYPE_STRING}
    LEVEL = {"key":"level", "type":restDataType.DataType.DATA_TYPE_ENUM}
    SOURCEID = {"key":"sourceID", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
    EVENTPARAM = {"key":"eventParam", "type":restDataType.DataType.DATA_TYPE_STRING}
    SEQUENCE = {"key":"sequence", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
    RECOVERTIME = {"key":"recoverTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
    CLEARTIME = {"key":"clearTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
    DETAIL = {"key":"detail", "type":restDataType.DataType.DATA_TYPE_STRING}
    SOURCETYPE = {"key":"sourceType", "type":restDataType.DataType.DATA_TYPE_STRING}
    CLEARNAME = {"key":"clearName", "type":restDataType.DataType.DATA_TYPE_STRING}
    ROOM = {"key":"room", "type":restDataType.DataType.DATA_TYPE_STRING}
    LOCATION = {"key":"location", "type":restDataType.DataType.DATA_TYPE_STRING}
    STARTTIME = {"key":"startTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
    CONFIRMTIME = {"key":"confirmTime", "type":restDataType.DataType.DATA_TYPE_U64LONG_TYPE}
    POSITION = {"key":"position", "type":restDataType.DataType.DATA_TYPE_STRING}
    ALARMOBJTYPE = {"key":"alarmObjType", "type":restDataType.DataType.DATA_TYPE_STRING}
    TYPE = {"key":"type", "type":restDataType.DataType.DATA_TYPE_ENUM}
    NAME = {"key":"name", "type":restDataType.DataType.DATA_TYPE_STRING}

class OperationLog():
    OPER_TYPE = {"key":"operType", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}
    FILE_TYPE = {"key":"fileType", "type":restDataType.DataType.DATA_TYPE_ENUM}
    FILE_NAME = {"key":"fileName", "type":restDataType.DataType.DATA_TYPE_STRING}
    RETURN_VALUE = {"key":"retValue", "type":restDataType.DataType.DATA_TYPE_UNSIGN_32INT}
    NODE_ID = {"key":"nodeId", "type":restDataType.DataType.DATA_TYPE_STRING}

class ExpandEvaluaCheck():
    TYPE = {"key":"TYPE", "type":restDataType.DataType.DATA_TYPE_UNSIGN_INT}
    RET_CODE = {"key":"expandEvaluationRet", "type":restDataType.DataType.DATA_TYPE_STRING}
    SHOW_DATA = {"key":"expandEvaluationShowData", "type":restDataType.DataType.DATA_TYPE_STRING}

##--------对象URI配置-------                       
#单个查询，批量查询和修改的对象
class OBJ():

    SYSTEM = "system/"
    ENCLOSURE = "enclosure"
    CONTROLLER = "controller"
    BAY = "bay"
    EXPANSION_BOARD = "expboard"
    INTERFACE_MODULE = "intf_module"
    DISK = "disk"
    FAN = "fan"
    POWER = "power"
    BACKUP_POWER = "backup_power"
    ETH_PORT = "eth_port"
    PCIE_PORT = "pcie_port"
    SAS_PORT = "sas_port"
    FC_PORT = "fc_port"
    FCoE_PORT = "FCoE_PORT"
    IB_PORT = "ib_port"
    REPLICATIONPAIR = "REPLICATIONPAIR"
    IBC = "check_ibc_password_changed"
    CONTROLLER_IO = "backend_concurrent"
    SFP_OPTICAL_TRANSCEIVER = "SFP_OPTICAL_TRANSCEIVER"
    FC_LINK = "FC_LINK"
    iSCSI_LINK = "iSCSI_LINK"
    EXPORT_DB_CONFIG = "export_db_config"         #导出配置文件
    CLEAR_EXPORT_DATA = "clear_export_data"       #清除导出数据
    VM = "vm"   #虚拟机
    QUORUM_SERVER_LINK = "QuorumServerLink"  #仲裁服务器链路
    EXPANSION_EVAL = "expansion_evaluation"  #Dorado扩容评估，用于V3R2C00及以后版本
    EXPANSION_DISKDOMAIN = "diskpool"  #Dorado 扩容硬盘域，用于V3R2C00及以后版本

#特殊REST接口，无法在OBJ中实现的接口
class SpecialUri():
    QUERY_USER_INFO = "user" #查询用户信息
    QUERY_CURRENT_ALARM_INFO = "alarm/currentalarm"        #查询系统当前告警列表信息
    COUNT_CURRENT_ALARMS = "alarm/currentalarm/count"      #查询系统当前告警列表信息
    QUERY_HISTORICAL_ALARMS_INFO = "alarm/historyalarm"    #查询历史告警和事件
    COUNT_HISTORICA_ALARMS = "alarm/historyalarm/count"    #查询历史告警和事件个数
    SYNC_REPLICATION_PAIR = "REPLICATIONPAIR/sync"         #同步远程复制Pair
    ACTIVELICENSE = "license/activelicense"                #查询license使用情况
    OFFLINE_CONTROLLER = "offline_controller"              #离线控制器
    OFFLINE_CONTROLLER_SIGNLE = "safe_power_off_system"
    INTERNAL_DEVICE_INFO = "scale_out/get_internal_device_info"  # 查询内部产品型号
    
class InternalDeviceInfo():
    '''
    Description: Dorado6000 C21增强版内部设备信息
    '''
    INTERNAL_PRODUCT_MODEL = {"key": "internalProductModel", "type": restDataType.DATA_TYPE_STRING}  # 内部产品型号
    CPU_MODEL_INFO = {"key": "cpuModelInfo", "type": restDataType.DATA_TYPE_STRING}  #  CPU型号信息
    CPU_NUMBER = {"key": "cpuNumber", "type": restDataType.DATA_TYPE_UNSIGN_INT}  # CPU核数量

##-----------REST框架使用配置-----------     
class RestMethod():
    GET = 0     #请求主要用于查询存储管理对象
    POST = 1    #请求主要用于创建存储管理对象
    PUT = 2     #请求主要用于修改存储管理对象属性和对管理对象的特殊操作
    DELETE = 3  #主要用于删除存储管理对象   

##-----------对象属性的枚举类型-----------
class HealthStatusEnum:
    UNKNOWN = 0
    NORMAL = 1
    FAULT = 2
    PRE_FAIL = 3
    PART_BROKEN = 4
    DEGRADE = 5
    HAS_BAD_BLOCK = 6
    HAS_ERR_CODE = 7
    CONSISTENT = 8
    INCONSISTENT = 9
    BUSY = 10
    POWER_NO_INPUT = 11
    POWER_NOT_ENOUGH = 12
    SINGLE_LINK_FAULT = 13
    INVALID = 14
    WRITE_PROTECT = 15

class RunningStatusEnum:
    UNKNOWN = 0
    NORMAL = 1
    RUNNING = 2
    NOT_RUNNING = 3
    NOT_EXIST = 4
    HIGH_TEMPERATURE_SLEEP = 5
    STARTING = 6
    POWER_FAILURE_PROTECTING = 7
    SLEEPING = 8
    SPINGUP = 9
    LINK_UP = 10
    LINK_DOWN = 11
    POWER_ON = 12
    POWER_OFF = 13
    PRE_COPY = 14
    COPYBACK = 15
    RECONSTRUCTION = 16
    EXPANSION = 17
    NOT_FORMAT = 18
    FORMATTING = 19
    UNMAPPING = 20
    INITIAL_SYNCHRONIZING = 21
    CONSISTENT = 22
    SYNCHRONIZING = 23
    SYNCHRONIZED = 24
    NOT_SYNCHRONIZED = 25
    SPLIT = 26
    ONLINE = 27
    OFFLINE = 28
    LOCKED = 29
    ENABLE = 30
    DISABLED = 31
    LEVELING = 32
    TO_BE_RECOVERD = 33
    INTERRUPTED = 34
    INVALID = 35
    NOSTART = 36
    QUEUING = 37
    STOP = 38
    COPYING = 39
    COMPLETED = 40
    PAUSE = 41
    REVSYNCHRONIZING = 42
    ACTIVATED = 43
    ROLLBACK = 44
    INACTIVATED = 45
    IDLE = 46
    POWERING_OFF = 47
    CHARGING = 48
    CHARGED = 49
    DISCHARGING = 50
    UPGRADING = 51
    POWER_LOST = 52
    INITIALIZING = 53
    APPLY_CONFIG_CHANGE = 54
    ONLINE_DISABLE = 55
    OFFLINE_DISABLE = 56
    ONLINE_FROZEN = 57
    OFFLINE_FROZEN = 58
    CLOSED = 59
    REMOVING = 60
    INSERVICE = 61
    OUTOFSERVICE = 62
    ERASEMENT_RUNNING_NORMAL = 63
    ERASEMENT_RUNNING_FAIL = 64
    ERASEMENT_RUNNING_SUCCESS = 65
    SUCCESS = 66
    FAILED = 67
    WAITING = 68
    CANCELLING = 69
    CANCELLED = 70
    RUNNING_PREPARE_SYNC = 71
    RUNNING_SYNCHRONINING = 72
    RUNNING_SYNC_FAILED = 73
    MIGRATION_FAULT = 74
    MiGRATING = 75
    MIGRATION_COMPLETED = 76

class LicenseFeatureEnum:
    HYPER_REPLICATION = 24
    HYPER_METRO = 63


class IbcEnum():
    PWD_CHANGED = "true"
    KEYPAIR_CHANGED = "true"

class EthPortLogicTypeEnum():
    HOST = 0        #主机端口/业务端口
    EXP = 1         #级联端口
    MNGT = 2        #管理端口
    INNER = 3       #内部端口
    MAINTENANCE = 4     #维护端口
    MNGT_SRV = 5        #管理/业务混合口
    MAINTENANCE_SRV = 6 #维护/业务混合口
    BACKUP_MGR = 7      #备份管理网口
    PRODUCT_STORAGE = 8 #生产存储网口
    BACKUP_STORAGE = 9  #备份存储网口
    ETH_NOT_CONFIG = 10 #未配置角色网口
    IP_SCALE_OUT = 11   #用于IP Scale-Out的网口

class CofigModelEnum():
    SINGLE_CTRL = 0 #单控
    MULTI_CTRL = 1  #多控

class LightStatusEnum():
    ON = 1
    OFF = 2

class IpTypeEnum():
    IPV4 = 1
    IPV6 = 2

class EncLogicTypeEnum():
    EXP = 0   #级联框（硬盘框）
    CTRL = 1  #控制框
    DSW = 2   #数据交换机
    MSW = 3   #管理交换机
    SVP = 4   #管理服务器

class DataTypeEnum():
    CONFIG_DATA = 3 #配置数据

class ExportTypeEnum():
    MEMORY = 0 #从内存导出
    DISK = 1 #从硬盘导出

class DiskEnum():
    DISK0 = "0"
    DISK1 = "1"

class RecoveryPolicyEnum:
    AUTO = 1
    MANUALLY = 2

class OperationTypeEnum():
    EXPORT = 1  #导出

class FileIdEnum():
    CONFIG_DATA = 50    #配置数据文件

class OperationResultEnum():
    SUCCESS = 0
    FAIL = 1

class ParentTypeEnum():
    ENCLOSURE = 206#框/Enclosure
    CONTROLLER = 207#控制器/Controller
    EXPBOARD = 208#级联板/Expand Board
    INTF_MODULE = 209#接口模块/Interface Module

class EnlosureModelEnum():
    CTRL_BMC = 0    #BMC控制框
    CTRL_SAS2U_12 = 1   #2U SAS 12盘主控框
    CTRL_SAS2U_24 = 2   #2U SAS 24盘主控框 
    EXPSAS2U_12 = 16    #2U SAS 12盘级联框
    EXPSAS2U_24 = 17    #2U SAS 24盘级联框
    EXPSAS4U = 18   #4U SAS 24盘级联框
    EXPFC = 19  #4U FC 24盘级联框
    DSW_PCIe1U = 20 #1U PCIe数据交换机
    EXPSAS4U_75 = 21    #4U SAS 75盘级联框
    SVP = 22    #SVP
    CTRL_6U = 97    #6U 4控独立机头
    CTRL_3U = 96    #3U 2控独立机头
    EXPSAS2U_25 = 24    #2U SAS 25盘2.5寸磁盘框
    EXPSAS4U_24_NEW = 25    #4U SAS 24盘3.5寸磁盘框（新）
    CTRL_12GSAS_2U25_EAR = 26   #2U 12GSAS 25盘主控框
    CTRL_12GSAS_2U12_EAR = 23   #2U 12GSAS 12盘主控框
    ARM_2U_12 = 37  #2U 12GSAS 12盘ARM主控框/
    ARM_2U_25 = 38  #2U 12GSAS 25盘ARM主控框/
    EXP_12G_SAS_4U_75 = 39     #12G 4U SAS 75盘 3.5寸级联框
    ENCLOSURE_MODEL_EXPSAS2U_25_12GLINK = 65 #2U SSD 25盘2.5寸级联框/
    CTRL_12GSAS_2U25_EAR_12GLINK = 40, #2U 12G SAS 25盘主控框     

class ObjectEnum():
    FC_PORT = 212   #FC端口
    ETH_PORT = 213  #以太网口
    SAS_PORT = 214  #SAS端口
    FCoE_PORT = 252 #FCoE端口
    IB_PORT = 16500 #IB端口

class NetModeEnum():
    UNKNOWN = 0 #无效值
    DIRECT = 1  #直连组网
    SWITCH = 2  #交换机组网
    DIRECT2SWITCH = 3   #直连组网转交换机组网

class QuorumLinkCheckEnum():
    CONTROLLER = 0       #控制器
    IP_SCALEOUT_INTF = 1 #IPScaleOut接口卡
    PCIE_INTF = 2        #PCIe接口卡
    FRONTEND_INTF = 3    #前端接口卡
    MANAGE_BOARD = 4     #管理模块
    FIBRE_MODULE = 5     #光模块
    CABLE_FRONTEND = 6   #前端线缆

