﻿# -*- coding: UTF-8 -*-
import time
from frameone.util import jsonUtil
from cbb.frame.util.common import wrapAllExceptionLogged


class RestConnection():
    REST_BASE_URI = r"https://%s:%s/deviceManager/rest/%s/"
    REST_PORT_DEFAULT = 8088
    _instance = None
       
    def __new__(cls, *args, **kwargs):
        if cls._instance is None:
            cls._instance = super(RestConnection, cls).__new__(cls, *args, **kwargs)
        return cls._instance
    
    def __init__(self, devObj, restPort = REST_PORT_DEFAULT):
        self.devNode = devObj.get("devNode")
        self.logger = devObj.get("logger")
        self.restConnectionManager = devObj.get("restMamager")
        self.ip = devObj.get("devIp")
        self.restPort = restPort
        self.devSN = self.devNode.getDeviceSerialNumber()
        self.baseUri = self.REST_BASE_URI % (self.getUrlIp(self.ip), str(restPort), str(self.devSN))

    @wrapAllExceptionLogged(logger=None)
    def close(self, restConnection):
        self.restConnectionManager.releaseConn(restConnection)

    @wrapAllExceptionLogged(logger=None)
    def getConnection(self):
        restConnection = None
        for _ in range(0,3):
            restConnection = self.restConnectionManager.getRestConnection(self.devNode)
            if restConnection:
                break
        return restConnection

    @wrapAllExceptionLogged(logger=None)
    def closeCon(self):
        """释放连接接口。

        :return:
        """
        self.restConnectionManager.releaseConn(self.devNode)
    
    def getBaseUri(self):
        return self.baseUri
    
    def checkConnetionNormal(self):
        uri = self.baseUri + "system/"
        paramsStr = ""
        try:
            records = jsonUtil.jsonStr2Dict(self._rest.execGet(uri, paramsStr).getContent())
            data = records["data"]
            return "HEALTHSTATUS" in data.keys()
        except:
            return False
    
    def getUrlIp(self, ip):
        if ":" in str(ip):
            return "[%s]" % str(ip)
        return str(ip)
