# -*- coding: UTF-8 -*-
import os
import time
import ast
from frameone.base import config
from frameone.rest import restData
from frameone.rest import restDataType
from frameone.util import jsonUtil
from com.huawei.ism.tlv.lang import UnsignedInt64  # @UnresolvedImport
from com.huawei.ism.exception import IsmException
from java.lang import Exception as JException

class CommonRest():
    REST_CAN_NOT_EXECUTE = "1077936891"  # 命令执行失败

    @staticmethod
    def convertRecord2Dict(jsonRecord):
        """
        @summary: 将Json格式的回显转换成字典
        @param jsonRecord: REST返回的数据. 
        """
        return jsonUtil.jsonStr2Dict(jsonRecord)

    @staticmethod
    def getParamsJsonStr(paramDict):
        """
        @summary: 将参数字典转化为json字符串
        @param paramDict: 参数字典. 
        """
        if paramDict is None or len(paramDict) == 0:
            return ""
        return jsonUtil.dict2JsonStr(paramDict)

    @staticmethod
    def getRecordValue(data, field):
        """
        @summary: 获取指定属性Key值转化后成指定类型并返回
        @param data: REST返回的单个DATA数据（类型为字典）. 
        @param field: 包含 key, type。其中key是DATA中的属性。TYPE是该属性的值。 
        """
        fieldKey = field.get("key")
        fieldType = field.get("type")
        paramValue = data.get(fieldKey, "")

        if fieldType == restDataType.DataType.DATA_TYPE_UNSIGN_INT or \
                        fieldType == restDataType.DataType.DATA_TYPE_SIGN_INT or \
                        fieldType == restDataType.DataType.DATA_TYPE_BOOL or \
                        fieldType == restDataType.DataType.DATA_TYPE_ENUM or \
                        fieldType == restDataType.DataType.DATA_TYPE_TIME:
            return int(paramValue)
        
        elif fieldType == restDataType.DATA_TYPE_ARRAY:
            return ast.literal_eval(paramValue)
        elif fieldType == restDataType.DataType.DATA_TYPE_U64LONG_TYPE:
            return UnsignedInt64(paramValue)
        else:
            return unicode(paramValue)

    @staticmethod
    def getData(record):
        """
        @summary: 获取回显中的data数据
        @param record: rest回显
        @return : 返回data数据
        """
        if record is None or len(record) == 0:
            return None

        return record.get("data", None)

    @staticmethod
    def getErrInfo(record):
        """
        @summary: 获取回显中的error数据
        @param record: rest回显
        @return : 返回error数据
        """
        if record is None or len(record) == 0:
            return None

        return record.get("error", None)

    @staticmethod
    def getUriParamDict(objUri, uriParams = []):
        """
        @summary: 获取指定属性Key值转化后成指定类型并返回
        @param data: REST返回的单个DATA数据（类型为字典）. 
        @param field: 包含 key, type。其中key是DATA中的属性。TYPE是该属性的值。 
        """
        uriParamDict = {}
        uriParamDict["objUri"] = objUri
        uriParamDict["paramList"] = uriParams
        return uriParamDict

    @staticmethod
    def getRestUri(baseUri, objUri, uriParams = []):
        """
        @summary: 获取REST接口使用的uri连接
        @param objUri: objUri为各对象差异的URI
        """
        if len(uriParams) > 0:
            objUri = objUri + '/' + '/'.join(uriParams)
        return os.path.join(baseUri, objUri)

class CommonRestService():
    @staticmethod
    def get4Page(rest, uri):
        allDatas = []
        index = 0
        while True:
            range = "range=[%s-%s]" % (index, index + 100)
            rangeUri = CommonRestService.addRangeUri(uri, range)
            datas = CommonRestService.get4Big(rest, rangeUri)
            allDatas.extend(datas)
            if len(datas) < 100:
                break
            index = index + 100
        return allDatas
    
    @staticmethod
    def addRangeUri(uri, str):
        if "?" in uri:
            countUri = uri.replace("?", "?" + str + "&")
        else:
            countUri = uri + "?" + str
        return countUri

    @staticmethod
    def get4Big(rest, uri):
        url = rest.getBaseUri() + uri
        restConn = rest.getConnection()

        try:
            responseDict = restConn.execGetForBig(url, "")
            errInfo = CommonRest.getErrInfo(responseDict)
            errCode = CommonRest.getRecordValue(errInfo, restData.ErrorInfo.CODE)
            if errCode == "0":
                data = CommonRest.getData(responseDict)
                if data is None:
                    data = []
                return data
            else:
                description = CommonRest.getRecordValue(errInfo, restData.ErrorInfo.DESCRIPTION)
                raise IsmException(int(errCode), description)
        except IsmException, e:
            raise e
        except JException, e:
            raise IsmException(int(CommonRest.REST_CAN_NOT_EXECUTE), e)
        finally:
            rest.close(restConn)

    @staticmethod
    def put(rest, uri, paramDict):
        url = rest.getBaseUri() + uri
        restConn = rest.getConnection()
        
        try:
            paramJson = CommonRest.getParamsJsonStr(paramDict)
            responseStr = restConn.execPut(url, paramJson).getContent()
            responseDict = CommonRest.convertRecord2Dict(responseStr)
            errInfo = CommonRest.getErrInfo(responseDict)
            errCode = CommonRest.getRecordValue(errInfo, restData.ErrorInfo.CODE)
            if errCode == "0":
                data = CommonRest.getData(responseDict)
                return data
            else:
                description = CommonRest.getRecordValue(errInfo, restData.ErrorInfo.DESCRIPTION)
                raise IsmException(int(errCode), description)
        except IsmException, e:
            raise e
        except JException, e:
            raise IsmException(int(CommonRest.REST_CAN_NOT_EXECUTE), e)
        finally:
            rest.close(restConn)

