# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import stat
import os
import time

import com.huawei.ism.tool.infocollect.service.CollectHistoryPerformanceManager as CollectHistoryPerformanceManager

COMPLETE_PROGRESS = "100"
RUNNING = "RUNNING"
SUCCESS_STATUS = "SUCCESS"
WAITING = "WAITING"
CHECK_TIME = 1
RUNNING_STATUS = [WAITING, RUNNING]
WAITING_COMPRESS_TIME = 10


def collect_history_performance(data_dict):
    dev_node = data_dict.get("devNode")
    export_path = get_hisperformance_export_path(data_dict)
    refresh_process(data_dict, 1)
    history_perf_manager = CollectHistoryPerformanceManager(dev_node, export_path, data_dict.get("progressObserver"))
    history_perf_manager.doCollect()
    data_dict["py_detail"] = history_perf_manager.getErrMsg()
    data_dict["HistoryPerformanceFile"] = export_path
    add_permission(export_path)
    time.sleep(WAITING_COMPRESS_TIME)
    return (
        get_py_result(
            str(history_perf_manager.getTaskResult()).upper() == SUCCESS_STATUS, history_perf_manager.getErrMsg(),
            export_path
        ),
        "",
    )


def is_no_history_performance_file_failed(err_msg, export_path):
    if u"没有文件" in err_msg or "No File" in err_msg:
        flags = os.O_WRONLY | os.O_CREAT | os.O_EXCL
        modes = stat.S_IWUSR | stat.S_IRUSR
        with os.fdopen(os.open(os.path.join(export_path, "error_info.txt"), flags, modes), 'w') as fout:
            fout.write(err_msg)
        return True
    return False


def get_py_result(status, err_msg, export_path):
    return status or (not status and is_no_history_performance_file_failed(err_msg, export_path))


def refresh_process(dev_obj, percent_number):
    """
    设置信息收集当前进度
    :param dev_obj: 上下文
    :param percent_number: 百分比
    :return:
    """
    observer = dev_obj.get("progressObserver")
    cur = get_current_progress(dev_obj)
    set_num = int(percent_number)
    if set_num < cur:
        return
    if observer is not None:
        if dev_obj.get("concurrent") is True:
            observer.updateAnothorProgress(set_num, None)
        else:
            observer.updateProgress(set_num, None)


def get_current_progress(dev_obj):
    """
    获取信息收集当前进度
    :param dev_obj: 上下文
    :return: 进度
    """
    observer = dev_obj.get("progressObserver")
    if observer is not None and dev_obj.get("concurrent") is True:
        return observer.getProgress()
    if observer is not None:
        return observer.getCurrentProgress()
    return 0


def get_hisperformance_export_path(dev_obj):
    """
    获取历史性能数据存放路径
    :param dev_obj: 上下文
    :return: 存放路径
    """
    logger = dev_obj["logger"]
    # 收集到得信息存放的本地路径
    collect_local_path = "collect_info_local_path"
    # T 系列收集路径
    t_collect_local_path = "collectRetDir"
    # 历史性能数据存放路径
    export_type_hisperformance_data = "History_Performance_Data"
    local_dir = dev_obj.get(collect_local_path)
    if not local_dir:
        local_dir = dev_obj.get(t_collect_local_path)
    local_dir = os.path.join(local_dir, export_type_hisperformance_data)
    if not os.path.exists(local_dir):
        os.makedirs(local_dir)
    return local_dir


def add_permission(input_path):
    """
    递归增加目标目录下所有权限
    :param input_path:
    :return:
    """
    if not os.path.exists(input_path):
        return
    os.chmod(input_path, stat.S_IRWXU)
    
    if os.path.isdir(input_path):
        file_dir_list = os.listdir(input_path)
        # 开始解压缩迭代及写入硬盘信息
        for file_dir in file_dir_list:
            file_path = os.path.join(input_path, file_dir)
            add_permission(file_path)
