# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import os
import time

from com.huawei.ism.tool.infocollect.util import InfoCollectUtil as info_collect_util

# 等待5秒操作系统响应
WAITING_COMPRESS_TIME = 5
DURATION_START_TIME = "durationStartTime"
TOTAL_DURATION_START_TIME = "Total duration"


def copy_log_and_ini_to_collect_ret_dir(env, local_dir=None):
    """
    拷贝日志和toolini到压缩包目录
    :param env: 上下文
    :param local_dir: 压缩包目录，如果
    :return:
    """

    info_collect_util.writeTime(
        env.get(DURATION_START_TIME), TOTAL_DURATION_START_TIME, env.get("devNode").getIp()
    )
    if local_dir:
        info_collect_util.copyDirToFile(env.get("devNode"), local_dir)
    else:
        info_collect_util.copyDirToFile(
            env.get("devNode"), os.path.join(env.get("collectRetDir"), env.get("collectRetFileName"))
        )

    time.sleep(WAITING_COMPRESS_TIME)
