# -*- coding: UTF-8 -*-
import os
import traceback

from frameone.rest import restData
from frameone.rest.restFactory import RestConnection
from cbb.frame.util.common import wrapAllExceptionLogged

SCRIPT_DEF_devObj = "SCRIPT_DEF_devObj"
REST_CONNECTION = "REST_CONNECTION"

def getLang(devObj):
    '''
    @summary: 获取语言
    @param devObj: 上下文对象
    '''
    return devObj.get("lang")


def getDevNode(devObj):
    '''
    @summary: 获取上下文对象中dev对象
    @param devObj: 上下文对象
    '''
    return devObj.get("devNode")
    
def getScriptDefDict(devObj):
    '''
    @summary: 获取上下文自定义字典
    @param devObj: 上下文对象
    '''
    if isinstance(devObj, dict):
        if not devObj.has_key(SCRIPT_DEF_devObj):
            devObj.setdefault(SCRIPT_DEF_devObj, {})
    else:
        if not devObj.containsKey(SCRIPT_DEF_devObj):
            devObj.put(SCRIPT_DEF_devObj, {})
    return devObj.get(SCRIPT_DEF_devObj)

#------------------NEW Frame---------------
def getItem(devObj, key):
    '''
    @summary: 获取自定义字典中的项
    @param devObj: 上下文对象
    @param key: 项的键
    '''
    scriptDefDict = getScriptDefDict(devObj)
    return scriptDefDict.get(key, None)

def setItem(devObj, key, value):
    '''
    @summary: 往自定义字典中添加项
    @param devObj: 上下文对象
    @param key: 添加项的键
    @param value: 添加项的值
    '''
    scriptDefDict = getScriptDefDict(devObj)
    scriptDefDict[key] = value
    
    if isinstance(devObj, dict):
        devObj[SCRIPT_DEF_devObj] = scriptDefDict.copy()
    else:
        devObj.put(SCRIPT_DEF_devObj, scriptDefDict.copy())
    return

def initRestConnection(devObj):
    '''
    @summary: 初始化rest连接
    @param devObj: 上下文对象
    '''
    rest = RestConnection(devObj)
    setItem(devObj, REST_CONNECTION, rest)
    return

def getRest(devObj):
    '''
    @summary: 获取rest连接
    @param devObj: 上下文对象
    '''
    rest = getItem(devObj, REST_CONNECTION)
    if rest is None:
        initRestConnection(devObj)
        rest = getItem(devObj, REST_CONNECTION)
          
    return rest


@wrapAllExceptionLogged(logger=None)
def releaseRest(context):
    """释放 Rest 连接。

    :param context:
    :return:
    """
    restConn = getItem(context, REST_CONNECTION)
    if restConn is None:
        return

    # noinspection PyBroadException
    restConn.closeCon()


def getIp(devObj):
    '''
    @summary: 获取当前工具连接的ip
    @param devObj: 上下文对象
    '''
    return devObj.get("devIp")


def getCurVersion(devObj):
    '''
    @summary: 获取系统当前版本
    @param devObj: 上下文对象
    '''
    return getDevNode(devObj).getProductVersion()

def getDevType(devObj):
    '''
    @summary: 获取设备类型
    '''
    return getDevNode(devObj).getDeviceType()


def getDevSN(devObj):
    '''
    @summary: 获取设备序列号Serial Number
    '''
    return getDevNode(devObj).getDeviceSerialNumber()

def getLogger(devObj):
    '''
    @summary: 获取日志打印对象
    @param devObj: 上下文对象
    '''
    return devObj.get("logger")


def getSFTP(devObj):
    '''
    @summary: 获取工具与阵列的SFTP连接对象
    @param devObj: 上下文对象
    '''
    return devObj.get("SFTP")
