# coding=utf-8

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import re
import time

CLI = None
LANGUAGE = None
IP_ADDR = None


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """

    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    name = check_and_get_result(get_device_name())
    if "HP-UX".lower() in name.lower():
        name = name
        dev_type = check_and_get_result(get_dev_type())
        sn = check_and_get_result(get_serial_number())
        version = check_and_get_result(get_product_version())
    else:
        name = "Not HP-UX"
        dev_type = ""
        sn = ""
        version = ""

    return {"name": name, "type":dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    """

    :rtype : object
    """
    return str(result)


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    op_sys_info = CLI.execCmdWithTimout("machinfo|egrep 'Release|release  '", 60)
    dev_type = re.split(':|=', op_sys_info)[1].strip()
    dev_type = dev_type.splitlines()[0]
    if '' != dev_type:
        fun_flag = CHECK_PASS
        if dev_type == 'machinfo':
            dev_type = getDevTypeByUname()
    return fun_flag, dev_type, fun_err_msg


def getDevTypeByUname():
    type = ''
    unameRet = CLI.execCmdWithTimout("uname -a", 60)
    osLst = []
    if unameRet:
        osLst = unameRet.splitlines()
    else:
        return type

    for line in osLst:
        if 'b.11' in line.lower():
            lst = line.split()
            if len(lst) > 2:
                type = lst[2]
                return type
    return type


# need to explain this function.
def fetch_ubuntu_base_info():
    cli_ret = CLI.execCmdWithTimout("cat /etc/issue", 60)
    cli_ret_list = cli_ret.splitlines()
    cli_ret_lists = cli_ret_list[1].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    cli_ret = CLI.execCmdWithTimout("uname -a", 60)
    device_name = cli_ret.splitlines()[1].split()[0]

    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    cli_flag = CHECK_FAIL
    fun_err_msg = ''
    op_sys_ver = CLI.execCmdWithTimout("machinfo|egrep 'Version|version  '", 60)
    product_version = re.split(':|=', op_sys_ver)[1].strip()
    product_version = product_version.splitlines()[0]
    if '' != product_version:
        fun_flag = CHECK_PASS
    return cli_flag, product_version, fun_err_msg

def get_time_str():
    t = time.strftime('%Y-%m-%d-%H-%M-%S', time.localtime(time.time()))
    t = t.replace('-', '')
    return t

#need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    lan_num = CLI.execCmdWithTimout("netstat -in|grep " + IP_ADDR + " |awk '{print $1}'", 60)
    mac_address = CLI.execCmdWithTimout("lanscan|grep " + lan_num.splitlines()[1], 60)
    if(len(mac_address) > 1):
        serial_number = mac_address.splitlines()[1].split()[1][2:] + IP_ADDR
    serial_number = get_time_str() + IP_ADDR

    if '' != serial_number:
        fun_flag = CHECK_PASS
    else:
        serial_number = 'SN' + get_time_str() + IP_ADDR

    serial_number = serial_number.replace('.', '')

    return fun_flag, serial_number, fun_err_msg
