﻿# coding=utf-8
from com.huawei.ism.tool.base.utils import SceneUtils

"""检查结果返回值"""
CHECK_PASS = 0
CHECK_FAIL = 1

import time
import re

CLI = None
LANGUAGE = None
IP_ADDR = None

# 系统命令执行结果，全局变量保存（避免多次查询）
G_SystemInfo = ""


def execute(context):
    """
    Function name      : getdev_type
    Function describe  : 添加主机获取信息
    Input              : context
    Return             : flag, cliRet, errMsg
    """
    # 给全局变量赋初始值，按照要求传递上下文进去。
    global CLI
    CLI = context.get("SSH")
    CLI.execCmd("PS1='\\u:\\h:~$'")
    global LANGUAGE
    LANGUAGE = "en"
    global IP_ADDR
    IP_ADDR = context.get("dev").getIp()

    name = check_and_get_result(get_device_name())
    if name == "Linux":
        global G_SystemInfo
        G_SystemInfo = CLI.execCmd("cat /etc/*-release")
        if G_SystemInfo.find('VMware') < 0:
            dev_type = check_and_get_result(get_dev_type())
            if (dev_type.startswith('Rocky ')):
                sn = check_and_get_result(get_Rocky_serial_number())
            else:
                sn = check_and_get_result(get_serial_number())
            version = check_and_get_result(get_product_version())
        else:
            name = "VMware"
            dev_type = ""
            sn = ""
            version = ""
    else:
        dev_type = ""
        sn = ""
        version = ""
    if SceneUtils.isDpaInspect():
        name = str(get_dpa_host_name(name))
    return {"name": name, "type": dev_type, "sn": sn, "version": version}


# 取中间一个有效值
def check_and_get_result((fun_flag, result, fun_err_msg)):
    return str(result)


def get_dpa_host_name(name):
    result = CLI.execCmdWithTimout("hostname", 60)
    lines = result.splitlines()
    if len(lines) >= 3:
        return "\n".join(lines[1:-1]).strip()
    else:
        return name


def get_dev_type():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统类型
    Input              : 
    Return             : funFlag, dev_type, funErrMsg
    """
    fun_flag = CHECK_FAIL
    dev_type = ''
    fun_err_msg = ''
    if SceneUtils.isDpaInspect():
        return CHECK_PASS, "Linux", ""
    op_sys_info = CLI.execCmdWithTimout("ls /etc/| grep release", 60)
    if len(op_sys_info.splitlines()) > 2:
        op_sys_info = G_SystemInfo
        tem_line = op_sys_info.splitlines()
        if 'Asianux' in op_sys_info:
            for i in range(0, len(tem_line)):
                #####################     Suse Area    #####################
                if 'Asianux' in tem_line[i]:
                    dev_type = 'Asianux ' + tem_line[i].split()[2]
                    fun_flag = CHECK_PASS
                    break
        elif 'Debian' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Debian' in tem_line[i]:
                    dev_type = 'Debian ' + tem_line[i].split()[2]
                    fun_flag = CHECK_PASS
                    break
        elif 'Oracle Linux' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Oracle Linux' in tem_line[i]:
                    dev_type = 'Oracle Linux ' + tem_line[i].split()[4]
                    fun_flag = CHECK_PASS
                    break
        #####################   UVP,must judge before SUSE   #####################
        elif 'UVP ' in op_sys_info:
            version = get_uvp_vision()
            fun_flag = CHECK_PASS
            dev_type = 'UVP %s' % (version)
        #####################   SUSE    #####################
        elif 'SUSE' in op_sys_info:
            version = "0"
            patchVersion = "0"
            for i in range(0, len(tem_line)):
                if 'SUSE' in tem_line[i]:
                    if tem_line[i + 1].startswith("VERSION ="):
                        version = tem_line[i + 1].split("=")[1].strip()
                    if tem_line[i + 2].startswith("PATCHLEVEL ="):
                        patchVersion = tem_line[i + 2].split("=")[1].strip()
                    fun_flag = CHECK_PASS
                    break
            if "0" == patchVersion:
                dev_type = 'SUSE %s' % (version)
            else:
                dev_type = 'SUSE %s SP%s' % (version, patchVersion)
        elif 'CentOS' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'CentOS' in tem_line[i]:
                    dev_type = "CentOS " + tem_line[i].split()[2]
                    if dev_type == 'CentOS release':
                        dev_type = "CentOS " + tem_line[i].split()[3]
                    fun_flag = CHECK_PASS
                    break
        elif 'XenServer' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'XenServer' in tem_line[i]:
                    dev_type = "XenServer " + re.split(' |-', tem_line[i])[2];
                    fun_flag = CHECK_PASS
                    break
        #####################   Ubuntu Area    #####################
        elif 'Ubuntu' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Ubuntu' in tem_line[i]:
                    dev_type = fetch_ubuntu_base_info()
                    fun_flag = CHECK_PASS
                    break
        #####################   Kylin  Area    #####################
        elif 'kylin' in op_sys_info.lower():
            # 获取麒麟系统的设备信息
            dev_type = fetch_Kylin_DeviceType()
            if dev_type:
                fun_flag = CHECK_PASS
        #####################   Rocky  Area    #####################
        elif 'Rocky' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Rocky' in tem_line[i]:
                    dev_type = "Rocky " + re.split(' |-', tem_line[i])[1];
                    fun_flag = CHECK_PASS
                    break
        #####################   Red Hat Area    #####################
        elif 'Red Hat' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Red Hat' in tem_line[i] and "=" not in tem_line[i]:
                    dev_type = "Red Hat " + tem_line[i].split()[6]
                    fun_flag = CHECK_PASS
                    break
        #####################   EulerOS Area    #####################
        elif 'EulerOS' in op_sys_info:
            # 获取欧拉系统的设备信息
            dev_type = fetch_EulerOS_DeviceType()
            if dev_type:
                fun_flag = CHECK_PASS
    else:
        op_sys_info = CLI.execCmdWithTimout("cat /etc/issue", 60)
        tem_line = op_sys_info.splitlines()
        if 'Asianux' in op_sys_info:
            for i in range(0, len(tem_line)):
                #####################     Suse Area    #####################
                if 'Asianux' in tem_line[i]:
                    dev_type = 'Asianux ' + tem_line[i].split()[2]
                    fun_flag = CHECK_PASS
                    break
        elif 'Debian' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Debian' in tem_line[i]:
                    dev_type = 'Debian ' + tem_line[i].split()[2]
                    fun_flag = CHECK_PASS
                    break
        elif 'Oracle Linux' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Oracle Linux' in tem_line[i]:
                    dev_type = 'Oracle Linux ' + tem_line[i].split()[4]
                    fun_flag = CHECK_PASS
                    break
        elif 'SUSE' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'SUSE' in tem_line[i]:
                    dev_type = "SUSE " + tem_line[i].split()[6]
                    dev_type_sp = tem_line[i].split()[7]
                    if dev_type_sp.startswith("SP"):
                        dev_type += " " + dev_type_sp
                    fun_flag = CHECK_PASS
                    break
        elif 'CentOS' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'CentOS' in tem_line[i]:
                    dev_type = "CentOS " + tem_line[i].split()[2]
                    if dev_type == 'CentOS release':
                        dev_type = "CentOS " + tem_line[i].split()[3]
                    fun_flag = CHECK_PASS
                    break
        elif 'XenServer' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'XenServer' in tem_line[i]:
                    dev_type = "XenServer " + re.split(' |-', tem_line[i])[2];
                    fun_flag = CHECK_PASS
                    break
        #####################   Ubuntu Area    #####################
        elif 'Ubuntu' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Ubuntu' in tem_line[i]:
                    dev_type = fetch_ubuntu_base_info()
                    fun_flag = CHECK_PASS
                    break
        #####################   Kylin  Area    #####################
        elif 'kylin' in op_sys_info.lower():
            # 获取麒麟系统的设备信息
            dev_type = fetch_Kylin_DeviceType()
            if dev_type:
                fun_flag = CHECK_PASS
        #####################   Rocky  Area    #####################
        elif 'Rocky' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Rocky' in tem_line[i]:
                    dev_type = "Rocky " + re.split(' |-', tem_line[i])[4];
                    fun_flag = CHECK_PASS
                    break
        #####################   Red Hat Area    #####################
        elif 'Red Hat' in op_sys_info:
            for i in range(0, len(tem_line)):
                if 'Red Hat' in tem_line[i]:
                    dev_type = "Red Hat " + tem_line[i].split()[6]
                    fun_flag = CHECK_PASS
                    break
        elif 'Linx ' in op_sys_info:
            for i in range(0, len(tem_line)):
                if tem_line[i].startswith('Linx '):
                    dev_type = "Rocky " + re.split(' |-', tem_line[i])[1];
                    fun_flag = CHECK_PASS
                    break
        #####################   EulerOS Area    #####################
        elif 'EulerOS' in op_sys_info:
            # 获取欧拉系统的设备信息
            dev_type = fetch_EulerOS_DeviceType()
            if dev_type:
                fun_flag = CHECK_PASS

    if dev_type == '':
        dev_type = "Unknown"
    return fun_flag, dev_type, fun_err_msg


def fetch_ubuntu_base_info():
    cli_ret = CLI.execCmdNoLogTimout("cat /etc/issue", 60)
    cli_ret_list = cli_ret.splitlines()
    cli_ret_lists = cli_ret_list[1].split(" ")
    return cli_ret_lists[0] + cli_ret_lists[1]


def fetch_Kylin_DeviceType():
    """
    Function name      : fetch_Kylin_DeviceType
    Function describe  : 获取麒麟系统的设备类型
    Input              : NA
    Return             : dev_type
    """

    dev_type = ""
    cli_ret = CLI.execCmdWithTimout("ls /etc/*release", 60)
    if "/neokylin-release" in cli_ret:
        # 麒麟6及以上版本
        kylinVersionCmdRet = CLI.execCmdWithTimout("cat /etc/neokylin-release", 60)
    elif "/redhat-release" in cli_ret:
        # 麒麟3及之前版本
        kylinVersionCmdRet = CLI.execCmdWithTimout("cat /etc/redhat-release", 60)
    else:
        return dev_type

    subType = "Kylin"
    devInfoLine = kylinVersionCmdRet.splitlines()[1]
    if "neokylin" in devInfoLine.lower():
        subType = "NeoKylin"
    if "Trusted OS" in devInfoLine:
        subType += " Trusted OS"
    fields = devInfoLine.split()
    version = "Unknown"
    for field in fields:
        if re.findall(r'\d+', field):
            version = field.strip()
            break
    dev_type = subType + " " + version
    return dev_type


def fetch_EulerOS_DeviceType():
    """
    Function name      : fetch_EulerOS_DeviceType
    Function describe  : 获取欧拉系统的设备类型
    Input              : NA
    Return             : dev_type
    """

    frame = ""
    subDevVer = ""
    kernelVer = ""
    cli_ret = CLI.execCmdWithTimout("cat /etc/*release", 60)
    lineList = cli_ret.splitlines()
    for line in lineList:
        if line.strip().startswith("EulerOS release"):
            subDevVer = line.replace("EulerOS release", "").strip()
        elif line.strip().startswith("kernelversion="):
            kernelVer = line.split("=")[-1].strip()
        elif line.strip().startswith("localversion="):
            frame = line.split(".")[-1].strip()
        # 数据获取成功
        if frame and subDevVer and kernelVer:
            break

    # 构造设备型号：格式：EulerOS-aarch64 2.0 (SP2) 4.1.38
    dev_type = "EulerOS-" + frame + " " + subDevVer + " " + kernelVer
    return dev_type


def get_uvp_vision():
    cli_ret = CLI.execCmdNoLogTimout("cat /etc/uvp_version", 60)
    cli_ret_list = cli_ret.splitlines()
    for i in range(0, len(cli_ret_list)):
        cliStr = cli_ret_list[i].strip()
        if (cliStr.startswith("uvp_version")):
            return re.split(' |-|=', cliStr)[-1]
    return ""


# need to explain this function.
def get_device_name():
    """
    Function name      : getdev_type
    Function describe  : 获取主机名
    Input              : 
    Return             : fun_flag, deviceName, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    device_name = ''
    cli_ret = CLI.execCmdWithTimout("uname -a", 60)
    for line in cli_ret.splitlines():
        if line.lower().startswith("linux"):
            device_name = "Linux"
            break

    if '' == device_name:
        if LANGUAGE == "zh":
            fun_err_msg = u"获取主机名称失败。"
        else:
            fun_err_msg = "Get hostname failed."
    else:
        fun_flag = CHECK_PASS
    return fun_flag, device_name, fun_err_msg


# need to explain this function.
def get_product_version():
    """
    Function name      : getdev_type
    Function describe  : 获取操作系统版本号
    Input              : 
    Return             : cliFlag, productVersion, fun_err_msg
    """
    cli_flag = CHECK_FAIL
    fun_err_msg = ''
    op_sys_ver = CLI.execCmdWithTimout("cat /proc/version", 60)
    try:
        product_version = re.split(' |-', op_sys_ver.splitlines()[1])[2].strip()
    except:
        product_version = "Unknown"
    return cli_flag, product_version, fun_err_msg


# need to explain this function.
def get_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_str = ""
    mac_address = ''
    if_config_str = CLI.execCmdWithTimout("/sbin/ifconfig", 60)
    ip_link_show = CLI.execCmdWithTimout("/sbin/ip link show", 60)

    if "no such file or directory" in if_config_str.lower():
        if_config_str = CLI.execCmdWithTimout("ifconfig", 60)

    if ip_link_show.find("TOOLKIT_EXE_CMD_FAILED") > 0:
        ip_link_show = CLI.execCmdWithTimout("ip link show", 60)

    temp_list = if_config_str.splitlines()
    temp_list_2 = ip_link_show.splitlines()

    for i in range(0, len(temp_list)):
        if IP_ADDR in temp_list[i]:
            for j in range(i):
                if "HWaddr" in temp_list[i - j]:
                    i = i - j + 1
                    break
            eth_name = temp_list[i - 1].split()[0]
            if eth_name.find(":") >= 0:
                eth_name = eth_name.split(':')[0]

            eth_name = eth_name.split(':')[0]
            for j in range(0, len(temp_list_2)):
                if eth_name in temp_list_2[j]:
                    mac_address = temp_list_2[j + 1].split()[1]
                    break
            mac_arr = mac_address.strip().split(':')
            for mac in mac_arr:
                if (len(mac) == 1):
                    mac_str = "0"
                else:
                    mac_str += mac
            if "0" == mac_str:
                serial_number = IP_ADDR
            else:
                serial_number = mac_str.upper() + IP_ADDR
            fun_flag = CHECK_PASS
            break
    if '' == serial_number:
        serial_number = "SN" + IP_ADDR
        if LANGUAGE == "zh":
            fun_err_msg = u"获取设备版本失败。"
        else:
            fun_err_msg = "Get product version failed."
    serial_number = serial_number.replace('.', '').replace(':', '')

    return fun_flag, serial_number, fun_err_msg


# need to explain this function.
def get_Rocky_serial_number():
    """
    Function name      : getdev_type
    Function describe  : 获取Rocky主机SN号
    Input              : ipStr
    Return             : fun_flag, serialNumber, fun_err_msg
    """
    fun_flag = CHECK_FAIL
    fun_err_msg = ''
    serial_number = ''
    mac_address = ''
    mac_str = ''
    if_config_str = CLI.execCmdNoLogTimout("/sbin/ifconfig", 60)
    ip_link_show = CLI.execCmdNoLogTimout("ip link show", 60)

    if "no such file or directory" in if_config_str.lower():
        if_config_str = CLI.execCmdWithTimout("ifconfig", 60)

    temp_list = if_config_str.splitlines()
    temp_list_2 = ip_link_show.splitlines()

    for i in range(0, len(temp_list)):
        if IP_ADDR in temp_list[i]:
            eth_name = temp_list[i - 1].split()[0]
            if eth_name.find(":") >= 0:
                eth_name = eth_name.split(':')[0]

            eth_name = eth_name.split(':')[0]
            for j in range(0, len(temp_list_2)):
                if eth_name in temp_list_2[j]:
                    mac_address = temp_list_2[j + 1].split()[1]
                    break
            mac_arr = mac_address.strip().split(':')

            for mac in mac_arr:
                if (len(mac) == 1):
                    mac_str = "0"
                else:
                    mac_str += mac
            if "0" == mac_str:
                serial_number = IP_ADDR
            else:
                serial_number = mac_str.upper() + IP_ADDR
            fun_flag = CHECK_PASS
            break
    if '' == serial_number:
        serial_number = "SN" + IP_ADDR
        if LANGUAGE == "zh":
            fun_err_msg = u"获取设备版本失败。"
        else:
            fun_err_msg = "Get product version failed."

    serial_number = serial_number.replace('.', '').replace(':', '')

    return fun_flag, serial_number, fun_err_msg
