/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.reflect.TypeToken;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum JSONUtils {
    INSTANCE;

    private static Gson gson;

    static JsonObject parseToJsonObject(String jsonStr) {
        JsonObject jsonObject = null;
        try {
            jsonObject = JsonParser.parseString(jsonStr).getAsJsonObject();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return jsonObject;
    }

    static JsonArray parseToJsonArray(String jsonStr) {
        JsonArray jsonArray = null;
        try {
            jsonArray = JsonParser.parseString(jsonStr).getAsJsonArray();
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
        return jsonArray;
    }

    static JsonElement parseToJsonElement(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        Object[] parseObject = object;
        if (object instanceof Collection) {
            if (object instanceof List) {
                ArrayList copyList = new ArrayList(object);
                JSONUtils.traverseList(copyList);
                parseObject = copyList;
            } else {
                ArrayList list = new ArrayList();
                list.addAll(object);
                JSONUtils.traverseList(list);
                parseObject = list;
            }
        } else if (object instanceof Map) {
            HashMap var2 = new HashMap((Map)((Object)object));
            JSONUtils.traverseMap(var2);
            parseObject = var2;
        } else if (object.getClass().isArray()) {
            Object[] var3 = (Object[])object;
            Object[] objects = Arrays.copyOf(var3, var3.length);
            JSONUtils.traverseArray(objects);
            parseObject = objects;
        }
        return gson.toJsonTree(parseObject);
    }

    private static void traverseMap(Map map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value == null) continue;
                if (value instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)value;
                    entry.setValue(jsonObject.getMembers());
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    entry.setValue(jsonArray.getMembers());
                    continue;
                }
                if (value instanceof Map) {
                    HashMap varMap = new HashMap((Map)value);
                    JSONUtils.traverseMap(varMap);
                    entry.setValue(varMap);
                    continue;
                }
                if (value instanceof Collection) {
                    if (value instanceof List) {
                        ArrayList copyList = new ArrayList((Collection)value);
                        JSONUtils.traverseList(copyList);
                        entry.setValue(copyList);
                        continue;
                    }
                    ArrayList list = new ArrayList();
                    list.addAll((Collection)value);
                    JSONUtils.traverseList(list);
                    entry.setValue(list);
                    continue;
                }
                if (!value.getClass().isArray()) continue;
                Object[] var3 = (Object[])value;
                Object[] objects = Arrays.copyOf(var3, var3.length);
                JSONUtils.traverseArray(objects);
                entry.setValue(objects);
            }
        }
    }

    private static void traverseList(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object value = list.get(i);
                if (value == null) continue;
                if (value instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)value;
                    list.set(i, jsonObject.getMembers());
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    list.set(i, jsonArray.getMembers());
                    continue;
                }
                if (value instanceof Map) {
                    HashMap map1 = new HashMap((Map)value);
                    JSONUtils.traverseMap(map1);
                    list.set(i, map1);
                    continue;
                }
                if (value instanceof Collection) {
                    if (value instanceof List) {
                        ArrayList copyList = new ArrayList((Collection)value);
                        JSONUtils.traverseList(copyList);
                        list.set(i, copyList);
                        continue;
                    }
                    ArrayList var1 = new ArrayList();
                    var1.addAll((Collection)value);
                    JSONUtils.traverseList(var1);
                    list.set(i, var1);
                    continue;
                }
                if (!value.getClass().isArray()) continue;
                Object[] var3 = (Object[])value;
                Object[] objects = Arrays.copyOf(var3, var3.length);
                JSONUtils.traverseArray(objects);
                list.set(i, objects);
            }
        }
    }

    private static void traverseArray(Object[] objects) {
        if (null != objects) {
            for (int i = 0; i < objects.length; ++i) {
                Object value = objects[i];
                if (value == null) continue;
                if (value instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)value;
                    objects[i] = jsonObject.getMembers();
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)value;
                    objects[i] = jsonArray.getMembers();
                    continue;
                }
                if (value instanceof Map) {
                    HashMap map1 = new HashMap((Map)value);
                    JSONUtils.traverseMap(map1);
                    objects[i] = map1;
                    continue;
                }
                if (value instanceof Collection) {
                    if (value instanceof List) {
                        ArrayList copyList = new ArrayList((Collection)value);
                        JSONUtils.traverseList(copyList);
                        continue;
                    }
                    ArrayList var1 = new ArrayList();
                    var1.addAll((Collection)value);
                    JSONUtils.traverseList(var1);
                    objects[i] = var1;
                    continue;
                }
                if (!value.getClass().isArray()) continue;
                Object[] var3 = (Object[])value;
                Object[] var4 = Arrays.copyOf(var3, var3.length);
                JSONUtils.traverseArray(var4);
                objects[i] = var4;
            }
        }
    }

    Object castJsonElement(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            Number metaNumber = element.getAsNumber();
            if (metaNumber instanceof LazilyParsedNumber) {
                if (metaNumber.toString().contains(".")) {
                    return metaNumber.doubleValue();
                }
                long tempVal = metaNumber.longValue();
                if (tempVal < Integer.MIN_VALUE || tempVal > Integer.MAX_VALUE) {
                    return metaNumber.longValue();
                }
                return metaNumber.intValue();
            }
            return metaNumber;
        }
        if (element.isString()) {
            return element.getAsString();
        }
        return element;
    }

    public static <T> T jsonToBean(String jsonStr, Class<T> type) {
        return gson.fromJson(jsonStr, type);
    }

    public static String toJson(Object object) {
        return gson.toJson(object);
    }

    public static <T> List<T> jsonToList(String jsonStr, Class<T> cls) {
        List list = null;
        list = (List)gson.fromJson(jsonStr, new TypeToken<List<T>>(){}.getType());
        return list;
    }

    public static <T> Map<String, T> jsonToMaps(String jsonStr) {
        Map map = null;
        map = (Map)gson.fromJson(jsonStr, new TypeToken<Map<String, T>>(){}.getType());
        return map;
    }

    public static <T> T toJson(String jsonStr, Class<T> type) {
        try {
            return gson.fromJson(jsonStr, type);
        }
        catch (Exception e) {
            throw new JSONException(e);
        }
    }

    static {
        gson = new Gson();
    }
}

