/*
 * Decompiled with CFR 0.152.
 */
package com.omm.encrypt.kmc;

import com.omm.encrypt.kmc.DSwareKMCApi;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import org.wcc.framework.log.AppLogger;

public class DSwareKMCUtil {
    private static final AppLogger LOGGER = AppLogger.getInstance(DSwareKMCUtil.class);
    private static boolean kMCInitOK = false;

    private static synchronized boolean initOK() {
        if (kMCInitOK) {
            return kMCInitOK;
        }
        LOGGER.info((Object)"DSWARE_KMC_Initialize Start!!!");
        try {
            int ret = DSwareKMCApi.INSTANCE.DSWARE_KMC_Initialize("FSM");
            if (ret != 0) {
                LOGGER.error((Object)("DSWARE_KMC_Initialize failed!!! ret = " + ret));
                throw new Exception();
            }
        }
        catch (Exception e) {
            LOGGER.error("DSWARE_KMC_Initialize exception!", (Throwable)e);
            return false;
        }
        kMCInitOK = true;
        LOGGER.info((Object)"DSWARE_KMC_Initialize successful!!!");
        return kMCInitOK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decrypt(String cipherText, int domainId) {
        String plainText;
        block7: {
            LOGGER.debug((Object)"Enter decrypt(String cipherText, int domainId)");
            DSwareKMCUtil.initOK();
            if (cipherText == null) {
                throw new IllegalArgumentException("The cipher text to decrypt cannot be null.");
            }
            PointerByReference refPlainText = null;
            IntByReference refPlainTextLength = null;
            try {
                refPlainText = new PointerByReference();
                refPlainTextLength = new IntByReference();
                int ret = DSwareKMCApi.INSTANCE.DSWARE_KMC_Decrypt(domainId, cipherText, cipherText.length(), refPlainText, refPlainTextLength);
                if (ret == 0 && null != refPlainText.getValue()) {
                    plainText = refPlainText.getValue().getString(0L);
                    break block7;
                }
                LOGGER.info((Object)("KMC decrypt error, ret = " + ret));
                String string = "";
                return string;
            }
            finally {
                if (null != refPlainText) {
                    DSwareKMCUtil.memoryFree(refPlainText.getPointer());
                }
                if (null != refPlainTextLength) {
                    DSwareKMCUtil.memoryFree(refPlainTextLength.getPointer());
                }
            }
        }
        LOGGER.debug((Object)"End decrypt(String cipherText, int domainId)");
        return plainText;
    }

    private static void memoryFree(Pointer m) {
        if (m != null) {
            long peer = Pointer.nativeValue((Pointer)m);
            Native.free((long)peer);
            Pointer.nativeValue((Pointer)m, (long)0L);
        }
    }
}

