/*
 * Decompiled with CFR 0.152.
 */
package com.omm.encrypt.kmc;

import com.omm.encrypt.kmc.DSwareKMCUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class JKSGeneratorForFSM {
    private static final int ARG_LENGTH = 2;
    private static final String FAILD_RESULT = "Result:-1";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int RETURN_STATUS_ERROR = 1;
    private static final int ARG_DBCONFIG = 0;
    private static final int ARG_TYPE = 1;
    private static final int FSM_ENCRYPT_DOMAINID = 2;

    public static void main(String[] args) {
        if (null == args || 2 != args.length) {
            JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString("args is empty!"));
            return;
        }
        String managerConfigPath = args[0];
        String key = args[1];
        try {
            Properties prop = JKSGeneratorForFSM.loadFromAbsolutePath(managerConfigPath);
            if (prop == null) {
                JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString("load manager-ssl.properties falied!"));
                System.exit(1);
            }
            String encryptPasswd = prop.getProperty(key);
            String plainPasswd = DSwareKMCUtil.decrypt(encryptPasswd, 2);
            JKSGeneratorForFSM.printString(plainPasswd);
        }
        catch (Exception e) {
            JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString(e.getMessage()));
            System.exit(1);
        }
    }

    private static void printString(String strReturnInfo) {
        System.out.println(strReturnInfo);
    }

    private static String getErrorReturnString(String strErrorInfo) {
        return FAILD_RESULT + LINE_SEPARATOR + strErrorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadFromAbsolutePath(String filePath) {
        FileInputStream stream = null;
        Properties properties = null;
        if (filePath == null) {
            JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString("filePath is null!"));
            System.exit(1);
        }
        try {
            File file = new File(filePath);
            if (file.exists()) {
                stream = new FileInputStream(file.getCanonicalPath());
                properties = new Properties();
                properties.load(stream);
            } else {
                JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString("File is not texis."));
                System.exit(1);
            }
            JKSGeneratorForFSM.closeStream(stream);
        }
        catch (IOException e) {
            JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString("Failed to load conf file"));
            System.exit(1);
            Properties properties2 = null;
            return properties2;
        }
        finally {
            JKSGeneratorForFSM.closeStream(stream);
        }
        return properties;
    }

    private static void closeStream(Closeable stream) {
        if (null == stream) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            JKSGeneratorForFSM.printString(JKSGeneratorForFSM.getErrorReturnString("close stream error."));
            System.exit(1);
        }
    }
}

