/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log;

import ch.qos.logback.classic.LoggerContext;
import com.huawei.us.common.log.log4j.filepermission.UsLog4jPermUtils;
import com.huawei.us.common.log.log4j2.filepermission.UsLog4j2PermUtils;
import com.huawei.us.common.log.logback.filepermission.UsLogbackPermUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.slf4j.Log4jLoggerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.Reload4jLoggerFactory;

public class UsLogPermUtils {
    private static final PrintStream SYS_OUT = System.out;
    private static final PrintStream SYS_ERROR = System.err;
    private static final Set<PosixFilePermission> LOG_FILE_PERMS = new HashSet<PosixFilePermission>();
    private static final Set<PosixFilePermission> LOG_DIR_PERMS = new HashSet<PosixFilePermission>();
    private static final Set<PosixFilePermission> LOG_ARCHIVE_PERMS = new HashSet<PosixFilePermission>();

    public static void doRestriction() {
        if ((SystemUtils.IS_OS_UNIX || SystemUtils.IS_OS_LINUX) && !UsLogPermUtils.isLogFrameworkExisted()) {
            throw new IllegalStateException("no log framework found, please check");
        }
    }

    private static boolean isLogFrameworkExisted() {
        boolean isLogFrameworkExisted = false;
        ILoggerFactory iLoggerFactory = LoggerFactory.getILoggerFactory();
        isLogFrameworkExisted = UsLogPermUtils.checkLog4j(iLoggerFactory);
        try {
            Class.forName("ch.qos.logback.classic.LoggerContext");
            if (iLoggerFactory instanceof LoggerContext) {
                UsLogbackPermUtils.changeAllFileAppenderPerms((LoggerContext)iLoggerFactory);
                isLogFrameworkExisted = true;
            }
        }
        catch (ClassNotFoundException ignore) {
            SYS_OUT.println("logback framework not found, skip");
        }
        try {
            Class.forName("org.apache.logging.slf4j.Log4jLoggerFactory");
            if (iLoggerFactory instanceof Log4jLoggerFactory) {
                UsLog4j2PermUtils.changeAllAppenderDirPerms();
                isLogFrameworkExisted = true;
            }
        }
        catch (ClassNotFoundException ignore) {
            SYS_OUT.println("log4j2 framework not found, skip");
        }
        return isLogFrameworkExisted;
    }

    private static boolean checkLog4j(ILoggerFactory iLoggerFactory) {
        try {
            Class.forName("org.slf4j.impl.Reload4jLoggerFactory");
            if (iLoggerFactory instanceof Reload4jLoggerFactory) {
                UsLog4jPermUtils.changeAllFileAppenderPerms();
                return true;
            }
        }
        catch (ClassNotFoundException ignore) {
            SYS_OUT.println("log4j framework not found, skip");
        }
        return false;
    }

    public static void changeFilePerms(String logPath) {
        if (logPath != null) {
            try {
                File logFile = new File(logPath);
                if (logFile.exists() && logFile.isFile()) {
                    Files.setPosixFilePermissions(logFile.toPath(), LOG_FILE_PERMS);
                }
            }
            catch (IOException | RuntimeException exception) {
                SYS_ERROR.println("set log file permission failed: " + exception);
            }
        }
    }

    public static void changeArchiveFilePerms(String archiveLogPath) {
        if (archiveLogPath != null) {
            try {
                File logFile = new File(archiveLogPath);
                if (logFile.exists() && logFile.isFile()) {
                    Files.setPosixFilePermissions(logFile.toPath(), LOG_ARCHIVE_PERMS);
                }
            }
            catch (IOException | RuntimeException exception) {
                SYS_ERROR.println("set archive log file permission failed: " + exception);
            }
        }
    }

    public static void changeLogDirPerms(String logPath) {
        if (logPath != null) {
            try {
                File logDir = new File(logPath).getParentFile();
                if (logDir != null && logDir.isDirectory()) {
                    Files.setPosixFilePermissions(logDir.toPath(), LOG_DIR_PERMS);
                }
            }
            catch (IOException | RuntimeException exception) {
                SYS_ERROR.println("set log directory permission failed: " + exception);
            }
        }
    }

    static {
        LOG_FILE_PERMS.add(PosixFilePermission.OWNER_READ);
        LOG_FILE_PERMS.add(PosixFilePermission.OWNER_WRITE);
        LOG_FILE_PERMS.add(PosixFilePermission.GROUP_READ);
        LOG_DIR_PERMS.add(PosixFilePermission.OWNER_READ);
        LOG_DIR_PERMS.add(PosixFilePermission.OWNER_WRITE);
        LOG_DIR_PERMS.add(PosixFilePermission.OWNER_EXECUTE);
        LOG_DIR_PERMS.add(PosixFilePermission.GROUP_READ);
        LOG_DIR_PERMS.add(PosixFilePermission.GROUP_EXECUTE);
        LOG_ARCHIVE_PERMS.add(PosixFilePermission.OWNER_READ);
        LOG_ARCHIVE_PERMS.add(PosixFilePermission.GROUP_READ);
    }
}

