/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.appender;

import com.huawei.us.common.log.UsLogUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.extras.DOMConfigurator;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.rolling.RollingPolicy;
import org.apache.log4j.rolling.RolloverDescription;
import org.apache.log4j.rolling.TriggeringPolicy;
import org.apache.log4j.rolling.helper.Action;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.OptionHandler;
import org.apache.log4j.xml.UnrecognizedElementHandler;
import org.w3c.dom.Element;

@Deprecated
public final class UsExtrasRollingFileAppender
extends FileAppender
implements UnrecognizedElementHandler {
    private volatile TriggeringPolicy triggeringPolicy;
    private volatile RollingPolicy rollingPolicy;
    private long fileLength = 0L;
    private Action lastRolloverAsyncAction = null;
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateOptions() {
        if (this.rollingPolicy == null) {
            LogLog.warn((String)("Please set a rolling policy for the RollingFileAppender named '" + this.getName() + "'"));
            return;
        }
        if (this.triggeringPolicy == null && this.rollingPolicy instanceof TriggeringPolicy) {
            this.triggeringPolicy = (TriggeringPolicy)this.rollingPolicy;
        }
        if (this.triggeringPolicy == null) {
            LogLog.warn((String)("Please set a TriggeringPolicy for the RollingFileAppender named '" + this.getName() + "'"));
            return;
        }
        IOException exception = null;
        Object object = this.lock;
        synchronized (object) {
            this.triggeringPolicy.activateOptions();
            this.rollingPolicy.activateOptions();
            try {
                RolloverDescription rollover = this.rollingPolicy.initialize(this.getFile(), this.getAppend());
                if (rollover != null) {
                    Action syncAction = rollover.getSynchronous();
                    if (syncAction != null) {
                        syncAction.execute();
                    }
                    this.setFile(rollover.getActiveFileName());
                    this.setAppend(rollover.getAppend());
                    this.lastRolloverAsyncAction = rollover.getAsynchronous();
                    if (this.lastRolloverAsyncAction != null) {
                        Thread runner = new Thread((Runnable)this.lastRolloverAsyncAction);
                        runner.setName("lastRolloverAsyncActionThread");
                        runner.setUncaughtExceptionHandler((ts, ep) -> LogLog.warn((String)("Exception during rollover, thread:" + ts), (Throwable)ep));
                        runner.start();
                    }
                }
                File activeFile = new File(this.getFile());
                this.fileLength = this.getAppend() ? activeFile.length() : 0L;
                super.activateOptions();
            }
            catch (IOException ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            LogLog.warn((String)("Exception while initializing RollingFileAppender named '" + this.getName() + "'"), (Throwable)exception);
        }
    }

    private QuietWriter createQuietWriter(Writer writer) {
        ErrorHandler handler = this.errorHandler;
        if (handler == null) {
            handler = new DefaultErrorHandler(this);
        }
        return new QuietWriter(writer, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rollover() {
        if (this.rollingPolicy == null) {
            return false;
        }
        IOException exception = null;
        Object object = this.lock;
        synchronized (object) {
            this.isNullLastRolloverAsyncAction();
            try {
                RolloverDescription rollover = this.rollingPolicy.rollover(this.getFile());
                if (rollover == null) {
                    return false;
                }
                this.closeWriter();
                if (rollover.getActiveFileName().equals(this.getFile())) {
                    boolean success = true;
                    if (rollover.getSynchronous() != null) {
                        success = false;
                        try {
                            success = rollover.getSynchronous().execute();
                        }
                        catch (IOException ex) {
                            exception = ex;
                        }
                    }
                    this.dealActiveFile(success, rollover, exception);
                } else {
                    OutputStreamWriter newWriter = this.createWriter(new FileOutputStream(rollover.getActiveFileName(), rollover.getAppend()));
                    this.setFile(rollover.getActiveFileName());
                    this.qw = this.createQuietWriter(newWriter);
                    boolean success = true;
                    if (rollover.getSynchronous() != null) {
                        success = false;
                        try {
                            success = rollover.getSynchronous().execute();
                        }
                        catch (IOException ex) {
                            exception = ex;
                        }
                    }
                    this.dealUnActiveFile(success, rollover);
                }
                return true;
            }
            catch (IOException ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            LogLog.warn((String)"Exception during rollover, rollover deferred.", (Throwable)exception);
        }
        return false;
    }

    private void isNullLastRolloverAsyncAction() {
        if (this.lastRolloverAsyncAction != null) {
            this.lastRolloverAsyncAction.close();
        }
    }

    private void dealActiveFile(boolean success, RolloverDescription rollover, Exception exception) throws IOException {
        if (success) {
            this.fileLength = rollover.getAppend() ? new File(rollover.getActiveFileName()).length() : 0L;
            if (rollover.getAsynchronous() != null) {
                this.lastRolloverAsyncAction = rollover.getAsynchronous();
                new Thread((Runnable)this.lastRolloverAsyncAction).start();
            }
            this.setFile(rollover.getActiveFileName(), rollover.getAppend(), this.bufferedIO, this.bufferSize);
        } else {
            this.setFile(rollover.getActiveFileName(), true, this.bufferedIO, this.bufferSize);
            if (exception == null) {
                LogLog.warn((String)"Failure in post-close rollover action");
            } else {
                LogLog.warn((String)"Exception in post-close rollover action", (Throwable)exception);
            }
        }
    }

    private void dealUnActiveFile(boolean success, RolloverDescription rollover) {
        if (success) {
            this.fileLength = rollover.getAppend() ? new File(rollover.getActiveFileName()).length() : 0L;
            if (rollover.getAsynchronous() != null) {
                this.lastRolloverAsyncAction = rollover.getAsynchronous();
                new Thread((Runnable)this.lastRolloverAsyncAction).start();
            }
        }
        this.writeHeader();
    }

    protected void subAppend(LoggingEvent event) {
        if (this.triggeringPolicy.isTriggeringEvent((Appender)this, event, this.getFile(), this.getFileLength())) {
            try {
                this.rollover();
            }
            catch (Exception ex) {
                LogLog.warn((String)"Exception during rollover attempt.", (Throwable)ex);
            }
        }
        super.subAppend(UsLogUtils.buildUsLoggingEvent(event, true));
    }

    public void append(LoggingEvent event) {
        super.append(UsLogUtils.buildUsLoggingEvent(event, true));
    }

    public RollingPolicy getRollingPolicy() {
        return this.rollingPolicy;
    }

    public void setRollingPolicy(RollingPolicy policy) {
        this.rollingPolicy = policy;
    }

    public TriggeringPolicy getTriggeringPolicy() {
        return this.triggeringPolicy;
    }

    public void setTriggeringPolicy(TriggeringPolicy policy) {
        this.triggeringPolicy = policy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.lastRolloverAsyncAction != null) {
                this.lastRolloverAsyncAction.close();
            }
        }
        super.close();
    }

    protected OutputStreamWriter createWriter(OutputStream os) {
        return super.createWriter((OutputStream)new CountingOutputStream(os, this));
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public synchronized void incrementFileLength(int increment) {
        this.fileLength += (long)increment;
    }

    public boolean parseUnrecognizedElement(Element element, Properties props) throws Exception {
        String nodeName = element.getNodeName();
        if ("rollingPolicy".equals(nodeName)) {
            OptionHandler rollingPolicyTmp = DOMConfigurator.parseElement((Element)element, (Properties)props, RollingPolicy.class);
            if (rollingPolicyTmp != null) {
                rollingPolicyTmp.activateOptions();
                if (rollingPolicyTmp instanceof RollingPolicy) {
                    this.setRollingPolicy((RollingPolicy)rollingPolicyTmp);
                }
            }
            return true;
        }
        if ("triggeringPolicy".equals(nodeName)) {
            OptionHandler triggerPolicy = DOMConfigurator.parseElement((Element)element, (Properties)props, TriggeringPolicy.class);
            if (triggerPolicy != null) {
                triggerPolicy.activateOptions();
                if (triggerPolicy instanceof TriggeringPolicy) {
                    this.setTriggeringPolicy((TriggeringPolicy)triggerPolicy);
                }
            }
            return true;
        }
        return false;
    }

    private static final class DefaultErrorHandler
    implements ErrorHandler {
        private final UsExtrasRollingFileAppender appender;

        public DefaultErrorHandler(UsExtrasRollingFileAppender appender) {
            this.appender = appender;
        }

        public void setLogger(Logger logger) {
        }

        public void error(String message, Exception ioe, int errorCode) {
            this.appender.close();
            LogLog.error((String)("IO failure for appender named " + this.appender.getName()), (Throwable)ioe);
        }

        public void error(String message) {
        }

        public void error(String message, Exception exception, int errorCode, LoggingEvent event) {
        }

        public void setAppender(Appender appender) {
        }

        public void setBackupAppender(Appender appenderInput) {
        }

        public void activateOptions() {
        }
    }

    private static class CountingOutputStream
    extends OutputStream {
        private final OutputStream os;
        private final UsExtrasRollingFileAppender rfa;

        public CountingOutputStream(OutputStream os, UsExtrasRollingFileAppender rfa) {
            this.os = os;
            this.rfa = rfa;
        }

        @Override
        public void close() throws IOException {
            this.os.close();
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            this.os.write(bytes);
            this.rfa.incrementFileLength(bytes.length);
        }

        @Override
        public void write(byte[] bytes, int off, int len) throws IOException {
            this.os.write(bytes, off, len);
            this.rfa.incrementFileLength(len);
        }

        @Override
        public void write(int bs) throws IOException {
            this.os.write(bs);
            this.rfa.incrementFileLength(1);
        }
    }
}

