/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.desensitiser;

import com.huawei.us.common.log.desensitiser.masker.Masker;
import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.AhoCorasicSearchProcessorFactory;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class Desensitizer {
    private final AhoCorasicSearchProcessorFactory factory;
    private final Masker[] maskers;

    public Desensitizer(List<Masker> maskerList) {
        LinkedHashMap<String, Masker> maskerMap = new LinkedHashMap<String, Masker>();
        for (Masker masker : maskerList) {
            String key2 = masker.getKey().toLowerCase(Locale.ROOT);
            maskerMap.putIfAbsent(key2, masker);
        }
        this.maskers = maskerMap.values().toArray(new Masker[0]);
        byte[][] needles = (byte[][])maskerMap.keySet().stream().map(key -> key.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        this.factory = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])needles);
    }

    public String desensitize(String input) {
        int searchStartIdx;
        if (StringUtils.isEmpty((CharSequence)input)) {
            return input;
        }
        AhoCorasicSearchProcessorFactory.Processor processor = this.factory.newSearchProcessor();
        int keyEndIdx = this.searchKey(processor, input, searchStartIdx = 0, input.length());
        if (keyEndIdx < 0) {
            return input;
        }
        StringBuilder builder = new StringBuilder(input.length());
        int copyStartIdx = 0;
        int lastKeyStartIdx = -1;
        int lastBuilderLen = 0;
        int lastCopyStartIdx = 0;
        while (keyEndIdx >= 0) {
            Masker masker = this.maskers[processor.getFoundNeedleId()];
            int keyStartIdx = keyEndIdx - masker.getKey().length() + 1;
            if (keyStartIdx <= lastKeyStartIdx) {
                builder.setLength(lastBuilderLen);
                copyStartIdx = lastCopyStartIdx;
            }
            lastCopyStartIdx = copyStartIdx;
            lastBuilderLen = builder.length();
            lastKeyStartIdx = keyStartIdx;
            copyStartIdx = masker.mask(input, keyStartIdx, keyEndIdx, copyStartIdx, builder);
            searchStartIdx = keyEndIdx + 1;
            keyEndIdx = this.searchKey(processor, input, searchStartIdx, input.length());
        }
        if (copyStartIdx < input.length() - 1) {
            builder.append(input, copyStartIdx, input.length());
        }
        return builder.toString();
    }

    private int searchKey(AhoCorasicSearchProcessorFactory.Processor processor, String input, int start, int end) {
        while (start < end) {
            if (!this.caseInsensitiveProcess(processor, (byte)input.charAt(start))) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private boolean caseInsensitiveProcess(AhoCorasicSearchProcessorFactory.Processor processor, byte value) {
        value = (byte)Character.toLowerCase(value);
        return processor.process(value);
    }
}

