/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.logback.encoder;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.PatternLayoutEncoderBase;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import com.huawei.us.common.log.logback.UsLogbackUtils;
import com.huawei.us.common.log.logback.converter.UsEnsureExceptionHandling;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsPatternLayoutEncoder
extends PatternLayoutEncoderBase<ILoggingEvent> {
    private static final Logger logger = LoggerFactory.getLogger(UsPatternLayoutEncoder.class);
    private static final String SENSITIVE_FILTER_OFF = "off";
    String sensitiveFilter;

    public String getSensitiveFilter() {
        return this.sensitiveFilter;
    }

    public void setSensitiveFilter(String sensitiveFilter) {
        this.sensitiveFilter = sensitiveFilter;
    }

    public void start() {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.context);
        patternLayout.setPattern(this.getPattern());
        patternLayout.setOutputPatternAsHeader(this.outputPatternAsHeader);
        patternLayout.setPostCompileProcessor((PostCompileProcessor)new UsEnsureExceptionHandling());
        patternLayout.start();
        this.layout = patternLayout;
        super.start();
    }

    private byte[] convertToBytes(String string) {
        Charset charset = this.getCharset();
        if (charset == null) {
            return string.getBytes(StandardCharsets.UTF_8);
        }
        return string.getBytes(charset);
    }

    public byte[] encode(ILoggingEvent event) {
        try {
            if (event != null) {
                UsLogbackUtils.doReflectFilter(event, !SENSITIVE_FILTER_OFF.equals(this.sensitiveFilter));
                return this.convertToBytes(this.layout.doLayout((Object)event));
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("Unknown log event: {}", (Object)e.getMessage());
        }
        return new byte[0];
    }

    static {
        UsLogbackUtils.initUsThrowableConverterMap();
    }
}

