/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.logback.layout;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.huawei.us.common.log.logback.UsLogbackUtils;
import com.huawei.us.common.log.logback.converter.UsEnsureExceptionHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsPatternLayout
extends PatternLayout {
    private static final Logger logger = LoggerFactory.getLogger(UsPatternLayout.class);
    private static final String SENSITIVE_FILTER_OFF = "off";
    String sensitiveFilter;

    public String getSensitiveFilter() {
        return this.sensitiveFilter;
    }

    public void setSensitiveFilter(String sensitiveFilter) {
        this.sensitiveFilter = sensitiveFilter;
    }

    public UsPatternLayout() {
        this.postCompileProcessor = new UsEnsureExceptionHandling();
    }

    public String doLayout(ILoggingEvent event) {
        try {
            if (event != null) {
                UsLogbackUtils.doReflectFilter(event, !SENSITIVE_FILTER_OFF.equals(this.sensitiveFilter));
                return super.doLayout(event);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.error("Unknown log event: " + e.getMessage());
        }
        return "";
    }

    static {
        UsLogbackUtils.initUsThrowableConverterMap();
    }
}

