/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.logback.rollingpolicy;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import com.huawei.us.common.log.UsLogPermUtils;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

public class UsCompressor
extends Compressor {
    private final Compressor compressor;
    private final CompressionMode compressionMode;

    public UsCompressor(CompressionMode compressionMode, Compressor compressor) {
        super(compressionMode);
        this.compressionMode = compressionMode;
        this.compressor = compressor;
    }

    public void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        this.compressor.compress(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
        String archiveLogFilename = this.addExtensionIfNecessary(nameOfCompressedFile);
        UsLogPermUtils.changeArchiveFilePerms(archiveLogFilename);
        UsLogPermUtils.changeLogDirPerms(archiveLogFilename);
    }

    private String addExtensionIfNecessary(String nameOfCompressedFile) {
        switch (this.compressionMode) {
            case GZ: {
                if (nameOfCompressedFile.endsWith(".gz")) break;
                return nameOfCompressedFile + ".gz";
            }
            case ZIP: {
                if (nameOfCompressedFile.endsWith(".zip")) break;
                return nameOfCompressedFile + ".zip";
            }
            case NONE: {
                throw new UnsupportedOperationException("compress method called in NONE compression mode");
            }
            default: {
                throw new UnsupportedOperationException("unknown error");
            }
        }
        return nameOfCompressedFile;
    }

    public String toString() {
        return this.compressor.toString();
    }

    public Future<?> asyncCompress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) throws RolloverFailure {
        CompressionRunnable runnable = new CompressionRunnable(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
        ScheduledExecutorService executorService = this.compressor.getContext().getScheduledExecutorService();
        return executorService.submit(runnable);
    }

    public Context getContext() {
        return this.compressor.getContext();
    }

    public void setContext(Context context) {
        this.compressor.setContext(context);
    }

    public StatusManager getStatusManager() {
        return this.compressor.getStatusManager();
    }

    public void addStatus(Status status) {
        this.compressor.addStatus(status);
    }

    public void addInfo(String msg) {
        this.compressor.addInfo(msg);
    }

    public void addInfo(String msg, Throwable ex) {
        this.compressor.addInfo(msg, ex);
    }

    public void addWarn(String msg) {
        this.compressor.addWarn(msg);
    }

    public void addWarn(String msg, Throwable ex) {
        this.compressor.addWarn(msg, ex);
    }

    public void addError(String msg) {
        this.compressor.addError(msg);
    }

    public void addError(String msg, Throwable ex) {
        this.compressor.addError(msg, ex);
    }

    class CompressionRunnable
    implements Runnable {
        final String nameOfFile2Compress;
        final String nameOfCompressedFile;
        final String innerEntryName;

        public CompressionRunnable(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
            this.nameOfFile2Compress = nameOfFile2Compress;
            this.nameOfCompressedFile = nameOfCompressedFile;
            this.innerEntryName = innerEntryName;
        }

        @Override
        public void run() {
            UsCompressor.this.compress(this.nameOfFile2Compress, this.nameOfCompressedFile, this.innerEntryName);
        }
    }
}

