/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.log.tools;

import com.huawei.us.common.log.desensitiser.Desensitizer;
import com.huawei.us.common.log.desensitiser.masker.Masker;
import com.huawei.us.common.log.desensitiser.masker.ValueMasker;
import com.huawei.us.common.resource.SystemConfigUtil;
import java.util.ArrayList;
import java.util.List;

public class SensitiveFilterACTools {
    private static final String DEFAULT_MASK = SystemConfigUtil.getStringValueByName("ac.sensitive.replacement", "*****#*#*****");
    private static final List<Masker> MASKER_LIST = new ArrayList<Masker>();
    private static final Desensitizer desensitizer;

    public static String filterSensitiveMsg(String input) {
        return desensitizer.desensitize(input);
    }

    public static ArrayList<ValueMasker> createValueMasker(String[] keys, int length) {
        ArrayList<ValueMasker> list = new ArrayList<ValueMasker>();
        for (String key : keys) {
            list.add(new ValueMasker(key, DEFAULT_MASK, length));
        }
        return list;
    }

    private static void setMaskerList(String sensitiveList) {
        String[] arr;
        for (String str : arr = sensitiveList.split("}")) {
            String list = str.split("\\)\\{")[0].substring(1);
            String[] keys = list.split("\\|");
            int length = Integer.parseInt(str.split("\\)\\{")[1]);
            MASKER_LIST.addAll(SensitiveFilterACTools.createValueMasker(keys, length));
        }
    }

    static {
        String sensitiveList = SystemConfigUtil.getStringValueByName("ac.sensitive.field.list.regexp", "(session|decrypt|mima|sharekey|checkpwd|crypto|cardno|PINNUMBER|encrypt|register|secret|passwd|password|udaConnection|udaUserPasswd|uupd|credential|zookeeperAuthInfo|TLS|zookeeperAuthInfoNoTime|auth|token|pwd|dec|enc|pswd|pin|sms|email|mail|personal|phonenumber|PhoneNum|Location|cookie|GPS|Phone|latitude|longitude|aes|cbc|ebc|MD5|SHA1|RSA|DESKeySpec|HMAC|CNY|USD|DSA|DES|base64|IMEI|MEID|IMSI|admin|suites|administrator|authenticationcode|caInfo|deviceId|deviceName|fixation|ftpid|ftppass|ftppasswd|ftppassword|ftpuser|imapuser|loginId|loginname|mac|pass|passcode|privilege|profileId|root|sharecode|subscriberId|superuser|tgt|sysadmin|uid|verfiycode|sshusr|msisdn|ticket|version){20}");
        SensitiveFilterACTools.setMaskerList(sensitiveList);
        desensitizer = new Desensitizer(MASKER_LIST);
    }
}

