/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.password;

import com.huawei.us.common.resource.SystemConfigUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PwdComplexUtils {
    private static final Logger logger = LoggerFactory.getLogger(PwdComplexUtils.class);
    private static final String LOW_CASE_CHAR = "abcdefghijklmnopqrstuvwxyz";
    private static final String TOP_CASE_CHAR = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String DIGITAL_CHAR = "0123456789";
    private static final String SPECIAL_CHAR = "`~!@#$%^&*()-_=+\\|[{}];:'\",<.>/? ";

    public static boolean checkPwd(String password) {
        return PwdComplexUtils.checkPwdComplex(null, password, false, null);
    }

    public static boolean checkPwd(String password, boolean isSpecialUser) {
        return PwdComplexUtils.checkPwdComplex(null, password, isSpecialUser, null);
    }

    public static boolean checkPwd(String userName, String password) {
        return PwdComplexUtils.checkPwdComplex(userName, password, false, null);
    }

    public static boolean checkPwd(String userName, String password, boolean isSpecialUser) {
        return PwdComplexUtils.checkPwdComplex(userName, password, isSpecialUser, null);
    }

    public static boolean checkPwd(String password, boolean isSpecialUser, int minPwdLength) {
        return PwdComplexUtils.checkPwdComplex(null, password, isSpecialUser, minPwdLength);
    }

    public static boolean checkPwd(String userName, String password, boolean isSpecialUser, int minPwdLength) {
        return PwdComplexUtils.checkPwdComplex(userName, password, isSpecialUser, minPwdLength);
    }

    private static boolean checkPwdComplex(String userName, String password, boolean isSpecialUser, Integer minPwdLength) {
        Map<String, Integer> lenMap = PwdComplexUtils.getLenMap();
        Integer minPwdLen = lenMap.get("minPwdLen");
        Integer minSpecialUserPwdLen = lenMap.get("minSpecialUserPwdLen");
        Integer maxPwdLen = lenMap.get("maxPwdLen");
        Integer combinatNum = lenMap.get("combinatNum");
        if (isSpecialUser) {
            if (null == minPwdLength) {
                minPwdLength = minSpecialUserPwdLen;
            } else if (minPwdLength < minSpecialUserPwdLen || minPwdLength > maxPwdLen) {
                logger.error("The parameter error.");
                return false;
            }
        } else if (null == minPwdLength) {
            minPwdLength = minPwdLen;
        } else if (minPwdLength < minPwdLen || minPwdLength > maxPwdLen) {
            logger.error("The parameter error.");
            return false;
        }
        if (!PwdComplexUtils.checkPwdLength(password, minPwdLength, maxPwdLen)) {
            return false;
        }
        if (!PwdComplexUtils.checkPwdAndUserName(userName, password)) {
            return false;
        }
        if (!PwdComplexUtils.combinatPasswd(password, combinatNum)) {
            return false;
        }
        return PwdComplexUtils.continuationChar(password);
    }

    private static boolean checkPwdLength(String password, int minPwdLength, int maxPwdLength) {
        if (StringUtils.isEmpty((CharSequence)password) || password.length() < minPwdLength || password.length() > maxPwdLength) {
            logger.error("[ValidateParameter]The password length error.");
            return false;
        }
        return true;
    }

    private static boolean checkPwdAndUserName(String userName, String password) {
        if (StringUtils.isNotEmpty((CharSequence)userName)) {
            if (password.equals(userName)) {
                logger.error("[ValidateParameter]The same password and username error.");
                return false;
            }
            StringBuffer reverse = new StringBuffer(userName);
            if (password.equals(reverse.reverse().toString())) {
                logger.error("[ValidateParameter]The password and username error.");
                return false;
            }
        }
        return true;
    }

    private static boolean combinatPasswd(String password, Integer combinatNum) {
        char[] valueChar;
        boolean hasLowCase = false;
        boolean hasTopCase = false;
        boolean hasDigital = false;
        boolean hsaSpecialChar = false;
        boolean other = false;
        for (char c : valueChar = password.toCharArray()) {
            if (LOW_CASE_CHAR.indexOf(c) != -1) {
                hasLowCase = true;
                continue;
            }
            if (TOP_CASE_CHAR.indexOf(c) != -1) {
                hasTopCase = true;
                continue;
            }
            if (DIGITAL_CHAR.indexOf(c) != -1) {
                hasDigital = true;
                continue;
            }
            if (SPECIAL_CHAR.indexOf(c) != -1) {
                hsaSpecialChar = true;
                continue;
            }
            other = true;
            break;
        }
        if (other) {
            logger.error("[ValidateParameter]The password contains other char.");
            return false;
        }
        int count = 0;
        if (hasLowCase) {
            ++count;
        }
        if (hasTopCase) {
            ++count;
        }
        if (hasDigital) {
            ++count;
        }
        if (hsaSpecialChar) {
            ++count;
        }
        return count >= combinatNum;
    }

    private static boolean continuationChar(String password) {
        char[] charArray = password.toCharArray();
        boolean continualChar = true;
        for (int index = 0; index < charArray.length; ++index) {
            if (index + 2 >= charArray.length || charArray[index] != charArray[index + 1] || charArray[index + 1] != charArray[index + 2]) continue;
            continualChar = false;
            break;
        }
        return continualChar;
    }

    private static Map<String, Integer> getLenMap() {
        HashMap<String, Integer> lenMap = new HashMap<String, Integer>();
        String minPwdLen = SystemConfigUtil.getStringValueByName("min.pwd.len", "8");
        String maxPwdLen = SystemConfigUtil.getStringValueByName("max.pwd.len", "128");
        String minSpecialUserPwdLen = SystemConfigUtil.getStringValueByName("min.special.user.pwd.len", "10");
        String combinatNum = SystemConfigUtil.getStringValueByName("pwd.combinat.num", "3");
        if (StringUtils.isNotEmpty((CharSequence)minPwdLen) && StringUtils.isNotEmpty((CharSequence)maxPwdLen) && StringUtils.isNotEmpty((CharSequence)minSpecialUserPwdLen) && StringUtils.isNotEmpty((CharSequence)combinatNum)) {
            lenMap.put("minPwdLen", Integer.valueOf(minPwdLen));
            lenMap.put("maxPwdLen", Integer.valueOf(maxPwdLen));
            lenMap.put("minSpecialUserPwdLen", Integer.valueOf(minSpecialUserPwdLen));
            lenMap.put("combinatNum", Integer.valueOf(combinatNum));
        }
        return lenMap;
    }
}

