/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer;

import com.huawei.us.common.regexfuzzer.executor.TimeoutRegexFuzzer;
import com.huawei.us.common.regexfuzzer.utils.UnKnownException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexFuzzer {
    private static final Logger logger = LoggerFactory.getLogger(RegexFuzzer.class);
    public static final int NO_TIMEOUT = -1;
    private static volatile TimeoutRegexFuzzer fuzzer = null;

    private RegexFuzzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TimeoutRegexFuzzer getFuzzer() {
        if (fuzzer != null) return fuzzer;
        Class<RegexFuzzer> clazz = RegexFuzzer.class;
        synchronized (RegexFuzzer.class) {
            if (fuzzer != null) return fuzzer;
            fuzzer = new TimeoutRegexFuzzer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fuzzer;
        }
    }

    public static Boolean isVulnerable(String regex) {
        return RegexFuzzer.isVulnerable(regex, -1);
    }

    public static Boolean isVulnerable(String regex, int timeout) {
        try {
            return RegexFuzzer.getFuzzer().fuzz(regex, timeout);
        }
        catch (IllegalStateException e) {
            logger.error("IllegalStateException error!", (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            logger.error("Regex fuzzer error!", e);
            return false;
        }
    }

    public static Boolean isVulnerable(String regex, boolean strongMode) {
        return RegexFuzzer.isVulnerable(regex, -1, strongMode);
    }

    public static Boolean isVulnerable(String regex, int timeout, boolean strongMode) {
        try {
            return RegexFuzzer.getFuzzer().fuzz(regex, timeout, strongMode);
        }
        catch (IllegalStateException e) {
            logger.error("IllegalStateException error!", (Throwable)e);
            return false;
        }
        catch (Throwable e) {
            logger.error("Regex fuzzer error!", e);
            return false;
        }
    }

    public static boolean isVulnerable(String regex, long timeout, TimeUnit unit) throws TimeoutException, UnKnownException {
        return RegexFuzzer.isVulnerable(regex, timeout, unit, false);
    }

    public static boolean isVulnerable(String regex, long timeout, TimeUnit unit, boolean strongMode) throws TimeoutException, UnKnownException {
        return RegexFuzzer.getFuzzer().fuzz(regex, timeout, unit, strongMode);
    }
}

