/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions;

import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.Strategy;
import java.util.Collections;
import java.util.Set;

public class Atom
implements Expression {
    public static final Atom EMPTY = new Atom();
    private final String pattern;

    public Atom(String pattern) {
        this.pattern = pattern;
    }

    public Atom() {
        this("");
    }

    public static Atom clone(String pattern) {
        return new Atom(pattern);
    }

    @Override
    public boolean isEmpty() {
        return this.pattern.isEmpty();
    }

    @Override
    public Expression intersect(Expression other) {
        for (int i = 0; i < this.pattern.length(); ++i) {
            String tail = this.pattern.substring(i);
            if (!this.startsWith(other, tail)) continue;
            return Atom.clone(tail);
        }
        return EMPTY;
    }

    private boolean startsWith(Expression source, String prefix) {
        if (prefix.length() > Collections.max(source.lengthOptions())) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (source.matchAt(i, prefix.charAt(i)).equals((Object)Expression.Match.MATCH)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression.Match matchAt(int index, char ch) {
        if (index < Collections.max(this.lengthOptions())) {
            return this.pattern.charAt(index) == ch ? Expression.Match.MATCH : Expression.Match.NO_MATCH;
        }
        return Expression.Match.OUT_OF_RANGE;
    }

    public String toString() {
        return this.pattern;
    }

    @Override
    public Set<Integer> lengthOptions() {
        return Collections.singleton(this.pattern.length());
    }

    @Override
    public Expression simplify() {
        return this;
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof Expression) {
            obj = ((Expression)obj).simplify();
        }
        if (obj instanceof Atom) {
            Atom atom = (Atom)obj;
            return this.pattern.equals(atom.pattern);
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public Payloads payloads(Strategy strategy) {
        return strategy.atom(this.pattern);
    }
}

