/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions;

import com.huawei.us.common.regexfuzzer.expressions.Atom;
import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.expressions.Optional;
import com.huawei.us.common.regexfuzzer.expressions.RecursiveRepetition;
import com.huawei.us.common.regexfuzzer.expressions.Sequence;

public class IterativeRepetition
extends RecursiveRepetition {
    public IterativeRepetition(Expression pattern, int start, int end) {
        super(pattern, start, end);
    }

    public static IterativeRepetition clone(Expression pattern, int end) {
        return new IterativeRepetition(pattern, end, end);
    }

    public static IterativeRepetition clone(Expression pattern, int start, int end) {
        return new IterativeRepetition(pattern, start, end);
    }

    protected static Expression optionalSequence(Expression pattern, int times) {
        Expression expression = Atom.EMPTY;
        for (int i = 0; i < times; ++i) {
            expression = Sequence.clone(expression, Optional.clone(pattern));
        }
        return expression;
    }

    @Override
    protected Expression substitute(Expression pattern, int start, int end) {
        int repetition = Math.min(end, 45);
        Expression newpattern = pattern.simplify();
        if (repetition < start) {
            throw new IllegalArgumentException();
        }
        if (repetition == start) {
            return IterativeRepetition.sequence(newpattern, start);
        }
        return Sequence.clone(IterativeRepetition.sequence(newpattern, start), IterativeRepetition.optionalSequence(newpattern, repetition - start)).simplify();
    }
}

