/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.expressions;

import com.huawei.us.common.regexfuzzer.expressions.Expression;
import com.huawei.us.common.regexfuzzer.payloads.Payloads;
import com.huawei.us.common.regexfuzzer.strategy.Strategy;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class Option
implements Expression {
    private final Expression expa;
    private final Expression expb;

    public Option(Expression expa, Expression expb) {
        this.expa = expa.simplify();
        this.expb = expb.simplify();
    }

    public static Option clone(Expression expa, Expression expb) {
        return new Option(expa, expb);
    }

    @Override
    public boolean isEmpty() {
        return this.expa.isEmpty() && this.expb.isEmpty();
    }

    @Override
    public Payloads payloads(Strategy strategy) {
        return strategy.option(this.expa.payloads(strategy), this.expb.payloads(strategy));
    }

    @Override
    public Expression intersect(Expression option) {
        return Option.clone(this.expa.intersect(option), this.expb.intersect(option)).simplify();
    }

    @Override
    public Expression.Match matchAt(int index, char ch) {
        return this.expa.matchAt(index, ch).equals((Object)Expression.Match.MATCH) ? Expression.Match.MATCH : this.expb.matchAt(index, ch);
    }

    @Override
    public Set<Integer> lengthOptions() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.addAll(this.expa.lengthOptions());
        set.addAll(this.expb.lengthOptions());
        return set;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "(%s|%s)", this.expa.toString(), this.expb.toString());
    }

    @Override
    public Expression simplify() {
        if (this.expa.isEmpty()) {
            return this.expb;
        }
        if (this.expb.isEmpty()) {
            return this.expa;
        }
        if (this.expa.equals(this.expb)) {
            return this.expa;
        }
        return this;
    }

    public boolean equals(Object other) {
        Object obj = other;
        if (obj instanceof Expression) {
            obj = ((Expression)obj).simplify();
        }
        if (obj instanceof Option) {
            Option option = (Option)obj;
            return this.expa.equals(option.expa) && this.expb.equals(option.expb);
        }
        Expression expression = this.simplify();
        if (expression instanceof Option) {
            return false;
        }
        return expression.equals(obj);
    }

    public int hashCode() {
        Expression self = this.simplify();
        if (self instanceof Option) {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.expa.hashCode();
            result = 31 * result + this.expb.hashCode();
            return result;
        }
        return self.hashCode();
    }
}

