/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.parser;

import com.huawei.us.common.regexfuzzer.parser.Regex;

public class EscapeCharacterParser {
    private EscapeCharacterParser() {
        throw new IllegalStateException("Utility class");
    }

    public static char unescapeCurrent(Regex regex) {
        regex.consumeNextChar();
        if (regex.isEmpty()) {
            regex.error("Premature end of expression after \\");
        }
        try {
            char ch = regex.consumeNextChar();
            int index = "nrtaefv".indexOf(ch);
            if (ch == 'x') {
                return EscapeCharacterParser.decodeANSI(regex);
            }
            if (EscapeCharacterParser.isSeparator(ch)) {
                return EscapeCharacterParser.getSeparator(ch);
            }
            if (Character.isLetter(ch)) {
                regex.error("Unsupported escape sequence \\" + ch);
                return ch;
            }
            return ch;
        }
        catch (NumberFormatException e) {
            regex.error("Malformed ANSI code: " + e.getMessage(), e);
            return '\u0000';
        }
    }

    private static char decodeANSI(Regex regex) {
        if (regex.length() >= 2) {
            String code = regex.consumeUntil(2);
            return (char)Integer.parseInt(code, 16);
        }
        throw new NumberFormatException("Malformed ANSI code: " + regex.consumeAll());
    }

    private static boolean isSeparator(char ch) {
        return "nrtaefv".indexOf(ch) != -1;
    }

    private static char getSeparator(char ch) {
        int index = "nrtaefv".indexOf(ch);
        return "\n\r\t\u0007\u001b\f\u000b".charAt(index);
    }
}

