/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.us.common.regexfuzzer.parser;

import java.util.regex.PatternSyntaxException;

public class Regex {
    private final String original;
    private String regex;
    private int offset;

    public Regex(String regex, int offset) {
        this.regex = regex;
        this.offset = offset;
        this.original = regex;
    }

    public Regex(String regex) {
        this(regex, 0);
    }

    public boolean startWith(String prefix) {
        return this.regex.startsWith(prefix);
    }

    public boolean startWith(char ch) {
        return this.regex.charAt(0) == ch;
    }

    public char charAt(int index) {
        return this.regex.charAt(index);
    }

    public char consumeNextChar() {
        char ch = this.regex.charAt(0);
        this.regex = this.regex.substring(1);
        ++this.offset;
        return ch;
    }

    public String consumeUntil(int beginIndex) {
        String temp = this.regex.substring(0, beginIndex);
        this.regex = this.regex.substring(beginIndex);
        this.offset += beginIndex;
        return temp;
    }

    public void consumeToken(String token) {
        if (!this.regex.startsWith(token)) {
            throw new IllegalStateException("not started by " + token);
        }
        this.consumeUntil(token.length());
    }

    void consumeWhiteSpace() {
        while (!this.regex.isEmpty() && this.regex.charAt(0) == ' ') {
            this.consumeToken(" ");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            return this.regex.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    public int length() {
        return this.regex.length();
    }

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public String consumeAll() {
        String rest = this.regex;
        this.offset += this.regex.length();
        this.regex = "";
        return rest;
    }

    public String toString() {
        return this.regex;
    }

    public void error(String description) {
        throw new PatternSyntaxException(description, this.original, this.offset);
    }

    public void error(String description, Throwable throwable) {
        PatternSyntaxException exception = new PatternSyntaxException(description, this.original, this.offset);
        exception.initCause(throwable);
        throw exception;
    }
}

